/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import jetbrick.io.resource.Resource;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.JdkUtils;

public final class FileConvertor
implements Convertor<File> {
    public static final FileConvertor INSTANCE = new FileConvertor();

    @Override
    public File convert(String value) {
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    @Override
    public File convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        if (value.getClass() == URL.class) {
            try {
                String s = URLDecoder.decode(((URL)value).getPath(), "utf-8");
                return new File(s);
            }
            catch (UnsupportedEncodingException e) {
                throw TypeCastException.create(value, URI.class, e);
            }
        }
        if (value.getClass() == URI.class) {
            try {
                String s = URLDecoder.decode(((URI)value).getPath(), "utf-8");
                return new File(s);
            }
            catch (UnsupportedEncodingException e) {
                throw TypeCastException.create(value, URI.class, e);
            }
        }
        if (value instanceof Resource) {
            return ((Resource)value).getFile();
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_7 && value instanceof Path) {
            return ((Path)value).toFile();
        }
        return this.convert(value.toString());
    }

    public static void main(String[] args) {
        File f = new FileConvertor().convert(new Object());
        System.out.println(f.getClass().getName() + ": " + f);
    }
}

