/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import jetbrick.io.resource.Resource;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class PathConvertor
implements Convertor<Path> {
    public static final PathConvertor INSTANCE = new PathConvertor();

    @Override
    public Path convert(String value) {
        if (value == null) {
            return null;
        }
        return Paths.get(value, new String[0]);
    }

    @Override
    public Path convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Path) {
            return (Path)value;
        }
        if (value instanceof File) {
            return ((File)value).toPath();
        }
        if (value.getClass() == URL.class) {
            try {
                return Paths.get(((URL)value).toURI());
            }
            catch (URISyntaxException e) {
                throw TypeCastException.create(value, URI.class, e);
            }
        }
        if (value instanceof Resource) {
            return Paths.get(((Resource)value).getURI());
        }
        if (value.getClass() == URI.class) {
            return Paths.get((URI)value);
        }
        return this.convert(value.toString());
    }
}

