/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class ShortConvertor
implements Convertor<Short> {
    public static final ShortConvertor INSTANCE = new ShortConvertor();

    @Override
    public Short convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Short.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Short.class, e);
        }
    }

    @Override
    public Short convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Short.class) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return this.convert(value.toString());
    }
}

