/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.sql.Clob;
import java.sql.SQLException;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.ArrayUtils;

public final class StringConvertor
implements Convertor<String> {
    public static StringConvertor INSTANCE = new StringConvertor();

    @Override
    public String convert(String value) {
        return value;
    }

    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        Class<?> type = value.getClass();
        if (type == Class.class) {
            return ((Class)value).getName();
        }
        if (type.isArray()) {
            return ArrayUtils.toString(value);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TypeCastException("Clob is too big.");
                }
                return clob.getSubString(1L, (int)length);
            }
            catch (SQLException e) {
                throw TypeCastException.create(value, String.class, e);
            }
        }
        return value.toString();
    }
}

