/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jetbrick.util.ArrayUtils;

public class AppException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String lineSeparator = System.getProperty("line.separator");
    private Object[] args;
    private Map<String, Object> props;

    public static AppException unchecked(Throwable e) {
        if (e instanceof AppException) {
            return (AppException)e;
        }
        return new AppException(e);
    }

    public AppException() {
    }

    public AppException(String message, Object ... args) {
        super(message);
        this.args = args;
    }

    public AppException(Throwable cause) {
        super(cause);
    }

    public AppException(Throwable cause, String message, Object ... args) {
        super(message, cause);
        this.args = args;
    }

    public Map<String, Object> getProperties() {
        if (this.props == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.props);
    }

    public Object get(String name) {
        return this.props == null ? null : this.props.get(name);
    }

    public AppException set(String name, Object value) {
        if (this.props == null) {
            this.props = new LinkedHashMap<String, Object>();
        }
        this.props.put(name, value);
        return this;
    }

    public String getSimpleMessage() {
        String message = super.getMessage();
        if (message != null && this.args != null && this.args.length > 0) {
            message = String.format(message, this.args);
        }
        return message;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        String message = this.getSimpleMessage();
        if (message != null) {
            sb.append(message);
        }
        if (this.props != null) {
            for (String key : this.props.keySet()) {
                Object value;
                if (sb.length() > 0) {
                    sb.append(lineSeparator);
                    sb.append('\t');
                }
                if ((value = this.props.get(key)) != null && value.getClass().isArray()) {
                    value = ArrayUtils.toString(value);
                }
                sb.append(key);
                sb.append(" = [");
                sb.append(value);
                sb.append(']');
            }
        }
        return sb.length() == 0 ? null : sb.toString();
    }
}

