/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import jetbrick.util.JdkUtils;
import jetbrick.util.ShellUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.SystemUtils;

public final class VMUtils {
    public static String getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return StringUtils.substringBefore(name, "@");
    }

    public static String getThreadDump() {
        File jstackFile;
        String command;
        ShellUtils.Result result;
        if (JdkUtils.IS_AT_LEAST_JAVA_6) {
            return "Java AppVersionUtils must be equal or larger than 1.6";
        }
        String jstack = "../bin/jstack";
        if (SystemUtils.IS_OS_WINDOWS) {
            jstack = jstack + ".exe";
        }
        if ((result = ShellUtils.shell(command = (jstackFile = new File(System.getProperty("java.home"), jstack)).getAbsolutePath() + " " + VMUtils.getProcessId())).success()) {
            return result.stdout();
        }
        throw new IllegalStateException(result.getException());
    }

    public static boolean detectDeadlock() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        long[] threadIds = threadBean.findDeadlockedThreads();
        return threadIds != null && threadIds.length > 0;
    }
}

