/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.PropertyInfo;
import jetbrick.typecast.TypeCastUtils;
import jetbrick.util.StringUtils;
import jetbrick.util.Validate;

public abstract class RequestIntrospectUtils {
    public static <T> T introspect(Class<T> formClass, ServletRequest request) {
        Validate.notNull(formClass);
        KlassInfo klass = KlassInfo.create(formClass);
        Object form = klass.newInstance();
        return (T)RequestIntrospectUtils.introspect(form, request);
    }

    public static <T> T introspect(T form, ServletRequest request) {
        Validate.notNull(form);
        Validate.notNull(request);
        Class<?> formClass = form.getClass();
        KlassInfo klass = KlassInfo.create(formClass);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            Object data;
            Class<?> componentType;
            String[] values;
            String name = (String)entry.getKey();
            PropertyInfo prop = klass.getProperty(name);
            if (prop == null || (values = (String[])entry.getValue()) == null) continue;
            Class<?> type = prop.getRawType(formClass);
            if (type.isArray()) {
                componentType = type.getComponentType();
                data = TypeCastUtils.convertToArray(values, componentType);
                prop.set(form, data);
                continue;
            }
            if (type == List.class || type == Collection.class) {
                componentType = prop.getRawComponentType(formClass, 0);
                data = TypeCastUtils.convertToList(values, componentType);
                prop.set(form, data);
                continue;
            }
            String value = StringUtils.trimToNull(values[0]);
            if (value == null) {
                if (type.isPrimitive()) continue;
                prop.set(form, null);
                continue;
            }
            data = TypeCastUtils.convert(value, type);
            prop.set(form, data);
        }
        return form;
    }
}

