/*
 * Decompiled with CFR 0.152.
 */
package com.github.tobato.fastdfs.proto.storage.internal;

import com.github.tobato.fastdfs.proto.FdfsRequest;
import com.github.tobato.fastdfs.proto.ProtoHead;
import com.github.tobato.fastdfs.proto.mapper.DynamicFieldType;
import com.github.tobato.fastdfs.proto.mapper.FdfsColumn;
import java.io.InputStream;
import java.nio.charset.Charset;

public class StorageModifyRequest
extends FdfsRequest {
    @FdfsColumn(index=0)
    private long pathSize;
    @FdfsColumn(index=1)
    private long fileOffset;
    @FdfsColumn(index=2)
    private long fileSize;
    @FdfsColumn(index=3, dynamicField=DynamicFieldType.allRestByte)
    private String path;

    public StorageModifyRequest(InputStream inputStream, long fileSize, String path, long fileOffset) {
        this.inputFile = inputStream;
        this.fileSize = fileSize;
        this.path = path;
        this.fileOffset = fileOffset;
        this.head = new ProtoHead(34);
    }

    @Override
    public byte[] encodeParam(Charset charset) {
        this.pathSize = this.path.getBytes(charset).length;
        return super.encodeParam(charset);
    }

    public long getPathSize() {
        return this.pathSize;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }
}

