/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.XmlException;
import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Xml {
    public static String prettyPrint(String xml) {
        try {
            return Xml.prettyPrint(Xml.read(xml));
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static String prettyPrint(Document doc) {
        try {
            TransformerFactory transformerFactory = Xml.createTransformerFactory();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private static TransformerFactory createTransformerFactory() {
        try {
            return (TransformerFactory)Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl").newInstance();
        }
        catch (Exception e) {
            return TransformerFactory.newInstance();
        }
    }

    public static Document read(String xml) {
        try {
            DocumentBuilderFactory dbf = Xml.newDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xml));
            return db.parse(is);
        }
        catch (SAXException e) {
            throw XmlException.fromSaxException(e);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Document.class);
        }
    }

    public static String toStringValue(Node node) {
        switch (node.getNodeType()) {
            case 2: 
            case 3: {
                return node.getTextContent();
            }
            case 1: {
                return Xml.render(node);
            }
        }
        return node.toString();
    }

    public static String render(Node node) {
        try {
            StringWriter sw = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerException e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        try {
            SkipResolvingEntitiesDocumentBuilderFactory dbf = new SkipResolvingEntitiesDocumentBuilderFactory();
            ((DocumentBuilderFactory)dbf).setFeature("http://xml.org/sax/features/validation", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            ((DocumentBuilderFactory)dbf).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return dbf;
        }
        catch (ParserConfigurationException e) {
            return Exceptions.throwUnchecked(e, DocumentBuilderFactory.class);
        }
    }

    public static class SkipResolvingEntitiesDocumentBuilderFactory
    extends DocumentBuilderFactoryImpl {
        @Override
        public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
            DocumentBuilder documentBuilder = super.newDocumentBuilder();
            documentBuilder.setEntityResolver(new ResolveToEmptyString());
            return documentBuilder;
        }

        private static class ResolveToEmptyString
        implements EntityResolver {
            private ResolveToEmptyString() {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        }
    }
}

