/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import com.ulisesbocchio.jasyptspringboot.aop.EncryptablePropertySourceMethodInterceptor;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptableEnumerablePropertySourceWrapper;
import com.ulisesbocchio.jasyptspringboot.wrapper.EncryptablePropertySourceWrapper;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.core.env.CommandLinePropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class EncryptablePropertySourceConverter {
    public static <T> PropertySource<T> proxyPropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        if (CommandLinePropertySource.class.isAssignableFrom(propertySource.getClass())) {
            return EncryptablePropertySourceConverter.instantiatePropertySource(propertySource, encryptor);
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetClass(propertySource.getClass());
        proxyFactory.setProxyTargetClass(true);
        proxyFactory.addInterface(EncryptablePropertySource.class);
        proxyFactory.setTarget(propertySource);
        proxyFactory.addAdvice(new EncryptablePropertySourceMethodInterceptor(encryptor));
        return (PropertySource)proxyFactory.getProxy();
    }

    public static <T> PropertySource<T> instantiatePropertySource(PropertySource<T> propertySource, StringEncryptor encryptor) {
        Object encryptablePropertySource = propertySource instanceof MapPropertySource ? new PropertySource<T>((MapPropertySource)propertySource, encryptor) : (propertySource.getClass().getName().equals("org.springframework.boot.context.config.ConfigFileApplicationListener$ConfigurationPropertySources") ? EncryptablePropertySourceConverter.proxyPropertySource(propertySource, encryptor) : (propertySource instanceof EnumerablePropertySource ? new EncryptableEnumerablePropertySourceWrapper((EnumerablePropertySource)propertySource, encryptor) : new EncryptablePropertySourceWrapper<T>(propertySource, encryptor)));
        return encryptablePropertySource;
    }
}

