/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.aop;

import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.env.PropertySource;

public class EncryptableMutablePropertySourcesInterceptor
implements MethodInterceptor {
    private Function<PropertySource<?>, PropertySource<?>> converter;

    public EncryptableMutablePropertySourcesInterceptor(Function<PropertySource<?>, PropertySource<?>> converter) {
        this.converter = converter;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String method = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        if (method.equals("addFirst")) {
            return invocation.getMethod().invoke(invocation.getThis(), this.makeEncryptable(arguments[0]));
        }
        if (method.equals("addLast")) {
            return invocation.getMethod().invoke(invocation.getThis(), this.makeEncryptable(arguments[0]));
        }
        if (method.equals("addBefore")) {
            return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
        }
        if (method.equals("addAfter")) {
            return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
        }
        if (method.equals("replace")) {
            return invocation.getMethod().invoke(invocation.getThis(), arguments[0], this.makeEncryptable(arguments[1]));
        }
        return invocation.proceed();
    }

    private Object makeEncryptable(Object argument) {
        return this.converter.apply((PropertySource)argument);
    }
}

