/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.xinge;

import com.tencent.xinge.api.RESTAPIV3;
import com.tencent.xinge.push.app.PushAppRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class XingeApp {
    public static MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json");
    private String authString = null;
    private String authStringEnc = null;
    private RESTAPIV3 restapiV3 = new RESTAPIV3();
    private OkHttpClient client;

    private XingeApp(String appId, String secretKey) {
        this.authString = appId + ":" + secretKey;
        byte[] authEncBytes = Base64.encodeBase64((byte[])this.authString.getBytes());
        this.authStringEnc = new String(authEncBytes);
        this.client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).build();
    }

    private XingeApp(Builder builder) {
        this.authString = builder.appId + ":" + builder.secretKey;
        byte[] authEncBytes = Base64.encodeBase64((byte[])this.authString.getBytes());
        this.authStringEnc = new String(authEncBytes);
        if (builder.domainUrl != null) {
            this.restapiV3.setDomainUrl(builder.domainUrl);
        }
        this.client = new OkHttpClient.Builder().proxy(builder.proxy).connectTimeout((long)builder.connectTimeOut, TimeUnit.SECONDS).readTimeout((long)builder.readTimeOut, TimeUnit.SECONDS).build();
    }

    public void setDomainUrl(String url) {
        this.restapiV3.setDomainUrl(url);
    }

    public JSONObject pushApp(String jsonRequest) {
        JSONObject ret = this.callRestful(this.restapiV3.getRestApiPushUrl(), jsonRequest);
        return ret;
    }

    public JSONObject pushApp(PushAppRequest pushAppRequest) {
        String jsonRequest = pushAppRequest.toString();
        return this.pushApp(jsonRequest);
    }

    public JSONObject deviceTag(String jsonRequest) {
        return this.callRestful(this.restapiV3.getRestApiTagUrl(), jsonRequest);
    }

    private JSONObject callRestful(String apiAddress, String jsonRequestString) {
        JSONObject jsonRet = null;
        RequestBody requestBody = RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)jsonRequestString);
        Request request = new Request.Builder().url(apiAddress).addHeader("Content-Type", "application/json").addHeader("Authorization", "Basic " + this.authStringEnc).post(requestBody).build();
        try {
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                if (response.code() == 200) {
                    String retMsg = response.body().string();
                    jsonRet = new JSONObject(retMsg);
                } else {
                    jsonRet = new JSONObject();
                    jsonRet.put("ret_code", 10101);
                    jsonRet.put("err_msg", (Object)("CallApiError,HttpStatus Code:" + response.code()));
                }
            }
            response.close();
        }
        catch (IOException e) {
            jsonRet = new JSONObject();
            jsonRet.put("ret_code", 10100);
            jsonRet.put("err_msg", (Object)XingeApp.stringifyError(e));
        }
        return jsonRet;
    }

    public static String stringifyError(Throwable error) {
        StringWriter result = new StringWriter();
        PrintWriter printer = new PrintWriter(result);
        error.printStackTrace(printer);
        printer.close();
        return result.toString();
    }

    public static class Builder {
        private String appId;
        private String secretKey;
        private Proxy proxy = Proxy.NO_PROXY;
        private int connectTimeOut = 10;
        private int readTimeOut = 10;
        private String domainUrl;

        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder domainUrl(String domainUrl) {
            this.domainUrl = domainUrl;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder connectTimeOut(int connectTimeOut) {
            this.connectTimeOut = connectTimeOut;
            return this;
        }

        public Builder readTimeOut(int readTimeOut) {
            this.readTimeOut = readTimeOut;
            return this;
        }

        public XingeApp build() {
            if (this.appId == null || this.secretKey == null) {
                throw new IllegalArgumentException("Please set appId and secret key.");
            }
            return new XingeApp(this);
        }
    }
}

