/*
 * Decompiled with CFR 0.152.
 */
package com.gonvan.kaptcha.impl;

import com.gonvan.kaptcha.GimpyEngine;
import com.gonvan.kaptcha.NoiseProducer;
import com.gonvan.kaptcha.util.Configurable;
import com.jhlabs.image.RippleFilter;
import com.jhlabs.image.ShadowFilter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class ShadowGimpy
extends Configurable
implements GimpyEngine {
    @Override
    public BufferedImage getDistortedImage(BufferedImage baseImage) {
        NoiseProducer noiseProducer = this.getConfig().getNoiseImpl();
        BufferedImage distortedImage = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
        Graphics2D graph = (Graphics2D)distortedImage.getGraphics();
        ShadowFilter shadowFilter = new ShadowFilter();
        shadowFilter.setRadius(10.0f);
        shadowFilter.setDistance(5.0f);
        shadowFilter.setOpacity(1.0f);
        Random rand = new Random();
        RippleFilter rippleFilter = new RippleFilter();
        rippleFilter.setWaveType(0);
        rippleFilter.setXAmplitude(7.6f);
        rippleFilter.setYAmplitude(rand.nextFloat() + 1.0f);
        rippleFilter.setXWavelength((float)(rand.nextInt(7) + 8));
        rippleFilter.setYWavelength((float)(rand.nextInt(3) + 2));
        rippleFilter.setEdgeAction(1);
        BufferedImage effectImage = rippleFilter.filter(baseImage, null);
        effectImage = shadowFilter.filter(effectImage, null);
        graph.drawImage(effectImage, 0, 0, null, null);
        graph.dispose();
        noiseProducer.makeNoise(distortedImage, 0.1f, 0.1f, 0.25f, 0.25f);
        noiseProducer.makeNoise(distortedImage, 0.1f, 0.25f, 0.5f, 0.9f);
        return distortedImage;
    }
}

