/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.spring.context.SpringManagedContext;
import com.hazelcast.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractHazelcastBeanDefinitionParser
extends AbstractBeanDefinitionParser {

    public abstract class SpringXmlBuilderHelper
    extends AbstractXmlConfigHelper {
        protected BeanDefinitionBuilder configBuilder;

        protected void handleCommonBeanAttributes(Node node, BeanDefinitionBuilder builder, ParserContext parserContext) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                Node lazyInitAttr = attributes.getNamedItem("lazy-init");
                if (lazyInitAttr != null) {
                    builder.setLazyInit(Boolean.valueOf(this.getTextContent(lazyInitAttr)).booleanValue());
                } else {
                    builder.setLazyInit(parserContext.isDefaultLazyInit());
                }
                if (parserContext.isNested()) {
                    builder.setScope(parserContext.getContainingBeanDefinition().getScope());
                } else {
                    Node scopeNode = attributes.getNamedItem("scope");
                    if (scopeNode != null) {
                        builder.setScope(this.getTextContent(scopeNode));
                    }
                }
                Node dependsOnNode = attributes.getNamedItem("depends-on");
                if (dependsOnNode != null) {
                    String[] dependsOn;
                    for (String dep : dependsOn = this.getTextContent(dependsOnNode).split("[,;]")) {
                        builder.addDependsOn(dep.trim());
                    }
                }
            }
        }

        protected BeanDefinitionBuilder createBeanBuilder(Class clazz) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)clazz);
            builder.setScope(this.configBuilder.getBeanDefinition().getScope());
            builder.setLazyInit(this.configBuilder.getBeanDefinition().isLazyInit());
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillBeanBuilder(Node node, Class clazz, String propertyName, BeanDefinitionBuilder parent, String ... exceptPropertyNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            this.fillValues(node, builder, exceptPropertyNames);
            parent.addPropertyValue(propertyName, (Object)beanDefinition);
            return builder;
        }

        protected BeanDefinitionBuilder createAndFillListedBean(Node node, Class clazz, String propertyName, ManagedMap<String, AbstractBeanDefinition> managedMap, String ... excludeNames) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(clazz);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            String name = this.getAttribute(node, propertyName);
            builder.addPropertyValue("name", (Object)name);
            this.fillValues(node, builder, excludeNames);
            managedMap.put((Object)name, (Object)beanDefinition);
            return builder;
        }

        protected void fillValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
            for (Node n : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = this.xmlToJavaName(SpringXmlBuilderHelper.cleanNodeName((Node)n));
                if (epn != null && epn.contains(name)) continue;
                String value = this.getTextContent(n);
                builder.addPropertyValue(name, (Object)value);
            }
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, String ... excludeNames) {
            HashSet<String> epn = excludeNames != null && excludeNames.length > 0 ? new HashSet<String>(Arrays.asList(excludeNames)) : null;
            this.fillAttributeValues(node, builder, (Collection<String>)epn);
        }

        protected void fillAttributeValues(Node node, BeanDefinitionBuilder builder, Collection<String> epn) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node attribute = attributes.item(a);
                    String name = this.xmlToJavaName(attribute.getNodeName());
                    if (epn != null && epn.contains(name)) continue;
                    String value = attribute.getNodeValue();
                    builder.addPropertyValue(name, (Object)value);
                }
            }
        }

        protected ManagedList parseListeners(Node node, Class listenerConfigClass) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : SpringXmlBuilderHelper.childElements((Node)node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(listenerConfigClass);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        protected ManagedList parseProxyFactories(Node node, Class proxyFactoryConfigClass) {
            ManagedList list = new ManagedList();
            for (Node instanceNode : SpringXmlBuilderHelper.childElements((Node)node)) {
                BeanDefinitionBuilder confBuilder = this.createBeanBuilder(proxyFactoryConfigClass);
                this.fillAttributeValues(instanceNode, confBuilder, new String[0]);
                list.add((Object)confBuilder.getBeanDefinition());
            }
            return list;
        }

        protected void handleDataSerializableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if (!"data-serializable-factory".equals(name)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem("implementation");
                Node classNode = attributes.getNamedItem("class-name");
                Node fidNode = attributes.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("dataSerializableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("dataSerializableFactories", (Object)factories);
        }

        protected void handleSerializers(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = null;
            String implementation = "implementation";
            String className = "class-name";
            String typeClassName = "type-class";
            String overrideJavaSerializationName = "override-java-serialization";
            ManagedList serializers = new ManagedList();
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if ("global-serializer".equals(name)) {
                    globalSerializerConfigBuilder = this.createGSConfigBuilder(GlobalSerializerConfig.class, child, implementation, className, overrideJavaSerializationName);
                }
                if (!"serializer".equals(name)) continue;
                BeanDefinitionBuilder serializerConfigBuilder = this.createBeanBuilder(SerializerConfig.class);
                this.fillAttributeValues(child, serializerConfigBuilder, new String[0]);
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem(implementation);
                Node classNode = attributes.getNamedItem(className);
                Node typeClass = attributes.getNamedItem(typeClassName);
                if (typeClass != null) {
                    serializerConfigBuilder.addPropertyValue("typeClassName", (Object)this.getTextContent(typeClass));
                }
                if (implRef != null) {
                    serializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
                }
                if (classNode != null) {
                    serializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
                }
                serializers.add((Object)serializerConfigBuilder.getBeanDefinition());
            }
            if (globalSerializerConfigBuilder != null) {
                serializationConfigBuilder.addPropertyValue("globalSerializerConfig", (Object)globalSerializerConfigBuilder.getBeanDefinition());
            }
            serializationConfigBuilder.addPropertyValue("serializerConfigs", (Object)serializers);
        }

        private BeanDefinitionBuilder createGSConfigBuilder(Class<GlobalSerializerConfig> globalSerializerConfigClass, Node child, String implementation, String className, String overrideJavaSerializationName) {
            BeanDefinitionBuilder globalSerializerConfigBuilder = this.createBeanBuilder(globalSerializerConfigClass);
            NamedNodeMap attributes = child.getAttributes();
            Node implRef = attributes.getNamedItem(implementation);
            Node classNode = attributes.getNamedItem(className);
            Node overrideJavaSerializationNode = attributes.getNamedItem(overrideJavaSerializationName);
            if (implRef != null) {
                globalSerializerConfigBuilder.addPropertyReference(this.xmlToJavaName(implementation), this.getTextContent(implRef));
            }
            if (classNode != null) {
                globalSerializerConfigBuilder.addPropertyValue(this.xmlToJavaName(className), (Object)this.getTextContent(classNode));
            }
            if (overrideJavaSerializationNode != null) {
                boolean value = SpringXmlBuilderHelper.getBooleanValue((String)this.getTextContent(overrideJavaSerializationNode));
                globalSerializerConfigBuilder.addPropertyValue(this.xmlToJavaName(overrideJavaSerializationName), (Object)value);
            }
            return globalSerializerConfigBuilder;
        }

        protected void handlePortableFactories(Node node, BeanDefinitionBuilder serializationConfigBuilder) {
            ManagedMap factories = new ManagedMap();
            ManagedMap classNames = new ManagedMap();
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if (!"portable-factory".equals(name)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node implRef = attributes.getNamedItem("implementation");
                Node classNode = attributes.getNamedItem("class-name");
                Node fidNode = attributes.getNamedItem("factory-id");
                if (implRef != null) {
                    factories.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)new RuntimeBeanReference(this.getTextContent(implRef)));
                }
                if (classNode == null) continue;
                classNames.put((Object)Integer.parseInt(this.getTextContent(fidNode)), (Object)this.getTextContent(classNode));
            }
            serializationConfigBuilder.addPropertyValue("portableFactoryClasses", (Object)classNames);
            serializationConfigBuilder.addPropertyValue("portableFactories", (Object)factories);
        }

        protected void handleSerialization(Node node) {
            BeanDefinitionBuilder serializationConfigBuilder = this.createBeanBuilder(SerializationConfig.class);
            AbstractBeanDefinition beanDefinition = serializationConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, serializationConfigBuilder, new String[0]);
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String nodeName = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if ("data-serializable-factories".equals(nodeName)) {
                    this.handleDataSerializableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if ("portable-factories".equals(nodeName)) {
                    this.handlePortableFactories(child, serializationConfigBuilder);
                    continue;
                }
                if (!"serializers".equals(nodeName)) continue;
                this.handleSerializers(child, serializationConfigBuilder);
            }
            this.configBuilder.addPropertyValue("serializationConfig", (Object)beanDefinition);
        }

        protected void handleSocketInterceptorConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder socketInterceptorConfigBuilder = this.createBeanBuilder(SocketInterceptorConfig.class);
            String implAttribute = "implementation";
            this.fillAttributeValues(node, socketInterceptorConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                socketInterceptorConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, socketInterceptorConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("socketInterceptorConfig", (Object)socketInterceptorConfigBuilder.getBeanDefinition());
        }

        protected void handleProperties(Node node, BeanDefinitionBuilder beanDefinitionBuilder) {
            ManagedMap properties = this.parseProperties(node);
            beanDefinitionBuilder.addPropertyValue("properties", (Object)properties);
        }

        protected ManagedMap parseProperties(Node node) {
            ManagedMap properties = new ManagedMap();
            for (Node n : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)n);
                if (!"property".equals(name)) continue;
                String propertyName = this.getTextContent(n.getAttributes().getNamedItem("name")).trim();
                String value = this.getTextContent(n);
                properties.put((Object)propertyName, (Object)value);
            }
            return properties;
        }

        protected void handleSpringAware() {
            BeanDefinitionBuilder managedContextBeanBuilder = this.createBeanBuilder(SpringManagedContext.class);
            this.configBuilder.addPropertyValue("managedContext", (Object)managedContextBeanBuilder.getBeanDefinition());
        }

        protected BeanDefinition getEvictionConfig(Node node) {
            Node size = node.getAttributes().getNamedItem("size");
            Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
            Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
            Node comparatorClassName = node.getAttributes().getNamedItem("comparator-class-name");
            Node comparatorBean = node.getAttributes().getNamedItem("comparator-bean");
            if (comparatorClassName != null && comparatorBean != null) {
                throw new InvalidConfigurationException("Only one of the `comparator-class-name` and `comparator-bean` attributes can be configured inside eviction configuration!");
            }
            BeanDefinitionBuilder evictionConfigBuilder = this.createBeanBuilder(EvictionConfig.class);
            Integer sizeValue = 10000;
            EvictionConfig.MaxSizePolicy maxSizePolicyValue = EvictionConfig.DEFAULT_MAX_SIZE_POLICY;
            EvictionPolicy evictionPolicyValue = EvictionConfig.DEFAULT_EVICTION_POLICY;
            String comparatorClassNameValue = null;
            String comparatorBeanValue = null;
            if (size != null) {
                sizeValue = Integer.parseInt(this.getTextContent(size));
            }
            if (maxSizePolicy != null) {
                maxSizePolicyValue = EvictionConfig.MaxSizePolicy.valueOf((String)StringUtil.upperCaseInternal((String)this.getTextContent(maxSizePolicy)));
            }
            if (evictionPolicy != null) {
                evictionPolicyValue = EvictionPolicy.valueOf((String)StringUtil.upperCaseInternal((String)this.getTextContent(evictionPolicy)));
            }
            if (comparatorClassName != null) {
                comparatorClassNameValue = this.getTextContent(comparatorClassName);
            }
            if (comparatorBean != null) {
                comparatorBeanValue = this.getTextContent(comparatorBean);
            }
            try {
                ConfigValidator.checkEvictionConfig((EvictionPolicy)evictionPolicyValue, (String)comparatorClassNameValue, (Object)comparatorBean, (boolean)false);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException(e.getMessage());
            }
            evictionConfigBuilder.addPropertyValue("size", (Object)sizeValue);
            evictionConfigBuilder.addPropertyValue("maximumSizePolicy", (Object)maxSizePolicyValue);
            evictionConfigBuilder.addPropertyValue("evictionPolicy", (Object)evictionPolicyValue);
            if (comparatorClassNameValue != null) {
                evictionConfigBuilder.addPropertyValue("comparatorClassName", (Object)comparatorClassNameValue);
            }
            if (comparatorBean != null) {
                evictionConfigBuilder.addPropertyReference("comparator", comparatorBeanValue);
            }
            return evictionConfigBuilder.getBeanDefinition();
        }

        protected BeanDefinition getPreloaderConfig(Node node) {
            Node enabled = node.getAttributes().getNamedItem("enabled");
            Node directory = node.getAttributes().getNamedItem("directory");
            Node storeInitialDelaySeconds = node.getAttributes().getNamedItem("store-initial-delay-seconds");
            Node storeIntervalSeconds = node.getAttributes().getNamedItem("store-interval-seconds");
            BeanDefinitionBuilder nearCachePreloaderConfigBuilder = this.createBeanBuilder(NearCachePreloaderConfig.class);
            Boolean enabledValue = Boolean.FALSE;
            String directoryValue = "";
            Integer storeInitialDelaySecondsValue = 600;
            Integer storeIntervalSecondsValue = 600;
            if (enabled != null) {
                enabledValue = Boolean.parseBoolean(this.getTextContent(enabled));
            }
            if (directory != null) {
                directoryValue = this.getTextContent(directory);
            }
            if (storeInitialDelaySeconds != null) {
                storeInitialDelaySecondsValue = Integer.parseInt(this.getTextContent(storeInitialDelaySeconds));
            }
            if (storeIntervalSeconds != null) {
                storeIntervalSecondsValue = Integer.parseInt(this.getTextContent(storeIntervalSeconds));
            }
            nearCachePreloaderConfigBuilder.addPropertyValue("enabled", (Object)enabledValue);
            nearCachePreloaderConfigBuilder.addPropertyValue("directory", (Object)directoryValue);
            nearCachePreloaderConfigBuilder.addPropertyValue("storeInitialDelaySeconds", (Object)storeInitialDelaySecondsValue);
            nearCachePreloaderConfigBuilder.addPropertyValue("storeIntervalSeconds", (Object)storeIntervalSecondsValue);
            return nearCachePreloaderConfigBuilder.getBeanDefinition();
        }

        protected void handleDiscoveryStrategies(Node node, BeanDefinitionBuilder joinConfigBuilder) {
            BeanDefinitionBuilder discoveryConfigBuilder = this.createBeanBuilder(DiscoveryConfig.class);
            ManagedList discoveryStrategyConfigs = new ManagedList();
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if ("discovery-strategy".equals(name)) {
                    this.handleDiscoveryStrategy(child, (ManagedList<BeanDefinition>)discoveryStrategyConfigs);
                    continue;
                }
                if ("node-filter".equals(name)) {
                    this.handleDiscoveryNodeFilter(child, discoveryConfigBuilder);
                    continue;
                }
                if (!"discovery-service-provider".equals(name)) continue;
                this.handleDiscoveryServiceProvider(child, discoveryConfigBuilder);
            }
            discoveryConfigBuilder.addPropertyValue("discoveryStrategyConfigs", (Object)discoveryStrategyConfigs);
            joinConfigBuilder.addPropertyValue("discoveryConfig", (Object)discoveryConfigBuilder.getBeanDefinition());
        }

        private void handleDiscoveryServiceProvider(Node node, BeanDefinitionBuilder discoveryConfigBuilder) {
            NamedNodeMap attributes = node.getAttributes();
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!implementation.isEmpty() ? 1 : 0) != 0, (String)"'implementation' attribute is required to create DiscoveryServiceProvider!");
            discoveryConfigBuilder.addPropertyReference("discoveryServiceProvider", implementation);
        }

        private void handleDiscoveryNodeFilter(Node node, BeanDefinitionBuilder discoveryConfigBuilder) {
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode).trim();
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!className.isEmpty() || !implementation.isEmpty() ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create NodeFilter!");
            discoveryConfigBuilder.addPropertyValue("nodeFilterClass", (Object)className);
            if (!implementation.isEmpty()) {
                discoveryConfigBuilder.addPropertyReference("nodeFilter", implementation);
            }
        }

        private void handleDiscoveryStrategy(Node node, ManagedList<BeanDefinition> discoveryStrategyConfigs) {
            BeanDefinitionBuilder discoveryStrategyConfigBuilder = this.createBeanBuilder(DiscoveryStrategyConfig.class);
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode).trim();
            Node implNode = attributes.getNamedItem("discovery-strategy-factory");
            String implementation = this.getTextContent(implNode).trim();
            Assert.isTrue((!className.isEmpty() || !implementation.isEmpty() ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create DiscoveryStrategyConfig!");
            if (!implementation.isEmpty()) {
                discoveryStrategyConfigBuilder.addConstructorArgReference(implementation);
            } else {
                discoveryStrategyConfigBuilder.addConstructorArgValue((Object)className);
            }
            for (Node child : SpringXmlBuilderHelper.childElements((Node)node)) {
                ManagedMap properties;
                String name = SpringXmlBuilderHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name) || (properties = this.parseProperties(child)).isEmpty()) continue;
                discoveryStrategyConfigBuilder.addConstructorArgValue((Object)properties);
            }
            discoveryStrategyConfigs.add((Object)discoveryStrategyConfigBuilder.getBeanDefinition());
        }
    }
}

