/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.data;

import com.intelligt.modbus.jlibmodbus.data.CommStatus;
import com.intelligt.modbus.jlibmodbus.data.ExceptionStatus;
import com.intelligt.modbus.jlibmodbus.data.FifoQueue;
import com.intelligt.modbus.jlibmodbus.data.ModbusCoils;
import com.intelligt.modbus.jlibmodbus.data.ModbusFile;
import com.intelligt.modbus.jlibmodbus.data.ModbusHoldingRegisters;
import com.intelligt.modbus.jlibmodbus.data.SlaveId;
import com.intelligt.modbus.jlibmodbus.data.mei.ReadDeviceIdentificationInterface;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataAddressException;
import com.intelligt.modbus.jlibmodbus.exception.IllegalDataValueException;
import com.intelligt.modbus.jlibmodbus.exception.IllegalFunctionException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.util.Map;
import java.util.TreeMap;

public class DataHolder {
    private final CommStatus commStatus = new CommStatus();
    private final Map<Integer, FifoQueue> fifoMap = new TreeMap<Integer, FifoQueue>();
    private final Map<Integer, ModbusFile> fileMap = new TreeMap<Integer, ModbusFile>();
    private ModbusCoils coils = null;
    private ModbusCoils discreteInputs = null;
    private ModbusHoldingRegisters holdingRegisters = null;
    private ModbusHoldingRegisters inputRegisters = null;
    private SlaveId slaveId = null;
    private ExceptionStatus exceptionStatus = null;
    private ReadDeviceIdentificationInterface readDeviceIdentificationInterface = null;

    private void checkPointer(Object o, int offset) throws IllegalDataAddressException {
        if (o == null) {
            throw new IllegalDataAddressException(offset);
        }
    }

    public int readHoldingRegister(int offset) throws IllegalDataAddressException {
        this.checkPointer(this.holdingRegisters, offset);
        return this.holdingRegisters.get(offset);
    }

    public int[] readHoldingRegisterRange(int offset, int quantity) throws IllegalDataAddressException {
        this.checkPointer(this.holdingRegisters, offset);
        return this.holdingRegisters.getRange(offset, quantity);
    }

    public void writeHoldingRegister(int offset, int value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        this.holdingRegisters.set(offset, value);
    }

    public void writeHoldingRegisterRange(int offset, int[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.holdingRegisters, offset);
        this.holdingRegisters.setRange(offset, range);
    }

    public int[] readInputRegisterRange(int offset, int quantity) throws IllegalDataAddressException {
        this.checkPointer(this.inputRegisters, offset);
        return this.inputRegisters.getRange(offset, quantity);
    }

    public int[] readFifoQueue(int fifoPointerAddress) throws IllegalDataValueException, IllegalDataAddressException {
        FifoQueue fifoQueue = this.fifoMap.get(fifoPointerAddress);
        this.checkPointer(fifoQueue, fifoPointerAddress);
        return fifoQueue.get();
    }

    public boolean[] readCoilRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.coils, offset);
        return this.coils.getRange(offset, quantity);
    }

    public void writeCoil(int offset, boolean value) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.coils, offset);
        this.coils.set(offset, value);
    }

    public void writeCoilRange(int offset, boolean[] range) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.coils, offset);
        this.coils.setRange(offset, range);
    }

    public byte[] readSlaveId() throws IllegalFunctionException {
        if (this.slaveId == null) {
            throw new IllegalFunctionException(ModbusFunctionCode.REPORT_SLAVE_ID.toInt());
        }
        return this.slaveId.get();
    }

    public int readExceptionStatus() throws IllegalFunctionException {
        if (this.exceptionStatus == null) {
            throw new IllegalFunctionException(ModbusFunctionCode.READ_EXCEPTION_STATUS.toInt());
        }
        return this.exceptionStatus.get();
    }

    public boolean[] readDiscreteInputRange(int offset, int quantity) throws IllegalDataAddressException, IllegalDataValueException {
        this.checkPointer(this.discreteInputs, offset);
        return this.discreteInputs.getRange(offset, quantity);
    }

    public void readFileRecord(ModbusFileRecord fileRecord) throws IllegalDataAddressException, IllegalDataValueException {
        ModbusFile file = this.getFile(fileRecord.getFileNumber());
        this.checkPointer(file, fileRecord.getFileNumber());
        fileRecord.writeRegisters(file.read(fileRecord.getRecordNumber(), fileRecord.getRecordLength()));
    }

    public void writeFileRecord(ModbusFileRecord fileRecord) throws IllegalDataAddressException, IllegalDataValueException {
        ModbusFile file = this.getFile(fileRecord.getFileNumber());
        this.checkPointer(file, fileRecord.getFileNumber());
        file.write(fileRecord.getRecordNumber(), fileRecord.getRegisters());
    }

    public ModbusCoils getCoils() {
        return this.coils;
    }

    public void setCoils(ModbusCoils coils) {
        this.coils = coils;
    }

    public ModbusCoils getDiscreteInputs() {
        return this.discreteInputs;
    }

    public void setDiscreteInputs(ModbusCoils discreteInputs) {
        this.discreteInputs = discreteInputs;
    }

    public ModbusHoldingRegisters getHoldingRegisters() {
        return this.holdingRegisters;
    }

    public void setHoldingRegisters(ModbusHoldingRegisters holdingRegisters) {
        this.holdingRegisters = holdingRegisters;
    }

    public ModbusHoldingRegisters getInputRegisters() {
        return this.inputRegisters;
    }

    public void setInputRegisters(ModbusHoldingRegisters inputRegisters) {
        this.inputRegisters = inputRegisters;
    }

    public CommStatus getCommStatus() {
        return this.commStatus;
    }

    public SlaveId getSlaveId() {
        return this.slaveId;
    }

    public void setSlaveId(SlaveId slaveId) {
        this.slaveId = slaveId;
    }

    public ExceptionStatus getExceptionStatus() {
        return this.exceptionStatus;
    }

    public void setExceptionStatus(ExceptionStatus exceptionStatus) {
        this.exceptionStatus = exceptionStatus;
    }

    public FifoQueue getFifoQueue(int fifoPointerAddress) throws IllegalDataAddressException {
        FifoQueue file = this.fifoMap.get(fifoPointerAddress);
        if (file == null) {
            throw new IllegalDataAddressException(fifoPointerAddress);
        }
        return file;
    }

    public void addFifoQueue(FifoQueue fifoQueue, int fifoPointerAddress) throws IllegalDataAddressException {
        if (this.fifoMap.containsKey(fifoPointerAddress)) {
            throw new IllegalDataAddressException(fifoPointerAddress);
        }
        this.fifoMap.put(fifoPointerAddress, fifoQueue);
    }

    public void addFile(ModbusFile file) throws IllegalDataAddressException {
        if (this.fileMap.containsKey(file.getNumber())) {
            throw new IllegalDataAddressException(file.getNumber());
        }
        this.fileMap.put(file.getNumber(), file);
    }

    public ModbusFile getFile(int number) throws IllegalDataAddressException {
        ModbusFile file = this.fileMap.get(number);
        if (file == null) {
            throw new IllegalDataAddressException(number);
        }
        return file;
    }

    public ReadDeviceIdentificationInterface getReadDeviceIdentificationInterface() {
        return this.readDeviceIdentificationInterface;
    }

    public void setReadDeviceIdentificationInterface(ReadDeviceIdentificationInterface readDeviceIdentificationInterface) {
        this.readDeviceIdentificationInterface = readDeviceIdentificationInterface;
    }
}

