/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.AbstractDataRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.MaskWriteRegisterResponse;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusOutputStream;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;
import java.io.IOException;

public final class MaskWriteRegisterRequest
extends AbstractDataRequest {
    private int maskAnd;
    private int maskOr;

    @Override
    protected Class getResponseClass() {
        return MaskWriteRegisterResponse.class;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        MaskWriteRegisterResponse response = (MaskWriteRegisterResponse)this.getResponse();
        response.setStartAddress(this.getStartAddress());
        response.setMaskAnd(this.getMaskAnd());
        response.setMaskOr(this.getMaskOr());
        try {
            int reg = dataHolder.readHoldingRegister(this.getStartAddress());
            dataHolder.writeHoldingRegister(this.getStartAddress(), reg & this.getMaskAnd() | this.getMaskOr() & ~this.getMaskAnd());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof MaskWriteRegisterResponse)) {
            return false;
        }
        MaskWriteRegisterResponse r = (MaskWriteRegisterResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getMaskAnd() == this.getMaskAnd() && r.getMaskOr() == this.getMaskOr();
    }

    @Override
    protected void readData(ModbusInputStream fifo) throws IOException {
        this.setMaskAnd(fifo.readShortBE());
        this.setMaskOr(fifo.readShortBE());
    }

    @Override
    public void writeData(ModbusOutputStream fifo) throws IOException {
        fifo.writeShortBE(this.getMaskAnd());
        fifo.writeShortBE(this.getMaskOr());
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.MASK_WRITE_REGISTER.toInt();
    }

    @Override
    protected int dataSize() {
        return 4;
    }

    public int getMaskAnd() {
        return this.maskAnd;
    }

    public void setMaskAnd(int maskAnd) {
        this.maskAnd = maskAnd;
    }

    public int getMaskOr() {
        return this.maskOr;
    }

    public void setMaskOr(int maskOr) {
        this.maskOr = maskOr;
    }
}

