/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.net.stream.base;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.net.stream.base.ModbusInputStream;
import com.intelligt.modbus.jlibmodbus.utils.ByteFifo;
import com.intelligt.modbus.jlibmodbus.utils.DataUtils;
import com.intelligt.modbus.jlibmodbus.utils.FrameEvent;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerList;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerListImpl;
import java.io.IOException;

public class LoggingInputStream
extends ModbusInputStream {
    private FrameEventListenerList listenerList = new FrameEventListenerListImpl();
    private static final String LOG_MESSAGE_TITLE = "Frame recv: ";
    private final ModbusInputStream in;
    private final ByteFifo fifo = new ByteFifo(254);

    public LoggingInputStream(ModbusInputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b);
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (Modbus.isLoggingEnabled()) {
            this.fifo.write(b, off, read);
        }
        return read;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.in.setReadTimeout(readTimeout);
    }

    public void log() {
        if (Modbus.isLoggingEnabled() && this.fifo.size() > 0) {
            byte[] bytes = this.fifo.toByteArray();
            Modbus.log().info(LOG_MESSAGE_TITLE + DataUtils.toAscii(bytes));
            this.listenerList.fireFrameReceivedEvent(new FrameEvent(bytes));
            this.fifo.reset();
        }
    }

    public void setListenerList(FrameEventListenerList listenerList) {
        this.listenerList = listenerList;
    }
}

