/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template;

import com.jfinal.kit.HashKit;
import com.jfinal.kit.StrKit;
import com.jfinal.kit.SyncWriteMap;
import com.jfinal.template.Directive;
import com.jfinal.template.EngineConfig;
import com.jfinal.template.Env;
import com.jfinal.template.Template;
import com.jfinal.template.expr.ast.FieldGetter;
import com.jfinal.template.expr.ast.FieldKeyBuilder;
import com.jfinal.template.expr.ast.FieldKit;
import com.jfinal.template.expr.ast.MethodKit;
import com.jfinal.template.io.EncoderFactory;
import com.jfinal.template.io.JdkEncoderFactory;
import com.jfinal.template.source.ClassPathSourceFactory;
import com.jfinal.template.source.ISource;
import com.jfinal.template.source.ISourceFactory;
import com.jfinal.template.source.StringSource;
import com.jfinal.template.stat.Compressor;
import com.jfinal.template.stat.OutputDirectiveFactory;
import com.jfinal.template.stat.Parser;
import com.jfinal.template.stat.ast.StatList;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Engine {
    public static final String MAIN_ENGINE_NAME = "main";
    private static Engine MAIN_ENGINE;
    private static Map<String, Engine> engineMap;
    private String name;
    private boolean devMode = false;
    private boolean cacheStringTemplate = false;
    private EngineConfig config = new EngineConfig();
    private ISourceFactory sourceFactory = this.config.getSourceFactory();
    private Map<String, Template> templateCache = new SyncWriteMap<String, Template>(2048, 0.5f);

    public Engine() {
        this.name = "NO_NAME";
    }

    public Engine(String engineName) {
        this.name = engineName;
    }

    public static Engine use() {
        return MAIN_ENGINE;
    }

    public static Engine use(String engineName) {
        return engineMap.get(engineName);
    }

    public static synchronized Engine create(String engineName) {
        if (StrKit.isBlank(engineName)) {
            throw new IllegalArgumentException("Engine name can not be blank");
        }
        if (engineMap.containsKey(engineName = engineName.trim())) {
            throw new IllegalArgumentException("Engine already exists : " + engineName);
        }
        Engine newEngine = new Engine(engineName);
        engineMap.put(engineName, newEngine);
        return newEngine;
    }

    public static synchronized Engine remove(String engineName) {
        Engine removed = engineMap.remove(engineName);
        if (removed != null && MAIN_ENGINE_NAME.equals(removed.name)) {
            MAIN_ENGINE = null;
        }
        return removed;
    }

    public static synchronized void setMainEngine(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("Engine can not be null");
        }
        engine.name = MAIN_ENGINE_NAME;
        engineMap.put(MAIN_ENGINE_NAME, engine);
        MAIN_ENGINE = engine;
    }

    public Template getTemplate(String fileName) {
        Template template;
        if (fileName.charAt(0) != '/') {
            char[] arr = new char[fileName.length() + 1];
            fileName.getChars(0, fileName.length(), arr, 1);
            arr[0] = 47;
            fileName = new String(arr);
        }
        if ((template = this.templateCache.get(fileName)) == null) {
            template = this.buildTemplateBySourceFactory(fileName);
            this.templateCache.put(fileName, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateBySourceFactory(fileName);
            this.templateCache.put(fileName, template);
        }
        return template;
    }

    private Template buildTemplateBySourceFactory(String fileName) {
        ISource source = this.sourceFactory.getSource(this.config.getBaseTemplatePath(), fileName, this.config.getEncoding());
        Env env = new Env(this.config);
        Parser parser = new Parser(env, source.getContent(), fileName);
        if (this.devMode) {
            env.addSource(source);
        }
        StatList stat = parser.parse();
        Template template = new Template(env, stat);
        return template;
    }

    public Template getTemplateByString(String content) {
        return this.getTemplateByString(content, this.cacheStringTemplate);
    }

    public Template getTemplateByString(String content, boolean cache) {
        if (!cache) {
            return this.buildTemplateBySource(new StringSource(content, cache));
        }
        String cacheKey = HashKit.md5(content);
        Template template = this.templateCache.get(cacheKey);
        if (template == null) {
            template = this.buildTemplateBySource(new StringSource(content, cache));
            this.templateCache.put(cacheKey, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateBySource(new StringSource(content, cache));
            this.templateCache.put(cacheKey, template);
        }
        return template;
    }

    public Template getTemplate(ISource source) {
        String cacheKey = source.getCacheKey();
        if (cacheKey == null) {
            return this.buildTemplateBySource(source);
        }
        Template template = this.templateCache.get(cacheKey);
        if (template == null) {
            template = this.buildTemplateBySource(source);
            this.templateCache.put(cacheKey, template);
        } else if (this.devMode && template.isModified()) {
            template = this.buildTemplateBySource(source);
            this.templateCache.put(cacheKey, template);
        }
        return template;
    }

    private Template buildTemplateBySource(ISource source) {
        Env env = new Env(this.config);
        Parser parser = new Parser(env, source.getContent(), null);
        if (this.devMode) {
            env.addSource(source);
        }
        StatList stat = parser.parse();
        Template template = new Template(env, stat);
        return template;
    }

    public Engine addSharedFunction(String fileName) {
        this.config.addSharedFunction(fileName);
        return this;
    }

    public Engine addSharedFunction(ISource source) {
        this.config.addSharedFunction(source);
        return this;
    }

    public Engine addSharedFunction(String ... fileNames) {
        this.config.addSharedFunction(fileNames);
        return this;
    }

    public Engine addSharedFunctionByString(String content) {
        this.config.addSharedFunctionByString(content);
        return this;
    }

    public Engine addSharedObject(String name, Object object) {
        this.config.addSharedObject(name, object);
        return this;
    }

    public Engine removeSharedObject(String name) {
        this.config.removeSharedObject(name);
        return this;
    }

    public Engine addEnum(Class<? extends Enum<?>> enumClass) {
        Enum<?>[] es;
        LinkedHashMap map = new LinkedHashMap();
        for (Enum<?> e : es = enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return this.addSharedObject(enumClass.getSimpleName(), map);
    }

    public Engine setOutputDirectiveFactory(OutputDirectiveFactory outputDirectiveFactory) {
        this.config.setOutputDirectiveFactory(outputDirectiveFactory);
        return this;
    }

    public Engine addDirective(String directiveName, Class<? extends Directive> directiveClass, boolean keepLineBlank) {
        this.config.addDirective(directiveName, directiveClass, keepLineBlank);
        return this;
    }

    public Engine addDirective(String directiveName, Class<? extends Directive> directiveClass) {
        this.config.addDirective(directiveName, directiveClass);
        return this;
    }

    public Engine removeDirective(String directiveName) {
        this.config.removeDirective(directiveName);
        return this;
    }

    public Engine addSharedMethod(Object sharedMethodFromObject) {
        this.config.addSharedMethod(sharedMethodFromObject);
        return this;
    }

    public Engine addSharedMethod(Class<?> sharedMethodFromClass) {
        this.config.addSharedMethod(sharedMethodFromClass);
        return this;
    }

    public Engine addSharedStaticMethod(Class<?> sharedStaticMethodFromClass) {
        this.config.addSharedStaticMethod(sharedStaticMethodFromClass);
        return this;
    }

    public Engine removeSharedMethod(String methodName) {
        this.config.removeSharedMethod(methodName);
        return this;
    }

    public Engine removeSharedMethod(Class<?> clazz) {
        this.config.removeSharedMethod(clazz);
        return this;
    }

    public Engine removeSharedMethod(Method method) {
        this.config.removeSharedMethod(method);
        return this;
    }

    public void removeTemplateCache(String cacheKey) {
        this.templateCache.remove(cacheKey);
    }

    public void removeAllTemplateCache() {
        this.templateCache.clear();
    }

    public int getTemplateCacheSize() {
        return this.templateCache.size();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Template Engine: " + this.name;
    }

    public EngineConfig getEngineConfig() {
        return this.config;
    }

    public Engine setDevMode(boolean devMode) {
        this.devMode = devMode;
        this.config.setDevMode(devMode);
        if (this.devMode) {
            this.removeAllTemplateCache();
        }
        return this;
    }

    public boolean getDevMode() {
        return this.devMode;
    }

    public Engine setCacheStringTemplate(boolean cacheStringTemplate) {
        this.cacheStringTemplate = cacheStringTemplate;
        return this;
    }

    public Engine setSourceFactory(ISourceFactory sourceFactory) {
        this.config.setSourceFactory(sourceFactory);
        this.sourceFactory = sourceFactory;
        return this;
    }

    public Engine setToClassPathSourceFactory() {
        return this.setSourceFactory(new ClassPathSourceFactory());
    }

    public ISourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public Engine setBaseTemplatePath(String baseTemplatePath) {
        this.config.setBaseTemplatePath(baseTemplatePath);
        return this;
    }

    public String getBaseTemplatePath() {
        return this.config.getBaseTemplatePath();
    }

    public Engine setDatePattern(String datePattern) {
        this.config.setDatePattern(datePattern);
        return this;
    }

    public String getDatePattern() {
        return this.config.getDatePattern();
    }

    public Engine setEncoding(String encoding) {
        this.config.setEncoding(encoding);
        return this;
    }

    public String getEncoding() {
        return this.config.getEncoding();
    }

    public Engine setEncoderFactory(EncoderFactory encoderFactory) {
        this.config.setEncoderFactory(encoderFactory);
        return this;
    }

    public Engine setToJdkEncoderFactory() {
        this.config.setEncoderFactory(new JdkEncoderFactory());
        return this;
    }

    public Engine setWriterBufferSize(int bufferSize) {
        this.config.setWriterBufferSize(bufferSize);
        return this;
    }

    public Engine setCompressorOn(char separator) {
        return this.setCompressor(new Compressor(separator));
    }

    public Engine setCompressorOn() {
        return this.setCompressor(new Compressor());
    }

    public Engine setCompressor(Compressor compressor) {
        this.config.setCompressor(compressor);
        return this;
    }

    public Engine setReloadModifiedSharedFunctionInDevMode(boolean reloadModifiedSharedFunctionInDevMode) {
        this.config.setReloadModifiedSharedFunctionInDevMode(reloadModifiedSharedFunctionInDevMode);
        return this;
    }

    public static void addExtensionMethod(Class<?> targetClass, Object objectOfExtensionClass) {
        MethodKit.addExtensionMethod(targetClass, objectOfExtensionClass);
    }

    public static void addExtensionMethod(Class<?> targetClass, Class<?> extensionClass) {
        MethodKit.addExtensionMethod(targetClass, extensionClass);
    }

    public static void removeExtensionMethod(Class<?> targetClass, Object objectOfExtensionClass) {
        MethodKit.removeExtensionMethod(targetClass, objectOfExtensionClass);
    }

    public static void removeExtensionMethod(Class<?> targetClass, Class<?> extensionClass) {
        MethodKit.removeExtensionMethod(targetClass, extensionClass);
    }

    public static void addFieldGetter(int index, FieldGetter fieldGetter) {
        FieldKit.addFieldGetter(index, fieldGetter);
    }

    public static void addFieldGetterToLast(FieldGetter fieldGetter) {
        FieldKit.addFieldGetterToLast(fieldGetter);
    }

    public static void addFieldGetterToFirst(FieldGetter fieldGetter) {
        FieldKit.addFieldGetterToFirst(fieldGetter);
    }

    public static void removeFieldGetter(Class<? extends FieldGetter> fieldGetterClass) {
        FieldKit.removeFieldGetter(fieldGetterClass);
    }

    public static void setFastFieldKeyBuilder(boolean enable) {
        FieldKeyBuilder.setFastFieldKeyBuilder(enable);
    }

    public static void setFastMode(boolean fastMode) {
        FieldKit.setFastMode(fastMode);
        FieldKeyBuilder.setFastFieldKeyBuilder(fastMode);
    }

    static {
        engineMap = new HashMap<String, Engine>(64, 0.5f);
        MAIN_ENGINE = new Engine(MAIN_ENGINE_NAME);
        engineMap.put(MAIN_ENGINE_NAME, MAIN_ENGINE);
    }
}

