/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow.session;

import com.jfinal.server.undertow.session.HotSwapSessionManager;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.core.InMemorySessionManagerFactory;

public class HotSwapSessionManagerFactory
extends InMemorySessionManagerFactory {
    public static final HotSwapSessionManagerFactory me = new HotSwapSessionManagerFactory();
    private volatile SessionManager sessionManager = null;
    private final int maxSessions;
    private final boolean expireOldestUnusedSessionOnMax;

    public HotSwapSessionManagerFactory() {
        this(-1, false);
    }

    public HotSwapSessionManagerFactory(int maxSessions) {
        this(maxSessions, false);
    }

    public HotSwapSessionManagerFactory(int maxSessions, boolean expireOldestUnusedSessionOnMax) {
        this.maxSessions = maxSessions;
        this.expireOldestUnusedSessionOnMax = expireOldestUnusedSessionOnMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionManager createSessionManager(Deployment deployment) {
        if (this.sessionManager == null) {
            HotSwapSessionManagerFactory hotSwapSessionManagerFactory = me;
            synchronized (hotSwapSessionManagerFactory) {
                if (this.sessionManager == null) {
                    this.sessionManager = new HotSwapSessionManager(deployment.getDeploymentInfo().getSessionIdGenerator(), deployment.getDeploymentInfo().getDeploymentName(), this.maxSessions, this.expireOldestUnusedSessionOnMax, deployment.getDeploymentInfo().getMetricsCollector() != null);
                }
            }
        }
        return this.sessionManager;
    }
}

