/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.hocon;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.PropertiesConfigSource;
import com.mchange.v3.hocon.HoconUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.LinkedList;

public final class HoconPropertiesConfigSource
implements PropertiesConfigSource {
    private static Config extractConfig(String string) throws FileNotFoundException, Exception {
        int n = string.indexOf(58);
        if (n >= 0 && "hocon".equals(string.substring(0, n).toLowerCase())) {
            Config config;
            String string2;
            String string3;
            int n2 = string.lastIndexOf(35);
            if (n2 > 0) {
                string3 = string.substring(n + 1, n2).trim();
                string2 = string.substring(n2 + 1).replace('/', '.').trim();
            } else {
                string3 = string.substring(n + 1);
                string2 = null;
            }
            if ("/".equals(string3) || "".equals(string3)) {
                config = ConfigFactory.load();
            } else {
                URL uRL = HoconPropertiesConfigSource.class.getResource(string3);
                if (uRL == null) {
                    throw new FileNotFoundException(String.format("Could not find HOCON configuration for resource path '%s'.", string3));
                }
                config = ConfigFactory.parseURL((URL)uRL);
            }
            if (string2 != null) {
                config = config.getConfig(string2);
            }
            return config;
        }
        throw new IllegalArgumentException(String.format("Invalid resource identifier for hocon config file: '%s'", string));
    }

    @Override
    public PropertiesConfigSource.Parse propertiesFromSource(String string) throws FileNotFoundException, Exception {
        Config config = HoconPropertiesConfigSource.extractConfig(string);
        HoconUtils.PropertiesConversion propertiesConversion = HoconUtils.configToProperties(config);
        LinkedList<DelayedLogItem> linkedList = new LinkedList<DelayedLogItem>();
        for (String string2 : propertiesConversion.unrenderable) {
            linkedList.add(new DelayedLogItem(DelayedLogItem.Level.FINE, String.format("Value at path '%s' could not be converted to a String.", string2)));
        }
        return new PropertiesConfigSource.Parse(propertiesConversion.properties, linkedList);
    }
}

