/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.jar.MockrunnerJars;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;

public class MockrunnerJarsTest
extends TestCase {
    private Set getTestDependencies() {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.add("struts-core-1.3.10.jar");
        dependencies.add("servlet-api.jar");
        dependencies.add("jboss-j2ee.jar");
        dependencies.add("nekohtml.jar");
        dependencies.add("xercesImpl.jar");
        dependencies.add("xyz.jar");
        return dependencies;
    }

    public void testPermission() {
        MockrunnerJars.Permission permission = new MockrunnerJars.Permission(false, true, true, false, true);
        Set prohibited = permission.getProhibited(this.getTestDependencies());
        MockrunnerJarsTest.assertEquals((int)1, (int)prohibited.size());
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("struts-core-1.3.10.jar"));
        permission = new MockrunnerJars.Permission(false, true, true, false, false);
        prohibited = permission.getProhibited(this.getTestDependencies());
        MockrunnerJarsTest.assertEquals((int)3, (int)prohibited.size());
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("struts-core-1.3.10.jar"));
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("nekohtml.jar"));
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("xercesImpl.jar"));
        permission = new MockrunnerJars.Permission(false, false, true, false, false);
        prohibited = permission.getProhibited(this.getTestDependencies());
        MockrunnerJarsTest.assertEquals((int)4, (int)prohibited.size());
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("struts-core-1.3.10.jar"));
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("servlet-api.jar"));
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("nekohtml.jar"));
        MockrunnerJarsTest.assertTrue((boolean)prohibited.contains("xercesImpl.jar"));
        permission = new MockrunnerJars.Permission(false, false, false, false, false);
        prohibited = permission.getProhibited(this.getTestDependencies());
        MockrunnerJarsTest.assertEquals((int)5, (int)prohibited.size());
        MockrunnerJarsTest.assertFalse((boolean)prohibited.contains("xyz.jar"));
        permission = new MockrunnerJars.Permission(true, true, true, true, true);
        prohibited = permission.getProhibited(this.getTestDependencies());
        MockrunnerJarsTest.assertTrue((boolean)prohibited.isEmpty());
    }
}

