/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.mybatis.TypeHandlerObject;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;

public class SqlArgsParameterHandler
extends DefaultParameterHandler {
    private final Map parameterObject;

    public SqlArgsParameterHandler(MappedStatement mappedStatement, Map parameterObject, BoundSql boundSql) {
        super(mappedStatement, (Object)parameterObject, boundSql);
        this.parameterObject = parameterObject;
    }

    public void setParameters(PreparedStatement ps) {
        try {
            this.doSetParameters(ps);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void doSetParameters(PreparedStatement ps) throws SQLException {
        Object[] sqlArgs = (Object[])this.parameterObject.get("$$sql_args");
        if (sqlArgs != null && sqlArgs.length > 0) {
            int index = 1;
            for (Object value : sqlArgs) {
                if (value instanceof TypeHandlerObject) {
                    ((TypeHandlerObject)value).setParameter(ps, index++);
                    continue;
                }
                if (value instanceof Date) {
                    this.setDateParameter(ps, (Date)value, index++);
                    continue;
                }
                if (value instanceof byte[]) {
                    ps.setBytes(index++, (byte[])value);
                    continue;
                }
                ps.setObject(index++, value);
            }
        } else {
            super.setParameters(ps);
        }
    }

    private void setDateParameter(PreparedStatement ps, Date value, int index) throws SQLException {
        if (value instanceof java.sql.Date) {
            ps.setDate(index, (java.sql.Date)value);
        } else if (value instanceof Timestamp) {
            ps.setTimestamp(index, (Timestamp)value);
        } else {
            ps.setTimestamp(index, new Timestamp(value.getTime()));
        }
    }
}

