/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexAssert;
import com.mybatisflex.core.provider.ProviderUtil;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;

public class EntitySqlProvider {
    private EntitySqlProvider() {
    }

    public static String insert(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null.");
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.initVersionValueIfNecessary(entity);
        tableInfo.initTenantIdIfNecessary(entity);
        tableInfo.initLogicDeleteValueIfNecessary(entity);
        tableInfo.invokeOnInsertListener(entity);
        Object[] values = tableInfo.buildInsertSqlArgs(entity, ignoreNulls);
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forInsertEntity(tableInfo, entity, ignoreNulls);
    }

    public static String insertWithPk(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null.");
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.initVersionValueIfNecessary(entity);
        tableInfo.initTenantIdIfNecessary(entity);
        tableInfo.initLogicDeleteValueIfNecessary(entity);
        tableInfo.invokeOnInsertListener(entity);
        Object[] values = tableInfo.buildInsertSqlArgsWithPk(entity, ignoreNulls);
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forInsertEntityWithPk(tableInfo, entity, ignoreNulls);
    }

    public static String insertBatch(Map params, ProviderContext context) {
        List<Object> entities = ProviderUtil.getEntities(params);
        FlexAssert.notEmpty(entities, "entities can not be null or empty.");
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        for (Object entity : entities) {
            tableInfo.initVersionValueIfNecessary(entity);
            tableInfo.initTenantIdIfNecessary(entity);
            tableInfo.initLogicDeleteValueIfNecessary(entity);
            tableInfo.invokeOnInsertListener(entity);
        }
        Object[] allValues = FlexConsts.EMPTY_ARRAY;
        for (Object entity : entities) {
            allValues = ArrayUtil.concat(allValues, tableInfo.buildInsertSqlArgs(entity, false));
        }
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forInsertEntityBatch(tableInfo, entities);
    }

    public static String deleteById(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValues can not be null or empty.");
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forDeleteEntityById(tableInfo);
    }

    public static String deleteBatchByIds(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValues can not be null or empty.");
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(primaryValues, tenantIdArgs));
        return DialectFactory.getDialect().forDeleteEntityBatchByIds(tableInfo, primaryValues);
    }

    public static String deleteByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        CPI.setFromIfNecessary(queryWrapper, tableInfo.getSchema(), tableInfo.getTableName());
        tableInfo.appendConditions(null, queryWrapper);
        String sql = DialectFactory.getDialect().forDeleteEntityBatchByQuery(tableInfo, queryWrapper);
        ProviderUtil.setSqlArgs(params, CPI.getValueArray(queryWrapper));
        return sql;
    }

    public static String update(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null");
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.invokeOnUpdateListener(entity);
        Object[] updateValues = tableInfo.buildUpdateSqlArgs(entity, ignoreNulls, false);
        Object[] primaryValues = tableInfo.buildPkSqlArgs(entity);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        FlexAssert.assertAreNotNull(primaryValues, "The value of primary key must not be null, entity[%s]", entity);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(updateValues, primaryValues, tenantIdArgs, new Object[0][]));
        return DialectFactory.getDialect().forUpdateEntity(tableInfo, entity, ignoreNulls);
    }

    public static String updateByQuery(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        FlexAssert.notNull(entity, "entity can not be null");
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.invokeOnUpdateListener(entity);
        tableInfo.appendConditions(entity, queryWrapper);
        String sql = DialectFactory.getDialect().forUpdateEntityByQuery(tableInfo, entity, ignoreNulls, queryWrapper);
        Object[] values = tableInfo.buildUpdateSqlArgs(entity, ignoreNulls, true);
        Object[] queryParams = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(values, queryParams));
        return sql;
    }

    public static String updateNumberAddByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        String fieldName = ProviderUtil.getFieldName(params);
        Number value = (Number)ProviderUtil.getValue(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.appendConditions(null, queryWrapper);
        String sql = DialectFactory.getDialect().forUpdateNumberAddByQuery(tableInfo.getSchema(), tableInfo.getTableName(), fieldName, value, queryWrapper);
        Object[] queryParams = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, queryParams);
        return sql;
    }

    public static String selectOneById(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValues can not be null or empty.");
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forSelectOneEntityById(tableInfo);
    }

    public static String selectListByIds(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        FlexAssert.notEmpty(primaryValues, "primaryValues can not be null or empty.");
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forSelectEntityListByIds(tableInfo, primaryValues);
    }

    public static String selectListByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        EntitySqlProvider.appendTableConditions(context, queryWrapper, true);
        String sql = DialectFactory.getDialect().forSelectByQuery(queryWrapper);
        Object[] values = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, values);
        return sql;
    }

    public static String selectObjectByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        EntitySqlProvider.appendTableConditions(context, queryWrapper, false);
        String sql = DialectFactory.getDialect().forSelectByQuery(queryWrapper);
        Object[] values = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, values);
        return sql;
    }

    private static void appendTableConditions(ProviderContext context, QueryWrapper queryWrapper, boolean setSelectColumns) {
        block4: {
            block3: {
                List<TableInfo> tableInfos = EntitySqlProvider.getTableInfos(context, queryWrapper);
                if (!CollectionUtil.isNotEmpty(tableInfos)) break block3;
                for (TableInfo tableInfo : tableInfos) {
                    tableInfo.appendConditions(null, queryWrapper);
                    if (setSelectColumns) {
                        CPI.setSelectColumnsIfNecessary(queryWrapper, tableInfo.getDefaultQueryColumn());
                    }
                    CPI.setFromIfNecessary(queryWrapper, tableInfo.getSchema(), tableInfo.getTableName());
                }
                break block4;
            }
            List<QueryWrapper> childQueryWrappers = CPI.getChildSelect(queryWrapper);
            if (!CollectionUtil.isNotEmpty(childQueryWrappers)) break block4;
            for (QueryWrapper childQueryWrapper : childQueryWrappers) {
                EntitySqlProvider.appendTableConditions(context, childQueryWrapper, setSelectColumns);
            }
        }
    }

    private static List<TableInfo> getTableInfos(ProviderContext context, QueryWrapper queryWrapper) {
        ArrayList<TableInfo> tableInfos;
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (CollectionUtil.isNotEmpty(queryTables)) {
            tableInfos = new ArrayList();
            for (QueryTable queryTable : queryTables) {
                TableInfo tableInfo;
                String tableNameWithSchema = queryTable.getNameWithSchema();
                if (!StringUtil.isNotBlank(tableNameWithSchema) || (tableInfo = TableInfoFactory.ofTableName(tableNameWithSchema)) == null) continue;
                tableInfos.add(tableInfo);
            }
        } else {
            tableInfos = Collections.singletonList(ProviderUtil.getTableInfo(context));
        }
        return tableInfos;
    }
}

