/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.processor.builder.ContentBuilder;
import com.mybatisflex.processor.config.ConfigurationKey;
import com.mybatisflex.processor.config.MybatisFlexConfig;
import com.mybatisflex.processor.util.FileUtil;
import com.mybatisflex.processor.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

public class MybatisFlexProcessor
extends AbstractProcessor {
    private static final List<String> DEFAULT_SUPPORT_COLUMN_TYPES = Arrays.asList(Integer.TYPE.getName(), Integer.class.getName(), Short.TYPE.getName(), Short.class.getName(), Long.TYPE.getName(), Long.class.getName(), Float.TYPE.getName(), Float.class.getName(), Double.TYPE.getName(), Double.class.getName(), Boolean.TYPE.getName(), Boolean.class.getName(), java.util.Date.class.getName(), Date.class.getName(), Time.class.getName(), Timestamp.class.getName(), Instant.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), LocalTime.class.getName(), OffsetDateTime.class.getName(), OffsetTime.class.getName(), ZonedDateTime.class.getName(), Year.class.getName(), Month.class.getName(), YearMonth.class.getName(), JapaneseDate.class.getName(), byte[].class.getName(), Byte[].class.getName(), Byte.class.getName(), BigInteger.class.getName(), BigDecimal.class.getName(), Character.TYPE.getName(), String.class.getName(), Character.class.getName());
    private Filer filer;
    private Types typeUtils;
    private MybatisFlexConfig configuration;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.configuration = new MybatisFlexConfig(this.filer);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            StringBuilder fieldBuilder;
            StringBuilder importBuilder;
            System.out.println("mybatis flex processor run start...");
            if ("false".equalsIgnoreCase(this.configuration.get(ConfigurationKey.ENABLE))) {
                return true;
            }
            boolean allInTables = "true".equalsIgnoreCase(this.configuration.get(ConfigurationKey.ALL_IN_TABLES));
            if (allInTables) {
                importBuilder = new StringBuilder();
                fieldBuilder = new StringBuilder();
            } else {
                fieldBuilder = null;
                importBuilder = null;
            }
            String genPath = this.configuration.get(ConfigurationKey.GEN_PATH);
            String tablesPackage = this.configuration.get(ConfigurationKey.TABLES_PACKAGE);
            String mappersPackage = this.configuration.get(ConfigurationKey.MAPPERS_PACKAGE);
            String baseMapperClass = this.configuration.get(ConfigurationKey.BASE_MAPPER_CLASS);
            String tablesDefSuffix = this.configuration.get(ConfigurationKey.TABLES_DEF_SUFFIX);
            String tablesNameStyle = this.configuration.get(ConfigurationKey.TABLE_NAME_STYLE);
            String tablesClassName = this.configuration.get(ConfigurationKey.TABLES_CLASS_NAME);
            String mappersGenerateEnable = this.configuration.get(ConfigurationKey.MAPPERS_GENERATE_ENABLE);
            String[] entityIgnoreSuffixes = this.configuration.get(ConfigurationKey.IGNORE_SUFFIXES).split(",");
            String entityClassReference = null;
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(Table.class);
            int size = elementsAnnotatedWith.size();
            int index = 0;
            for (Element element : elementsAnnotatedWith) {
                ++index;
                Table table = element.getAnnotation(Table.class);
                assert (table != null);
                LinkedHashMap<String, String> propertyAndColumns = new LinkedHashMap<String, String>();
                ArrayList<String> defaultColumns = new ArrayList<String>();
                TypeElement classElement = (TypeElement)element;
                do {
                    this.fillPropertyAndColumns(propertyAndColumns, defaultColumns, classElement, table.camelToUnderline());
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String entityClass = element.toString();
                String entityClassName = StrUtil.getClassName(entityClass);
                for (String entityIgnoreSuffix : entityIgnoreSuffixes) {
                    if (!entityClassName.endsWith(entityIgnoreSuffix.trim())) continue;
                    entityClassName = entityClassName.substring(0, entityClassName.length() - entityIgnoreSuffix.length());
                    break;
                }
                String tableDefPackage = StrUtil.buildTableDefPackage(entityClass);
                String tableDefClassName = entityClassName.concat("TableDef");
                String tableDefContent = ContentBuilder.buildTableDef(table, entityClass, entityClassName, allInTables, tableDefPackage, tableDefClassName, tablesNameStyle, tablesDefSuffix, propertyAndColumns, defaultColumns);
                this.processGenClass(genPath, tableDefPackage, tableDefClassName, tableDefContent);
                if (allInTables) {
                    entityClassReference = entityClass;
                    ContentBuilder.buildTablesField(importBuilder, fieldBuilder, table, entityClass, entityClassName, tablesNameStyle, tablesDefSuffix);
                }
                if ("true".equalsIgnoreCase(mappersGenerateEnable) && table.mapperGenerateEnable()) {
                    String realMapperPackage = StrUtil.isBlank(mappersPackage) ? StrUtil.buildMapperPackage(entityClass) : mappersPackage;
                    String mapperClassName = entityClassName.concat("Mapper");
                    String mapperClassContent = ContentBuilder.buildMapper(entityClass, entityClassName, realMapperPackage, mapperClassName, baseMapperClass);
                    this.processGenClass(genPath, realMapperPackage, mapperClassName, mapperClassContent);
                }
                if (index != size || !allInTables) continue;
                String realTablesPackage = StrUtil.isBlank(tablesPackage) ? StrUtil.buildTableDefPackage(entityClassReference) : tablesPackage;
                String realTablesClassName = StrUtil.isBlank(tablesClassName) ? "Tables" : tablesClassName;
                String tablesContent = ContentBuilder.buildTables(importBuilder, fieldBuilder, realTablesPackage, tablesClassName);
                this.processGenClass(genPath, realTablesPackage, realTablesClassName, tablesContent);
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(Table.class.getCanonicalName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void fillPropertyAndColumns(Map<String, String> propertyAndColumns, List<String> defaultColumns, TypeElement classElement, boolean camelToUnderline) {
        for (Element element : classElement.getEnclosedElements()) {
            Column column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC) || (column = element.getAnnotation(Column.class)) != null && column.ignore()) continue;
            String[] typeHandlerClass = new String[]{""};
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                annotationMirror.getElementValues().forEach((executableElement, annotationValue) -> {
                    if ("typeHandler".contentEquals(executableElement.getSimpleName())) {
                        typeHandlerClass[0] = annotationValue.toString();
                    }
                });
            }
            TypeMirror typeMirror = element.asType();
            Element element2 = this.typeUtils.asElement(typeMirror);
            if (element2 != null) {
                typeMirror = element2.asType();
            }
            String typeString = typeMirror.toString().trim();
            TypeElement typeElement = null;
            if (typeMirror.getKind() == TypeKind.DECLARED) {
                typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            }
            if ((column == null || "org.apache.ibatis.type.UnknownTypeHandler".equals(typeHandlerClass[0])) && !DEFAULT_SUPPORT_COLUMN_TYPES.contains(typeString) && typeElement != null && ElementKind.ENUM != typeElement.getKind()) continue;
            String columnName = column != null && !StrUtil.isBlank(column.value()) ? column.value() : (camelToUnderline ? StrUtil.camelToUnderline(element.toString()) : element.toString());
            propertyAndColumns.put(element.toString(), columnName);
            if (column != null && (column.isLarge() || column.isLogicDelete())) continue;
            defaultColumns.add(columnName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processGenClass(String genBasePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (genBasePath == null || genBasePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (FileUtil.isAbsolutePath(genBasePath)) {
                realPath = genBasePath;
            } else {
                String projectRootPath = FileUtil.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, genBasePath).getAbsolutePath();
            }
            boolean fromTestSource = FileUtil.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.err.println(">>>>> ERROR: can not mkdirs by mybatis-flex processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(Files.newOutputStream(genJavaFile.toPath(), new OpenOption[0]));
            writer.write(genContent);
            writer.flush();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

