/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor.builder;

import com.mybatisflex.annotation.Table;
import com.mybatisflex.processor.util.StrUtil;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ContentBuilder {
    private ContentBuilder() {
    }

    public static String buildMapper(String entityClass, String entityClassName, String mappersPackage, String mapperClassName, String baseMapperClass) {
        StringBuilder content = new StringBuilder("package ");
        content.append(mappersPackage).append(";\n\n");
        content.append("import ").append(baseMapperClass).append(";\n");
        content.append("import ").append(entityClass).append(";\n\n");
        String realEntityClassName = StrUtil.getClassName(entityClass);
        String baseMapperClassName = StrUtil.getClassName(baseMapperClass);
        content.append("public interface ").append(mapperClassName).append(" extends ").append(baseMapperClassName).append("<").append(realEntityClassName).append("> {\n}");
        return content.toString();
    }

    public static String buildTableDef(Table table, String entityClass, String entityClassName, boolean allInTables, String tableDefPackage, String tableDefClassName, String tablesNameStyle, String tablesDefSuffix, Map<String, String> propertyAndColumns, List<String> defaultColumns) {
        StringBuilder content = new StringBuilder("package ");
        content.append(tableDefPackage).append(";\n\n");
        content.append("import com.mybatisflex.core.query.QueryColumn;\n");
        content.append("import com.mybatisflex.core.table.TableDef;\n\n");
        content.append("// Auto generate by mybatis-flex, do not modify it.\n");
        content.append("public class ").append(tableDefClassName).append(" extends TableDef {\n\n");
        if (!allInTables) {
            String schema = !StrUtil.isBlank(table.schema()) ? table.schema() : "";
            String tableName = !StrUtil.isBlank(table.value()) ? table.value() : StrUtil.firstCharToLowerCase(entityClassName);
            content.append("    public static final ").append(tableDefClassName).append(' ').append(StrUtil.buildFieldName(entityClassName.concat(tablesDefSuffix != null ? tablesDefSuffix.trim() : ""), tablesNameStyle)).append(" = new ").append(tableDefClassName).append("(\"").append(schema).append("\", \"").append(tableName).append("\");\n\n");
        }
        propertyAndColumns.forEach((property, column) -> content.append("    public QueryColumn ").append(StrUtil.buildFieldName(property, tablesNameStyle)).append(" = new QueryColumn(this, \"").append((String)column).append("\");\n"));
        content.append("    public QueryColumn ").append(StrUtil.buildFieldName("allColumns", tablesNameStyle)).append(" = new QueryColumn(this, \"*\");\n");
        StringJoiner defaultColumnJoiner = new StringJoiner(", ");
        propertyAndColumns.forEach((property, column) -> {
            if (defaultColumns.contains(column)) {
                defaultColumnJoiner.add(StrUtil.buildFieldName(property, tablesNameStyle));
            }
        });
        content.append("    public QueryColumn[] ").append(StrUtil.buildFieldName("defaultColumns", tablesNameStyle)).append(" = new QueryColumn[]{").append(defaultColumnJoiner).append("};\n\n");
        content.append("    public ").append(tableDefClassName).append("(String schema, String tableName) {\n").append("       super(schema, tableName);\n").append("    }\n\n}\n");
        return content.toString();
    }

    public static String buildTables(StringBuilder importBuilder, StringBuilder fieldBuilder, String tablesPackage, String tablesClassName) {
        return "package " + tablesPackage + ";\n\n" + importBuilder.toString() + "\n// Auto generate by mybatis-flex, do not modify it.\npublic class " + tablesClassName + " {\n\n   private " + tablesClassName + "() {\n   }\n\n" + fieldBuilder.toString() + "\n}\n";
    }

    public static void buildTablesField(StringBuilder importBuilder, StringBuilder fieldBuilder, Table table, String entityClass, String entityClassName, String tablesNameStyle, String tablesDefSuffix) {
        String tableDefPackage = StrUtil.buildTableDefPackage(entityClass);
        String tableDefClassName = entityClassName.concat("TableDef");
        importBuilder.append("import ").append(tableDefPackage).append('.').append(tableDefClassName).append(";\n");
        String schema = !StrUtil.isBlank(table.schema()) ? table.schema() : "";
        String tableName = !StrUtil.isBlank(table.value()) ? table.value() : StrUtil.firstCharToLowerCase(entityClassName);
        fieldBuilder.append("   public static final ").append(tableDefClassName).append(' ').append(StrUtil.buildFieldName(entityClassName.concat(tablesDefSuffix != null ? tablesDefSuffix.trim() : ""), tablesNameStyle)).append(" = new ").append(tableDefClassName).append("(\"").append(schema).append("\", \"").append(tableName).append("\");\n");
    }
}

