/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.processor.util;

public class StrUtil {
    private StrUtil() {
    }

    public static String getClassName(String str) {
        return str.substring(str.lastIndexOf(".") + 1);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String camelToUnderline(String str) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static String buildFieldName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return StrUtil.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(style)) {
            return StrUtil.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(style)) {
            return StrUtil.firstCharToUpperCase(name);
        }
        return StrUtil.firstCharToLowerCase(name);
    }

    public static String buildTableDefPackage(String entityClass) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClass.contains(".")) {
            guessPackage.append("table");
        } else {
            guessPackage.append(entityClass, 0, entityClass.lastIndexOf(".")).append(".table");
        }
        return guessPackage.toString();
    }

    public static String buildMapperPackage(String entityClass) {
        if (!entityClass.contains(".")) {
            return "mapper";
        }
        String entityPackage = entityClass.substring(0, entityClass.lastIndexOf("."));
        if (entityPackage.contains(".")) {
            return entityPackage.substring(0, entityPackage.lastIndexOf(".")) + ".mapper";
        }
        return "mapper";
    }
}

