/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.utils;

import com.netflix.curator.CuratorZookeeperClient;
import com.netflix.curator.RetryLoop;
import com.netflix.curator.utils.ZKPaths;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class EnsurePath {
    private final String path;
    private final boolean makeLastNode;
    private final AtomicReference<Helper> helper;
    private static final Helper doNothingHelper = new Helper(){

        @Override
        public void ensure(CuratorZookeeperClient client, String path, boolean makeLastNode) throws Exception {
        }
    };

    public EnsurePath(String path) {
        this(path, null, true);
    }

    public void ensure(CuratorZookeeperClient client) throws Exception {
        Helper localHelper = this.helper.get();
        localHelper.ensure(client, this.path, this.makeLastNode);
    }

    public EnsurePath excludingLast() {
        return new EnsurePath(this.path, this.helper, false);
    }

    private EnsurePath(String path, AtomicReference<Helper> helper, boolean makeLastNode) {
        this.path = path;
        this.makeLastNode = makeLastNode;
        this.helper = helper != null ? helper : new AtomicReference<InitialHelper>(new InitialHelper());
    }

    private class InitialHelper
    implements Helper {
        private boolean isSet = false;

        private InitialHelper() {
        }

        @Override
        public synchronized void ensure(final CuratorZookeeperClient client, final String path, final boolean makeLastNode) throws Exception {
            if (!this.isSet) {
                RetryLoop.callWithRetry(client, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ZKPaths.mkdirs(client.getZooKeeper(), path, makeLastNode);
                        EnsurePath.this.helper.set(doNothingHelper);
                        InitialHelper.this.isSet = true;
                        return null;
                    }
                });
            }
        }
    }

    private static interface Helper {
        public void ensure(CuratorZookeeperClient var1, String var2, boolean var3) throws Exception;
    }
}

