/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnusedImportsCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.unused";
    private static final Pattern CLASS_NAME = Pattern.compile("((:?[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final Pattern FIRST_CLASS_NAME = Pattern.compile("^" + CLASS_NAME);
    private static final Pattern ARGUMENT_NAME = Pattern.compile("[(,]\\s*" + CLASS_NAME.pattern());
    private static final String STAR_IMPORT_SUFFIX = ".*";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<String> referenced = new HashSet<String>();
    private boolean collect;
    private boolean processJavadoc = true;

    public void setProcessJavadoc(boolean value) {
        this.processJavadoc = value;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.collect = false;
        this.imports.clear();
        this.referenced.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.imports.stream().filter(imp -> !this.referenced.contains(CommonUtils.baseClassName(imp.getText()))).forEach(imp -> this.log(imp.getLineNo(), imp.getColumnNo(), MSG_KEY, imp.getText()));
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 58) {
            if (this.collect) {
                this.processIdent(ast);
            }
        } else if (ast.getType() == 30) {
            this.processImport(ast);
        } else if (ast.getType() == 152) {
            this.processStaticImport(ast);
        } else {
            this.collect = true;
            if (this.processJavadoc) {
                this.collectReferencesFromJavadoc(ast);
            }
        }
    }

    private void processIdent(DetailAST ast) {
        DetailAST parent = ast.getParent();
        int parentType = parent.getType();
        if (parentType != 59 && parentType != 9 || parentType == 59 && ast.getNextSibling() != null) {
            this.referenced.add(ast.getText());
        }
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void processStaticImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (!name.getText().endsWith(STAR_IMPORT_SUFFIX)) {
            this.imports.add(name);
        }
    }

    private void collectReferencesFromJavadoc(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock textBlock = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (textBlock != null) {
            this.referenced.addAll(UnusedImportsCheck.collectReferencesFromJavadoc(textBlock));
        }
    }

    private static Set<String> collectReferencesFromJavadoc(TextBlock textBlock) {
        HashSet<String> references = new HashSet<String>();
        UnusedImportsCheck.getValidTags(textBlock, JavadocUtils.JavadocTagType.INLINE).stream().filter(JavadocTag::canReferenceImports).forEach(tag -> references.addAll(UnusedImportsCheck.processJavadocTag(tag)));
        UnusedImportsCheck.getValidTags(textBlock, JavadocUtils.JavadocTagType.BLOCK).stream().filter(JavadocTag::canReferenceImports).forEach(tag -> references.addAll(UnusedImportsCheck.matchPattern(tag.getFirstArg(), FIRST_CLASS_NAME)));
        return references;
    }

    private static List<JavadocTag> getValidTags(TextBlock cmt, JavadocUtils.JavadocTagType tagType) {
        return JavadocUtils.getJavadocTags(cmt, tagType).getValidTags();
    }

    private static Set<String> processJavadocTag(JavadocTag tag) {
        HashSet<String> references = new HashSet<String>();
        String identifier = tag.getFirstArg().trim();
        for (Pattern pattern : new Pattern[]{FIRST_CLASS_NAME, ARGUMENT_NAME}) {
            references.addAll(UnusedImportsCheck.matchPattern(identifier, pattern));
        }
        return references;
    }

    private static Set<String> matchPattern(String identifier, Pattern pattern) {
        HashSet<String> references = new HashSet<String>();
        Matcher matcher = pattern.matcher(identifier);
        while (matcher.find()) {
            references.add(matcher.group(1));
        }
        return references;
    }
}

