/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.business.push;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.MoveBackToMLVO;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_ContentInfoLogSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.util.StringsUtil;
import com.sobey.cms.interfaces.push.domain.ResultInfo;
import com.sobey.cms.interfaces.push.util.PushVideoUtil;
import com.sobey.scms.contentinfo.interfaces.util.ContentUtil;
import com.sobey.scms.trasncode.MPCCall;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoBackService {
    private static final Logger log = LoggerFactory.getLogger(VideoBackService.class);

    public static ResultInfo backProcess(String[] contentIds, Long siteId, Long interfaceId) {
        DBConnPool.setDBConnPool((Long)siteId);
        DataTable dataTable = VideoBackService.getVideoBackUrl((Long)interfaceId);
        if (dataTable == null && dataTable.getRowCount() == 0) {
            VideoBackService.writePushLogInfo(Arrays.asList(contentIds), (Long)interfaceId, (int)0, (String)"\u89c6\u9891\u56de\u8fc1\u914d\u7f6e\u5f02\u5e38\uff0c\u68c0\u67e5\uff1a\u5728\u6269\u5c55\u4fe1\u606f\u4e2d\u662f\u5426\u914d\u7f6e\u7b56\u7565id\uff0c\u56de\u8c03\u5730\u5740\u662f\u5426\u914d\u7f6e!");
            return ResultInfo.builder().status(Integer.valueOf(0)).message("\u89c6\u9891\u56de\u8fc1\u914d\u7f6e\u5f02\u5e38\uff0c\u68c0\u67e5\uff1a\u5728\u6269\u5c55\u4fe1\u606f\u4e2d\u662f\u5426\u914d\u7f6e\u7b56\u7565id\uff0c\u56de\u8c03\u5730\u5740\u662f\u5426\u914d\u7f6e!").build();
        }
        StringBuilder errorMessage = new StringBuilder();
        for (String contentId : contentIds) {
            Long contentInfoLogId;
            SCMS_ContentinfoSchema scmsContentinfoSchema = VideoBackService.getScmsContentinfoSchema((String)contentId);
            String path = scmsContentinfoSchema.getPath();
            if (StringUtils.isBlank((CharSequence)path)) {
                log.warn("\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a,contentId{},path:{}", (Object)contentId, (Object)path);
                errorMessage.append("contentId=").append(contentId).append(",\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a!");
                VideoBackService.writePushLogInfo((List)Lists.newArrayList((Object[])new String[]{contentId}), (Long)interfaceId, (int)0, (String)"\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a!");
                continue;
            }
            String videoSourceDir = SiteUtil.getWinVideoUploadDir((String)String.valueOf(siteId));
            path = StringUtil.replaceAllToBack_Slant((String)(videoSourceDir + path));
            MoveBackToMLVO moveBackToMLVO = VideoBackService.builderMoveBackToMLVO((Long)siteId, (SCMS_ContentinfoSchema)scmsContentinfoSchema, (String)path, (Long)(contentInfoLogId = Long.valueOf(NoUtil.getMaxID((String)"ContentInfoLogId"))), (DataTable)dataTable);
            String status = VideoBackService.callMPC((MoveBackToMLVO)moveBackToMLVO, (String)dataTable.getString(0, "url"));
            if ("1".equals(status)) {
                Transaction transaction = new Transaction();
                SCMS_ContentInfoLogSchema scmsContentInfoLogSchema = VideoBackService.builderScmsContentInfoLogSchema((String)contentId, (Long)contentInfoLogId);
                transaction.add((Schema)scmsContentInfoLogSchema, 1);
                transaction.commit();
                VideoBackService.writePushLogInfo((List)Lists.newArrayList((Object[])new String[]{contentId}), (Long)interfaceId, (int)2, (String)"\u5df2\u5411MPC\u4e0b\u8fbe\u56de\u8fc1\u4efb\u52a1\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85!");
                continue;
            }
            errorMessage.append("contentId=").append(contentId).append(",MPC\u63a5\u6536\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38!");
            VideoBackService.writePushLogInfo((List)Lists.newArrayList((Object[])new String[]{contentId}), (Long)interfaceId, (int)0, (String)"MPC\u63a5\u6536\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38!");
        }
        return VideoBackService.builderResultInfo((String)errorMessage.toString());
    }

    private static String callMPC(MoveBackToMLVO moveBackToMLVO, String url) {
        try {
            String result = MPCCall.moveBackToMLCallMPC((MoveBackToMLVO)moveBackToMLVO, (String)url);
            Document document = DocumentHelper.parseText((String)result);
            Node mpcWebCmd = document.selectSingleNode("MPCWebCmd");
            Node rtnDocument = null;
            Node rtn_addTask = mpcWebCmd.selectSingleNode("Rtn_AddTask");
            rtnDocument = rtn_addTask != null ? rtn_addTask : mpcWebCmd.selectSingleNode("Rtn_Unknow");
            return rtnDocument.selectSingleNode("MPC_Status//Status").getText();
        }
        catch (Exception e) {
            log.error("\u89c6\u9891\u56de\u8fc1\u51fa\u73b0\u5f02\u5e38,requestId:" + moveBackToMLVO.getRequestId(), (Throwable)e);
            return null;
        }
    }

    private static void writePushLogInfo(List<String> contentIdList, Long interfaceId, int pushStatus, String message) {
        for (String contentId : contentIdList) {
            PushVideoUtil.writePushLogInfo((Long)Long.parseLong(contentId), null, (int)pushStatus, (String)message, (String)"VOD", (Long)interfaceId, (int)1);
        }
    }

    private static ResultInfo builderResultInfo(String errorMessage) {
        ResultInfo resultInfo = new ResultInfo();
        if (StringUtils.isBlank((CharSequence)errorMessage)) {
            resultInfo.setStatus(Integer.valueOf(1));
            resultInfo.setMessage("\u5df2\u5411MPC\u4e0b\u8fbe\u56de\u8fc1\u4efb\u52a1\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85!");
        } else {
            resultInfo.setStatus(Integer.valueOf(0));
            resultInfo.setMessage(errorMessage);
        }
        return resultInfo;
    }

    private static DataTable getVideoBackUrl(Long interfaceId) {
        String interfaceSql = "select partnerKey,url from scms_interfaces_manage WHERE id='" + interfaceId + "' and status='1'";
        DataTable dataTable = new QueryBuilder(interfaceSql).executeDataTable();
        if (dataTable == null || dataTable.getRowCount() == 0) {
            return null;
        }
        String url = dataTable.getString(0, "url");
        if (StringUtils.isBlank((CharSequence)url)) {
            log.error("\u89c6\u9891\u56de\u8fc1\u672a\u914d\u7f6e\u63a5\u53e3\u5730\u5740,interfaceId:{}", (Object)interfaceId);
            return null;
        }
        String policyId = VideoBackService.getValueByKey((DataTable)dataTable, (String)"policyId");
        if (StringUtils.isBlank((CharSequence)policyId)) {
            log.error("\u89c6\u9891\u56de\u8fc1\u672a\u914d\u7f6e\u7b56\u7565id,interfaceId:{}", (Object)interfaceId);
            return null;
        }
        String videoBackUrl = VideoBackService.getValueByKey((DataTable)dataTable, (String)"videoBackUrl");
        if (StringUtils.isBlank((CharSequence)videoBackUrl)) {
            log.error("\u89c6\u9891\u56de\u8fc1\u672a\u914d\u7f6e\u56de\u8c03\u5730\u5740,interfaceId:{}", (Object)interfaceId);
            return null;
        }
        return dataTable;
    }

    private static MoveBackToMLVO builderMoveBackToMLVO(Long siteId, SCMS_ContentinfoSchema scmsContentinfoSchema, String path, Long contentInfoLogId, DataTable dataTable) {
        String policyId = VideoBackService.getValueByKey((DataTable)dataTable, (String)"policyId");
        String videoBackUrl = VideoBackService.getValueByKey((DataTable)dataTable, (String)"videoBackUrl");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String currentData = simpleDateFormat.format(new Date());
        MoveBackToMLVO moveBackToMLVO = new MoveBackToMLVO();
        moveBackToMLVO.setRequestId(scmsContentinfoSchema.getContentSourceId());
        moveBackToMLVO.setRequestTime(currentData);
        moveBackToMLVO.setTaskGUID(scmsContentinfoSchema.getContentSourceId());
        moveBackToMLVO.setTaskName(StringsUtil.esSpecialNumeric((String)scmsContentinfoSchema.getTitle()));
        moveBackToMLVO.setPutinTime(currentData);
        moveBackToMLVO.setGroupType("srcGroupType");
        moveBackToMLVO.setMediaType("srcMediaType");
        moveBackToMLVO.setFileName(path);
        moveBackToMLVO.setPolicyID(policyId);
        moveBackToMLVO.setResponseUrl(videoBackUrl);
        moveBackToMLVO.setSiteid(siteId.toString());
        moveBackToMLVO.setContentInfoLogID(contentInfoLogId.toString());
        moveBackToMLVO.setProgramLength(scmsContentinfoSchema.getProgramLength());
        moveBackToMLVO.setCreateName(scmsContentinfoSchema.getCreatorName());
        moveBackToMLVO.setCreateTime(simpleDateFormat.format(scmsContentinfoSchema.getCreateTime()));
        moveBackToMLVO.setKeywords(scmsContentinfoSchema.getTag());
        String sourceType = ContentUtil.getSourceNameByMediaFrom((int)scmsContentinfoSchema.getSourceSystemID());
        moveBackToMLVO.setSourceType(sourceType);
        moveBackToMLVO.setDescription(scmsContentinfoSchema.getDescription());
        return moveBackToMLVO;
    }

    private static String getValueByKey(DataTable dataTable, String key) {
        String policyId = null;
        JSONObject jsonObject = JSONObject.parseObject((String)dataTable.getString(0, "partnerKey"));
        if (jsonObject != null) {
            policyId = jsonObject.getString(key);
        }
        return policyId;
    }

    private static SCMS_ContentinfoSchema getScmsContentinfoSchema(String contentId) {
        SCMS_ContentinfoSchema contentInfoSchema = new SCMS_ContentinfoSchema();
        contentInfoSchema.setContentID(contentId);
        contentInfoSchema.fill();
        return contentInfoSchema;
    }

    private static SCMS_ContentInfoLogSchema builderScmsContentInfoLogSchema(String contentId, Long contentInfoLogId) {
        String realName = User.getCurrentRealName();
        SCMS_ContentInfoLogSchema scmsContentInfoLogSchema = new SCMS_ContentInfoLogSchema();
        scmsContentInfoLogSchema.setID(contentInfoLogId.longValue());
        scmsContentInfoLogSchema.setAction("MOVEMENTS");
        scmsContentInfoLogSchema.setContentId(contentId);
        scmsContentInfoLogSchema.setActionDetail("\u5df2\u5411MPC\u4e0b\u8fbe\u56de\u8fc1\u4efb\u52a1\uff01");
        scmsContentInfoLogSchema.setAddTime(new Date());
        scmsContentInfoLogSchema.setAddUser(realName);
        return scmsContentInfoLogSchema;
    }
}

