/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.business.statistics.impl;

import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.vms.business.statistics.StorageStatistics;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_Stat_videofilesizeSchema;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageStatisticsImpl
implements StorageStatistics {
    private static final Logger log = LoggerFactory.getLogger(DefaultStorageStatisticsImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statistics(Long siteId, Set<String> storagePathSet) {
        log.info("\u5f00\u59cb\u7edf\u8ba1\u5b58\u50a8\u7a7a\u95f4\u4f7f\u7528\u60c5\u51b5\u3002\u7edf\u8ba1\u5b58\u50a8\u7684siteId:{},\u7edf\u8ba1\u5b58\u50a8\u7684\u6587\u4ef6\u8def\u5f84:{}", (Object)siteId, storagePathSet);
        boolean isStatistics = this.judgeIsStatistics(siteId);
        if (!isStatistics) {
            return;
        }
        DBConnPool.setDBConnPool((Long)siteId);
        Multimap datePathAndStoragePathMultimap = this.builderDatePathAndStoragePathMultimap(storagePathSet);
        for (String datePath : datePathAndStoragePathMultimap.keys()) {
            Transaction transaction = new Transaction();
            Collection storagePathCollection = datePathAndStoragePathMultimap.get((Object)datePath);
            try {
                String[] dateArray = datePath.split("/");
                String year = dateArray[0];
                String month = dateArray[1];
                String day = dateArray[2];
                long totalFileSize = FileStorageUtil.getAllTotalFileSize((List)Lists.newArrayList((Iterable)storagePathCollection));
                totalFileSize /= 1024L;
                String result = this.queryStatisticsCount(siteId, year, month, day);
                if (!result.equals("0")) {
                    this.addUpdateSql(siteId, year, month, day, totalFileSize, transaction);
                    continue;
                }
                this.addInsertSql(siteId, year, month, day, totalFileSize, transaction);
            }
            catch (Exception e) {
                log.error("\u7edf\u8ba1\u5b58\u50a8\u7a7a\u95f4\u9047\u5230\u5f02\u5e38,siteId:{},storagePathCollection:{}", new Object[]{siteId, storagePathCollection, e});
            }
            finally {
                transaction.commit();
                transaction.clear();
            }
        }
        log.info("\u7ed3\u675f\u7edf\u8ba1\u5b58\u50a8\u7a7a\u95f4\u4f7f\u7528\u60c5\u51b5\u3002\u7edf\u8ba1\u5b58\u50a8\u7684siteId:{},\u7edf\u8ba1\u5b58\u50a8\u7684\u6587\u4ef6\u8def\u5f84:{}", (Object)siteId, storagePathSet);
    }

    private boolean judgeIsStatistics(Long siteId) {
        String statSpaceFlag = Config.getValue((String)"statSpaceFlag");
        if (StringUtils.isNotBlank((CharSequence)statSpaceFlag) && "fasle".equals(statSpaceFlag)) {
            log.info("\u5b58\u50a8\u7edf\u8ba1\u529f\u80fd\u4ee5\u5173\u95ed\uff0c\u4e0d\u9700\u8981\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
            return false;
        }
        if (SiteUtil.isSupportOSSStorage((long)siteId)) {
            log.info("\u652f\u6301oss\u5b58\u50a8\u65f6\uff0c\u4e0d\u9700\u8981\u7edf\u8ba1\u672c\u5730\u5b58\u50a8");
            return false;
        }
        return true;
    }

    private void addInsertSql(Long siteId, String year, String month, String day, long totalFileSize, Transaction transaction) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse(year + "-" + month + "-" + day);
        SCMS_Stat_videofilesizeSchema scmsStatVideofilesizeSchema = new SCMS_Stat_videofilesizeSchema();
        scmsStatVideofilesizeSchema.setYeardimension(year);
        scmsStatVideofilesizeSchema.setMonthdimension(month);
        scmsStatVideofilesizeSchema.setDaydimension(day);
        scmsStatVideofilesizeSchema.setId(Long.valueOf(NoUtil.getMaxID((String)"statVideoFileId")));
        if (!scmsStatVideofilesizeSchema.fill()) {
            scmsStatVideofilesizeSchema.setSiteid(siteId);
            scmsStatVideofilesizeSchema.setDatecolumn(new SimpleDateFormat("yyyy-MM-dd HH:mm:sss").format(date));
            scmsStatVideofilesizeSchema.setDatasize(Long.valueOf(totalFileSize));
            scmsStatVideofilesizeSchema.setDaycolumn((Object)new SimpleDateFormat("yyyy-MM-dd").format(date));
            scmsStatVideofilesizeSchema.setType(Integer.valueOf(1));
            transaction.add((Schema)scmsStatVideofilesizeSchema, 1);
        }
    }

    private Multimap<String, String> builderDatePathAndStoragePathMultimap(Set<String> storageStatisticsPathSet) {
        HashMultimap datePathAndStoragePathMultimap = HashMultimap.create();
        for (String storagePath : storageStatisticsPathSet) {
            int vodIndex = storagePath.lastIndexOf("vod");
            String datePath = null;
            datePath = vodIndex != -1 ? storagePath.substring(vodIndex + 4, vodIndex + 14) : new SimpleDateFormat("yyyy/MM/dd").format(new Date());
            datePathAndStoragePathMultimap.put((Object)datePath, (Object)storagePath);
        }
        return datePathAndStoragePathMultimap;
    }

    private void addUpdateSql(Long siteId, String year, String month, String day, long totalFileSize, Transaction transaction) {
        String sql = "update scms_stat_videofilesize set datasize = ?  where yeardimension = ? and monthdimension = ? and daydimension = ? and siteid = ?";
        QueryBuilder queryBuilderByUpdate = new QueryBuilder();
        queryBuilderByUpdate.setSQL(sql);
        queryBuilderByUpdate.add((Object)String.valueOf(totalFileSize));
        queryBuilderByUpdate.add((Object)year);
        queryBuilderByUpdate.add((Object)month);
        queryBuilderByUpdate.add((Object)day);
        queryBuilderByUpdate.add((Object)siteId);
        transaction.add(queryBuilderByUpdate);
    }

    private String queryStatisticsCount(Long siteId, String year, String month, String day) {
        QueryBuilder queryBuilderByCount = new QueryBuilder("select count(id) from scms_stat_videofilesize where yeardimension = ? and monthdimension = ? and daydimension = ? and siteid = ?");
        queryBuilderByCount.add((Object)year);
        queryBuilderByCount.add((Object)month);
        queryBuilderByCount.add((Object)day);
        queryBuilderByCount.add((Object)siteId);
        return queryBuilderByCount.executeString();
    }
}

