/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.datasource.listener;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.datasource.properties.DataSourceProperties;
import com.chinamcloud.vms.datasource.util.DataSourceUtil;
import com.sobey.bsp.framework.data.DBConnConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class InitDataSource
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(InitDataSource.class);
    private static Map<String, DruidDataSource> poolNameAndDruidDataSourceMap = new ConcurrentHashMap();
    private static Map<String, DBConnConfig> poolNameAndDBConnConfigMap = new ConcurrentHashMap();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        log.info("*** DruidDataSource init begin ***");
        try {
            List dbConnConfigList = DataSourceProperties.getInstance().getDbConnConfigList();
            this.initPoolNameAndDruidDataSourceMap(dbConnConfigList);
            this.initPoolNameAndDBConnConfigMap(dbConnConfigList);
            log.info("*** DruidDataSource init end ***");
        }
        catch (IOException e) {
            log.error("DruidDataSource init error", (Throwable)e);
        }
        catch (Exception e) {
            log.error("DruidDataSource init error", (Throwable)e);
        }
    }

    private void initPoolNameAndDBConnConfigMap(List<DBConnConfig> dbConnConfigList) {
        for (DBConnConfig dbConnConfig : dbConnConfigList) {
            poolNameAndDBConnConfigMap.put(dbConnConfig.getPoolName(), dbConnConfig);
        }
    }

    private void initPoolNameAndDruidDataSourceMap(List<DBConnConfig> dbConnConfigList) throws Exception {
        String rootPath = InitDataSource.class.getClassLoader().getResource("").getPath();
        String configPath = "config/druid.properties";
        Properties properties = new Properties();
        properties.load(new FileInputStream(new File(PathUtil.builderPath((String[])new String[]{rootPath, configPath}))));
        for (DBConnConfig dbConnConfig : dbConnConfigList) {
            String poolName = dbConnConfig.getPoolName();
            DruidDataSource druidDataSource = InitDataSource.buildDruidDataSource((Properties)properties, (DBConnConfig)dbConnConfig);
            log.info("\u5e94\u7528\u542f\u52a8\u521d\u59cb\u5316\u6570\u636e\u6e90---\u8fde\u63a5\u6c60{},druidDataSource:{}", (Object)poolName, (Object)druidDataSource);
            poolNameAndDruidDataSourceMap.put(poolName, druidDataSource);
        }
    }

    private static DruidDataSource buildDruidDataSource(Properties properties, DBConnConfig dbConnConfig) throws Exception {
        String jdbcUrl = DataSourceUtil.buildJDBCUrl((DBConnConfig)dbConnConfig);
        properties.setProperty("url", jdbcUrl);
        properties.setProperty("username", dbConnConfig.getDBUserName());
        properties.setProperty("password", dbConnConfig.getDBPassword());
        Integer maxConnCount = dbConnConfig.getMaxConnCount();
        maxConnCount = maxConnCount > 10 ? 10 : maxConnCount;
        properties.setProperty("maxActive", maxConnCount.toString());
        properties.setProperty("initialSize", "5");
        return (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)properties);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        for (Map.Entry poolNameAndDruidDataSourceEntry : poolNameAndDruidDataSourceMap.entrySet()) {
            DruidDataSource druidDataSource = (DruidDataSource)poolNameAndDruidDataSourceEntry.getValue();
            druidDataSource.close();
            log.info("\u5e94\u7528\u5173\u95ed\u9500\u6bc1\u5168\u90e8\u6570\u636e\u6e90---\u6570\u636e\u6e90:{}\u9500\u6bc1\uff0c\u6267\u884c\u5173\u95ed\u64cd\u4f5c", poolNameAndDruidDataSourceEntry.getKey());
        }
    }

    public static DBConnConfig getDBConnConfigByPoolName(String poolName) {
        poolName = InitDataSource.checkoutPoolName((String)poolName);
        return (DBConnConfig)poolNameAndDBConnConfigMap.get(poolName);
    }

    public static DruidPooledConnection getDruidPooledConnectionByPoolName(String poolName) {
        try {
            poolName = InitDataSource.checkoutPoolName((String)poolName);
            return ((DruidDataSource)poolNameAndDruidDataSourceMap.get(poolName)).getConnection();
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6" + poolName + "\u7684\u8fde\u63a5\u9047\u5230\u5f02\u5e38", (Throwable)e);
            log.info("\u83b7\u53d6" + poolName + "\u7684\u8fde\u63a5\u9047\u5230\u5f02\u5e38\u65f6\uff0c\u5f53\u524d\u6570\u636e\u6e90\u4fe1\u606f:druidDataSource\uff1a{}", (Object)poolName, poolNameAndDruidDataSourceMap.get(poolName));
            try {
                log.info("\u83b7\u53d6\u8fde\u63a5\u9047\u5230\u5f02\u5e38\uff0c\u91cd\u65b0\u83b7\u53d6\u4e00\u6b21");
                return ((DruidDataSource)poolNameAndDruidDataSourceMap.get(poolName)).getConnection();
            }
            catch (SQLException e2) {
                log.error("\u7b2c\u4e8c\u6b21\u83b7\u53d6" + poolName + "\u7684\u8fde\u63a5\u9047\u5230\u5f02\u5e38", (Throwable)e2);
                log.info("\u7b2c\u4e8c\u6b21\u83b7\u53d6" + poolName + "\u7684\u8fde\u63a5\u9047\u5230\u5f02\u5e38\u65f6\uff0c\u5f53\u524d\u6570\u636e\u6e90\u4fe1\u606f:druidDataSource\uff1a{}", (Object)poolName, poolNameAndDruidDataSourceMap.get(poolName));
                throw new RuntimeException(e2);
            }
        }
    }

    private static String checkoutPoolName(String poolName) {
        if (StringUtils.isBlank((String)poolName)) {
            poolName = "Default";
        }
        return poolName;
    }

    public static boolean isExistDruidDataSourceByPoolName(String poolName) {
        return poolNameAndDruidDataSourceMap.containsKey(poolName);
    }

    public static Map<String, DruidDataSource> getPoolNameAndDruidDataSourceMap() {
        return poolNameAndDruidDataSourceMap;
    }

    public static synchronized void addDruidDataSourceByDBConnConfigIfRequired(DBConnConfig dbConnConfig) {
        String poolName = dbConnConfig.getPoolName();
        if (!poolNameAndDruidDataSourceMap.containsKey(poolName)) {
            log.info("\u5f00\u59cb---\u6dfb\u52a0\u6570\u636e\u6e90\uff1a{}", (Object)dbConnConfig);
            String rootPath = InitDataSource.class.getClassLoader().getResource("").getPath();
            String configPath = "config/druid.properties";
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(new File(PathUtil.builderPath((String[])new String[]{rootPath, configPath}))));
                DruidDataSource druidDataSource = InitDataSource.buildDruidDataSource((Properties)properties, (DBConnConfig)dbConnConfig);
                poolNameAndDBConnConfigMap.put(poolName, dbConnConfig);
                poolNameAndDruidDataSourceMap.put(poolName, druidDataSource);
                log.info("\u7ed3\u675f---\u6dfb\u52a0\u6570\u636e\u6e90\uff1a{}", (Object)dbConnConfig);
            }
            catch (IOException e) {
                log.error("\u6dfb\u52a0\u6570\u636e\u6e90\u9047\u5230\u5f02\u5e38:" + dbConnConfig, (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u6570\u636e\u6e90\u9047\u5230\u5f02\u5e38:" + dbConnConfig, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

