/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.datasource.properties;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.datasource.properties.DataSourceProperties;
import com.google.common.collect.Lists;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.security.EncryptUtil;
import java.io.File;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataSourceProperties {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProperties.class);
    private List<DBConnConfig> dbConnConfigList;

    public List<DBConnConfig> getDbConnConfigList() {
        return this.dbConnConfigList;
    }

    public static final DataSourceProperties getInstance() {
        return DataSourceConfigHolder.access$100();
    }

    private DataSourceProperties() {
        this.initialization();
    }

    private void initialization() {
        log.info("*** DataSourceProperties init begin ***");
        try {
            String rootPath = DataSourceProperties.class.getClassLoader().getResource("").getPath();
            String dataConfigPath = "framework.xml";
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read(new File(PathUtil.builderPath((String[])new String[]{rootPath, dataConfigPath})));
            Element databasesElement = (Element)document.selectSingleNode("/framework/databases");
            List databasesElementList = databasesElement.elements();
            this.dbConnConfigList = Lists.newArrayList();
            for (Element element : databasesElementList) {
                DBConnConfig dbConnConfig = DataSourceProperties.buildDbConnConfig((Element)element);
                this.dbConnConfigList.add(dbConnConfig);
            }
            log.info("*** DataSourceProperties init end ***");
        }
        catch (DocumentException e) {
            log.error("DataSourceProperties init error", (Throwable)e);
        }
    }

    private static DBConnConfig buildDbConnConfig(Element element) {
        DBConnConfig dbConnConfig = new DBConnConfig();
        String databaseName = element.attribute("name").getValue();
        dbConnConfig.setPoolName(databaseName);
        List singleDatabaseElement = element.elements();
        for (Element configSubElement : singleDatabaseElement) {
            String configName = configSubElement.attribute("name").getValue();
            String configValue = configSubElement.getText().trim();
            if ("Type".equals(configName)) {
                dbConnConfig.setDBType(configValue);
                continue;
            }
            if ("ServerAddress".equals(configName)) {
                dbConnConfig.setDBServerAddress(configValue);
                continue;
            }
            if ("Name".equals(configName)) {
                dbConnConfig.setDBName(configValue);
                continue;
            }
            if ("Port".equals(configName)) {
                dbConnConfig.setDBPort(Integer.parseInt(configValue));
                continue;
            }
            if ("UserName".equals(configName)) {
                dbConnConfig.setDBUserName(configValue);
                continue;
            }
            if ("Password".equals(configName)) {
                if (configValue.startsWith("$KEY")) {
                    configValue = EncryptUtil.decrypt3DES((String)configValue.substring(4), (String)"27jrWz3sxrVbR+pnyg6j");
                }
                dbConnConfig.setDBPassword(configValue);
                continue;
            }
            if ("MaxConnCount".equals(configName)) {
                int maxConnCount = Integer.parseInt(configValue);
                dbConnConfig.setMaxConnCount(Integer.valueOf(maxConnCount > 200 ? 200 : maxConnCount));
                continue;
            }
            if (!"InitConnCount".equals(configName)) continue;
            int initConnCount = Integer.parseInt(configValue);
            dbConnConfig.setInitConnCount(Integer.valueOf(initConnCount < 5 ? 5 : initConnCount));
        }
        return dbConnConfig;
    }
}

