/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.datasource.util;

import com.sobey.bsp.framework.data.DBConnConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataSourceUtil {
    public static String buildJDBCUrl(DBConnConfig dbConnConfig) {
        if (dbConnConfig.DBType.trim().toUpperCase().equals("ORACLE")) {
            return DataSourceUtil.buildJDBCByORACLE((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("INFORMIX")) {
            return DataSourceUtil.buildByINFORMIX((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("MSSQL")) {
            return DataSourceUtil.buildByMSSQL((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("MSSQL2000")) {
            return DataSourceUtil.buildByMSSQL2000((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("DB2")) {
            return DataSourceUtil.buildByDB2((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("SYBASE")) {
            return DataSourceUtil.buildBySYBASE((DBConnConfig)dbConnConfig);
        }
        if (dbConnConfig.DBType.trim().toUpperCase().equals("MYSQL")) {
            return DataSourceUtil.buildByMYSQL((DBConnConfig)dbConnConfig);
        }
        return null;
    }

    private static String buildByMYSQL(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:mysql://");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append("/");
        stringBuffer.append(dbConnConfig.DBName);
        stringBuffer.append("?useUnicode=true&characterEncoding=utf8");
        return stringBuffer.toString();
    }

    private static String buildBySYBASE(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:sybase:Tds:");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append("/");
        stringBuffer.append(dbConnConfig.DBName);
        return stringBuffer.toString();
    }

    private static String buildByDB2(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:db2://");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append("/");
        stringBuffer.append(dbConnConfig.DBName);
        return stringBuffer.toString();
    }

    private static String buildByMSSQL2000(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:jtds:sqlserver://");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append(";DatabaseName=");
        stringBuffer.append(dbConnConfig.DBName);
        stringBuffer.append(";useLOBs=false");
        return stringBuffer.toString();
    }

    private static String buildByMSSQL(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:sqlserver://");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append(";DatabaseName=");
        stringBuffer.append(dbConnConfig.DBName);
        return stringBuffer.toString();
    }

    private static String buildByINFORMIX(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:informix-sqli://");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append(dbConnConfig.DBName);
        stringBuffer.append(":");
        stringBuffer.append("informixserver=");
        stringBuffer.append(dbConnConfig.DBName);
        stringBuffer.append(";");
        stringBuffer.append("user=");
        stringBuffer.append(dbConnConfig.DBUserName);
        stringBuffer.append(";");
        stringBuffer.append("dcc.DBPassword=");
        stringBuffer.append(dbConnConfig.DBPassword);
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    private static String buildJDBCByORACLE(DBConnConfig dbConnConfig) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:oracle:thin:@");
        stringBuffer.append(dbConnConfig.DBServerAddress);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBPort);
        stringBuffer.append(":");
        stringBuffer.append(dbConnConfig.DBName);
        return stringBuffer.toString();
    }
}

