/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.datasource.util;

import com.google.common.collect.Maps;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.orm.SchemaColumn;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrintSqlUtil {
    private static final Logger log = LoggerFactory.getLogger(PrintSqlUtil.class);

    public static String buildPrintCommonSql(String initSql, Schema[] schemaArray) {
        try {
            return PrintSqlUtil.generateActualSqlByInsert((String)initSql, (Schema[])schemaArray);
        }
        catch (Exception e) {
            log.warn("\u7ec4\u88c5\u6253\u5370sql\u9047\u5230\u5f02\u5e38,\u4e0d\u5f71\u54cd\u5b9e\u9645\u4e1a\u52a1", (Throwable)e);
            return null;
        }
    }

    public static String buildPrintCommonSql(String initSql, Schema[] schemaArray, SchemaColumn[] schemaColumnArray) {
        try {
            return PrintSqlUtil.generateActualSql((String)initSql, (Schema[])schemaArray, (SchemaColumn[])schemaColumnArray);
        }
        catch (Exception e) {
            log.warn("\u7ec4\u88c5\u6253\u5370sql\u9047\u5230\u5f02\u5e38,\u4e0d\u5f71\u54cd\u5b9e\u9645\u4e1a\u52a1", (Throwable)e);
            return null;
        }
    }

    private static String generateActualSql(String initSql, Schema[] schemaArray, SchemaColumn[] schemaColumnArray) {
        Map columnNameAndIndexMap = PrintSqlUtil.buildColumnNameAndIndexMap((SchemaColumn[])schemaColumnArray);
        String[] partArray = initSql.split("\\?");
        String patternString = "\\w+\\p{Space}*=";
        Pattern pattern = Pattern.compile(patternString);
        StringBuilder stringBuilder = new StringBuilder();
        for (Schema schema : schemaArray) {
            if (initSql.contains("?")) {
                for (String part : partArray) {
                    stringBuilder.append(part);
                    Matcher matcher = pattern.matcher(part);
                    while (matcher.find()) {
                        String columnName = matcher.group().replace("=", "").trim();
                        Integer integer = (Integer)columnNameAndIndexMap.get(columnName);
                        String columnValue = PrintSqlUtil.formatParameter((Object)schema.getV(integer.intValue()));
                        stringBuilder.append(columnValue);
                    }
                    matcher.reset();
                }
            } else {
                stringBuilder.append(initSql);
            }
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    private static Map<String, Integer> buildColumnNameAndIndexMap(SchemaColumn[] schemaColumnArray) {
        HashMap columnNameAndIndexMap = Maps.newHashMap();
        int i = 0;
        for (SchemaColumn schemaColumn : schemaColumnArray) {
            columnNameAndIndexMap.put(schemaColumn.getColumnName(), i++);
        }
        return columnNameAndIndexMap;
    }

    private static String generateActualSqlByInsert(String initSql, Schema[] schemaArray) {
        String[] parts = initSql.split("\\?");
        StringBuilder sqlStringBuilder = new StringBuilder();
        int length = parts.length;
        for (Schema schema : schemaArray) {
            for (int i = 0; i < length; ++i) {
                String part = parts[i];
                sqlStringBuilder.append(part);
                if (i == length - 1) continue;
                sqlStringBuilder.append(PrintSqlUtil.formatParameter((Object)schema.getV(i)));
            }
            sqlStringBuilder.append(";");
        }
        return sqlStringBuilder.toString();
    }

    private static String formatParameter(Object parameter) {
        if (parameter == null) {
            return "NULL";
        }
        if (parameter instanceof String) {
            return "'" + ((String)parameter).replace("'", "''") + "'";
        }
        if (parameter instanceof Date) {
            return "'" + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(parameter) + "'";
        }
        return parameter.toString();
    }

    public static String buildPrintCommonSql(QueryBuilder queryBuilder) {
        try {
            String sql = queryBuilder.getSQL();
            if (!sql.contains("?")) {
                return sql;
            }
            ArrayList params = queryBuilder.getParams();
            StringBuilder stringBuilder = new StringBuilder();
            String[] partArray = sql.split("\\?");
            for (int i = 0; i < partArray.length; ++i) {
                String part = partArray[i];
                stringBuilder.append(part);
                stringBuilder.append(params.get(i));
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            log.warn("\u7ec4\u88c5\u6253\u5370sql\u9047\u5230\u5f02\u5e38,\u4e0d\u5f71\u54cd\u5b9e\u9645\u4e1a\u52a1", (Throwable)e);
            return null;
        }
    }

    public static String buildPrintCommonSql(QueryBuilder queryBuilder, int pageIndex, int pageSize) {
        String sql = PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder);
        return sql + " limit " + pageIndex * pageSize + "," + pageSize;
    }

    public static String buildPrintCommonSql(QueryBuilder queryBuilder, int pageIndex, int pageSize, int offest) {
        String sql = PrintSqlUtil.buildPrintCommonSql((QueryBuilder)queryBuilder);
        return sql + " limit " + (pageIndex * pageSize + offest) + "," + pageSize;
    }
}

