/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.vms.task;

import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.vms.business.statistics.impl.DefaultStorageStatisticsImpl;
import com.chinamcloud.vms.config.ApplicationProperties;
import com.google.common.collect.Sets;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import java.util.HashSet;
import java.util.Set;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageStatisticsTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StorageStatisticsTask.class);

    @Override
    public void run() {
        log.info("\u5f00\u59cb\u5b58\u50a8\u7edf\u8ba1\u7684\u5b9a\u65f6\u4efb\u52a1");
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        QueryBuilder queryBuilder = new QueryBuilder("select id from scms_account where status = 1");
        DataTable dataTable = queryBuilder.executeDataTable();
        if (dataTable.getRowCount() <= 0) {
            log.info("\u6ca1\u6709\u6b63\u5e38\u4f7f\u7528\u7684\u7ad9\u70b9\uff0c\u7ed3\u675f\u5b58\u50a8\u7edf\u8ba1\u4efb\u52a1");
            return;
        }
        String linuxVideoDir = Config.getValue((String)"linuxVideoDir");
        DateTime dateTime = new DateTime();
        String today = dateTime.toString("yyyy/MM/dd");
        String yesterday = dateTime.minusMinutes(2 * ApplicationProperties.getInstance().getStorageStatisticsTaskPeriod()).toString("yyyy/MM/dd");
        DefaultStorageStatisticsImpl storageStatistics = new DefaultStorageStatisticsImpl();
        for (int i = 0; i < dataTable.getRowCount(); ++i) {
            long siteId = dataTable.getLong(i, "id");
            DBConnPool.setDBConnPool((Long)siteId);
            String alias = SiteUtil.getAlias((long)siteId);
            HashSet storageStatisticsPathList = Sets.newHashSet((Object[])new String[]{PathUtil.builderPath((String[])new String[]{linuxVideoDir, alias, "vod", today}), PathUtil.builderPath((String[])new String[]{linuxVideoDir, alias, "vod", yesterday})});
            storageStatistics.statistics(Long.valueOf(siteId), (Set)storageStatisticsPathList);
        }
        log.info("\u7ed3\u675f\u5b58\u50a8\u7edf\u8ba1\u7684\u5b9a\u65f6\u4efb\u52a1");
    }
}

