/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.pub;

import com.sobey.bsp.cms.dataservice.ColumnUtil;
import com.sobey.bsp.cms.pub.PubFun;
import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.schema.SCMS_CatalogSchema;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class CatalogUtil {
    private static int CACHESIZE = 1000;
    private static Mapx ID_NameMap = new Mapx(CACHESIZE);
    private static Mapx ID_AliasMap = new Mapx(CACHESIZE);
    private static Mapx ID_ParentMap = new Mapx(CACHESIZE);
    private static Mapx ID_SiteIDMap = new Mapx(CACHESIZE);
    private static Mapx ID_InnerCodeMap = new Mapx(CACHESIZE);
    private static Mapx ID_CatalogTypeMap = new Mapx(CACHESIZE);
    private static Mapx ID_GoodsTypeIDMap = new Mapx(CACHESIZE);
    private static Mapx ID_ChildCountMap = new Mapx(CACHESIZE);
    private static Mapx ID_TreeLevelMap = new Mapx(CACHESIZE);
    private static Mapx InnerCode_NameMap = new Mapx(CACHESIZE);
    private static Mapx InnerCode_IDMap = new Mapx(CACHESIZE);
    private static Mapx InnerCode_SiteIDMap = new Mapx(CACHESIZE);
    private static Mapx Alias_IDMap = new Mapx(CACHESIZE);
    private static Mapx Names_IDMap = new Mapx(CACHESIZE);
    private static Mapx ID_TemplateRuleMap = new Mapx(CACHESIZE);
    private static Mapx ID_SingleFlagMap = new Mapx(CACHESIZE);
    private static Mapx ID_WorkflowMap = new Mapx(CACHESIZE);
    private static Mapx ID_PathMap = new Mapx(CACHESIZE);
    private static Mapx ID_IDPathMap = new Mapx(CACHESIZE);
    private static Mapx ID_AllowStatusMap = new Mapx(CACHESIZE);
    private static Mapx ID_ArchiveTimeMap = new Mapx(CACHESIZE);
    private static Mapx ID_HotWordFlagMap = new Mapx(CACHESIZE);
    private static Mapx ID_AttachDownFlagMap = new Mapx(CACHESIZE);
    private static Mapx ID_OrderFlagMap = new Mapx(CACHESIZE);

    public static String getName(String catalogID) {
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogID);
        catalog.fill();
        return catalog.getName();
    }

    public static String getName(long catalogID) {
        return CatalogUtil.getName((String)String.valueOf(catalogID));
    }

    public static String getParentName(long catalogID) {
        String names = "";
        String name = CatalogUtil.getName((long)catalogID);
        if (name.length() > 7) {
            name = name.substring(0, 6) + "...";
        }
        ArrayList<String> parents = new ArrayList<String>();
        long parentId = 1L;
        while (parentId != 0L) {
            parentId = Long.valueOf(CatalogUtil.getParentID((long)catalogID));
            if (parentId == 0L) continue;
            SCMS_CatalogSchema cat = new SCMS_CatalogSchema();
            cat.setID(parentId);
            cat.fill();
            String pname = cat.getName();
            if (pname.length() > 7) {
                pname = pname.substring(0, 6) + "...";
            }
            parents.add(pname);
            catalogID = parentId;
        }
        if (parents.size() != 0) {
            for (int i = parents.size() - 1; i >= 0; --i) {
                names = names + (String)parents.get(i) + "--";
            }
        }
        if ((names = names + name).length() > 30) {
            names = names.substring(0, names.indexOf("--")) + names.substring(names.lastIndexOf("--"));
        }
        return names;
    }

    public static String getInnerCode(long catalogID) {
        return CatalogUtil.getInnerCode((String)String.valueOf(catalogID));
    }

    public static String getInnerCode(String catalogID) {
        if (StringUtil.isEmpty((String)catalogID)) {
            return null;
        }
        String innerCode = ID_InnerCodeMap.getString((Object)catalogID);
        if (innerCode == null) {
            CatalogUtil.update((String)catalogID);
            innerCode = ID_InnerCodeMap.getString((Object)catalogID);
        }
        return innerCode;
    }

    public static String getSiteID(long catalogID) {
        return CatalogUtil.getSiteID((String)String.valueOf(catalogID));
    }

    public static String getSiteID(String catalogID) {
        if (StringUtil.isEmpty((String)catalogID)) {
            return null;
        }
        String siteID = ID_SiteIDMap.getString((Object)catalogID);
        if (siteID == null) {
            CatalogUtil.update((String)catalogID);
            siteID = ID_SiteIDMap.getString((Object)catalogID);
        }
        return siteID;
    }

    public static String getAlias(long catalogID) {
        return CatalogUtil.getAlias((String)String.valueOf(catalogID));
    }

    public static String getAlias(String catalogID) {
        String alias = ID_AliasMap.getString((Object)catalogID);
        if (alias == null) {
            CatalogUtil.update((String)catalogID);
            alias = ID_AliasMap.getString((Object)catalogID);
        }
        return alias.toLowerCase();
    }

    public static String getIDByAlias(String alias) {
        String ID = Alias_IDMap.getString((Object)alias);
        if (ID == null) {
            String catalogID = new QueryBuilder("select ID from SCMS_Catalog where alias=?", (Object)alias).executeString();
            CatalogUtil.update((String)catalogID);
            ID = Alias_IDMap.getString((Object)alias);
        }
        return ID;
    }

    public static String getGoodsTypeID(long catalogID) {
        return CatalogUtil.getGoodsTypeID((String)String.valueOf(catalogID));
    }

    public static String getGoodsTypeID(String catalogID) {
        String goodsTypeID = ID_GoodsTypeIDMap.getString((Object)catalogID);
        if (goodsTypeID == null) {
            CatalogUtil.update((String)catalogID);
            goodsTypeID = ID_GoodsTypeIDMap.getString((Object)catalogID);
        }
        return goodsTypeID;
    }

    public static String getParentID(long catalogID) {
        return CatalogUtil.getParentID((String)String.valueOf(catalogID));
    }

    public static String getParentID(String catalogID) {
        String parentID = ID_ParentMap.getString((Object)catalogID);
        if (parentID == null) {
            CatalogUtil.update((String)catalogID);
            parentID = ID_ParentMap.getString((Object)catalogID);
        }
        return parentID;
    }

    public static String getChildCount(long catalogID) {
        return CatalogUtil.getChildCount((String)String.valueOf(catalogID));
    }

    public static String getChildCount(String catalogID) {
        String childCount = ID_ChildCountMap.getString((Object)catalogID);
        if (childCount == null) {
            CatalogUtil.update((String)catalogID);
            childCount = ID_ChildCountMap.getString((Object)catalogID);
        }
        return childCount;
    }

    public static DataTable getCatalogOptions(long type) {
        DataTable dt = new QueryBuilder("select Name,ID,TreeLevel,ParentID from SCMS_Catalog where SiteID = ? and Type = ? order by ID", Application.getCurrentSiteID(), type).executeDataTable();
        PubFun.indentDataTable((DataTable)dt, (int)0, (int)2, (int)0);
        return dt;
    }

    public static DataTable getList(int type) {
        return CatalogUtil.getList((int)type, (int)1);
    }

    public static DataTable getList(int type, int firstLevel) {
        String sql = "select Name,ID ,Level from SCMS_Catalog where Type=? and siteID =? order by InnerCode";
        DataTable dt = new QueryBuilder(sql, (long)type, Application.getCurrentSiteID()).executeDataTable();
        PubFun.indentDataTable((DataTable)dt, (int)0, (int)2, (int)firstLevel);
        return dt;
    }

    public static String getWorkflow(long catalogID) {
        return CatalogUtil.getWorkflow((String)String.valueOf(catalogID));
    }

    public static String getWorkflow(String catalogID) {
        String workflow = ID_WorkflowMap.getString((Object)catalogID);
        if (workflow == null) {
            CatalogUtil.update((String)catalogID);
            workflow = ID_WorkflowMap.getString((Object)catalogID);
        }
        return workflow;
    }

    public static String getAllowStatus(long catalogID) {
        return CatalogUtil.getAllowStatus((String)String.valueOf(catalogID));
    }

    public static String getAllowStatus(String catalogID) {
        String allowStatus = ID_AllowStatusMap.getString((Object)catalogID);
        if (allowStatus == null) {
            CatalogUtil.update((String)catalogID);
            allowStatus = ID_AllowStatusMap.getString((Object)catalogID);
        }
        return allowStatus;
    }

    public static String getAttachDownFlag(long catalogID) {
        return CatalogUtil.getAttachDownFlag((String)String.valueOf(catalogID));
    }

    public static String getAttachDownFlag(String catalogID) {
        String attachDownFlag = ID_AttachDownFlagMap.getString((Object)catalogID);
        if (StringUtil.isEmpty((String)attachDownFlag)) {
            CatalogUtil.update((String)catalogID);
            attachDownFlag = ID_AttachDownFlagMap.getString((Object)catalogID);
        }
        return attachDownFlag;
    }

    public static String getArchiveTime(long catalogID) {
        return CatalogUtil.getArchiveTime((String)String.valueOf(catalogID));
    }

    public static String getArchiveTime(String catalogID) {
        String archiveTime = ID_ArchiveTimeMap.getString((Object)catalogID);
        if (archiveTime == null) {
            CatalogUtil.update((String)catalogID);
            archiveTime = ID_ArchiveTimeMap.getString((Object)catalogID);
        }
        return archiveTime;
    }

    public static String getTemplateRule(long catalogID) {
        return CatalogUtil.getTemplateRule((String)String.valueOf(catalogID));
    }

    public static String getTemplateRule(String catalogID) {
        String templateRule = ID_TemplateRuleMap.getString((Object)catalogID);
        if (templateRule == null) {
            CatalogUtil.update((String)catalogID);
            templateRule = ID_TemplateRuleMap.getString((Object)catalogID);
        }
        return templateRule;
    }

    public static String getSingleFlag(long catalogID) {
        return CatalogUtil.getSingleFlag((String)String.valueOf(catalogID));
    }

    public static String getSingleFlag(String catalogID) {
        String singleFlag = ID_SingleFlagMap.getString((Object)catalogID);
        if (singleFlag == null) {
            CatalogUtil.update((String)catalogID);
            singleFlag = ID_SingleFlagMap.getString((Object)catalogID);
        }
        return singleFlag;
    }

    public static String getParentCatalogCode(String innerCode) {
        if (innerCode == null) {
            return "";
        }
        Object[] arr = new String[innerCode.length() / 6];
        int i = 0;
        while (innerCode.length() >= 6) {
            arr[i++] = innerCode;
            innerCode = innerCode.substring(0, innerCode.length() - 6);
        }
        return "'" + StringUtil.join((Object[])arr, (String)"','") + "'";
    }

    public static int getTreeLevel(long catalogID) {
        return CatalogUtil.getTreeLevel((String)String.valueOf(catalogID));
    }

    public static int getTreeLevel(String catalogID) {
        String treeLevel = ID_TreeLevelMap.getString((Object)catalogID);
        if (StringUtil.isEmpty((String)treeLevel)) {
            CatalogUtil.update((String)catalogID);
            treeLevel = ID_TreeLevelMap.getString((Object)catalogID);
        }
        return Integer.parseInt(treeLevel);
    }

    public static int getLevel(String innerCode) {
        if (innerCode == null) {
            return 0;
        }
        int codeLength = innerCode.length();
        if (codeLength < 1) {
            return 0;
        }
        return codeLength / 6;
    }

    public static String getLevelStr(long catalogID) {
        return CatalogUtil.getLevelStr((String)String.valueOf(catalogID));
    }

    public static String getLevelStr(String catalogID) {
        String levelString = "";
        String detailTemplateNameRule = CatalogUtil.getTemplateRule((String)catalogID);
        if (StringUtil.isNotEmpty((String)detailTemplateNameRule)) {
            Pattern p = Pattern.compile("\\$\\{CatalogPath\\}", 2);
            Matcher matcher = p.matcher(detailTemplateNameRule);
            int level = 0;
            if (matcher.find()) {
                level = CatalogUtil.getTreeLevel((String)catalogID);
            }
            detailTemplateNameRule = matcher.replaceAll("");
            detailTemplateNameRule = detailTemplateNameRule.replaceAll("///", "/");
            if ((detailTemplateNameRule = detailTemplateNameRule.replaceAll("//", "/")).startsWith("/")) {
                detailTemplateNameRule = detailTemplateNameRule.substring(1);
            }
            level += StringUtil.count((String)detailTemplateNameRule, (String)"/");
            for (int i = 0; i < level; ++i) {
                levelString = levelString + "../";
            }
        }
        return levelString;
    }

    public static String getLevelStr(int level) {
        String levelString = "";
        for (int i = 0; i < level; ++i) {
            levelString = levelString + "../";
        }
        return levelString;
    }

    public static int getPathLevel(String fullPath, int startLevel) {
        int level = 0;
        if (StringUtil.isEmpty((String)fullPath)) {
            return level;
        }
        Pattern p = Pattern.compile("\\$\\{CatalogPath\\}", 2);
        Matcher matcher = p.matcher(fullPath);
        if (!matcher.find()) {
            startLevel = 0;
        }
        fullPath = matcher.replaceAll("");
        fullPath = fullPath.replaceAll("///", "/");
        if ((fullPath = fullPath.replaceAll("//", "/")).startsWith("/")) {
            fullPath = fullPath.substring(1);
        }
        level = StringUtil.count((String)fullPath, (String)"/");
        return level + startLevel;
    }

    private static String updatePath(String catalogID) {
        String path = "";
        String parentID = CatalogUtil.getParentID((String)catalogID);
        if (StringUtil.isEmpty((String)parentID)) {
            return "";
        }
        path = CatalogUtil.getAlias((String)new StringBuffer(String.valueOf(catalogID)).toString()).toLowerCase() + "/";
        if (!"0".equals(parentID)) {
            path = CatalogUtil.updatePath((String)parentID) + path;
        }
        return path;
    }

    private static String getIDPath(String catalogID) {
        String path = "";
        String parentID = CatalogUtil.getParentID((String)catalogID);
        if (StringUtil.isEmpty((String)parentID)) {
            return "";
        }
        path = catalogID + "/";
        if (!"0".equals(parentID)) {
            path = CatalogUtil.getIDPath((String)parentID) + path;
        }
        return path;
    }

    public static DataRow getData(String catalogID) {
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogID);
        if (catalog.fill()) {
            DataRow dr = catalog.toDataRow();
            ColumnUtil.extendCatalogColumnData((DataRow)dr, (long)catalog.getSiteID(), (String)"");
            return dr;
        }
        return null;
    }

    public static String getHotWordFlag(String catalogID) {
        String HotWordFlag = ID_HotWordFlagMap.getString((Object)catalogID);
        if (HotWordFlag == null) {
            CatalogUtil.update((String)catalogID);
            HotWordFlag = ID_HotWordFlagMap.getString((Object)catalogID);
        }
        return HotWordFlag;
    }

    public static void update(long catalogID) {
        CatalogUtil.update((String)String.valueOf(catalogID));
    }

    public static void update(String catalogID) {
        if (StringUtil.isEmpty((String)catalogID)) {
            return;
        }
        ID_NameMap.remove((Object)catalogID);
        ID_AliasMap.remove((Object)catalogID);
        ID_ParentMap.remove((Object)catalogID);
        ID_SiteIDMap.remove((Object)catalogID);
        ID_InnerCodeMap.remove((Object)catalogID);
        ID_CatalogTypeMap.remove((Object)catalogID);
        ID_GoodsTypeIDMap.remove((Object)catalogID);
        ID_ChildCountMap.remove((Object)catalogID);
        ID_TreeLevelMap.remove((Object)catalogID);
        InnerCode_IDMap.remove((Object)catalogID);
        InnerCode_NameMap.remove((Object)catalogID);
        InnerCode_SiteIDMap.remove((Object)catalogID);
        ID_TemplateRuleMap.remove((Object)catalogID);
        ID_WorkflowMap.remove((Object)catalogID);
        Alias_IDMap.remove((Object)catalogID);
        Names_IDMap.remove((Object)catalogID);
        ID_PathMap.remove((Object)catalogID);
        ID_IDPathMap.remove((Object)catalogID);
        ID_SingleFlagMap.remove((Object)catalogID);
        ID_AllowStatusMap.remove((Object)catalogID);
        ID_ArchiveTimeMap.remove((Object)catalogID);
        ID_HotWordFlagMap.remove((Object)catalogID);
        ID_AttachDownFlagMap.remove((Object)catalogID);
        ID_OrderFlagMap.remove((Object)catalogID);
        SCMS_CatalogSchema catalog = new SCMS_CatalogSchema();
        catalog.setID(catalogID);
        if (catalog.fill()) {
            ID_OrderFlagMap.put((Object)catalog.getInnerCode(), catalog.getOrderFlag());
            ID_NameMap.put((Object)catalogID, (Object)catalog.getName());
            ID_AliasMap.put((Object)catalogID, (Object)catalog.getAlias());
            ID_ParentMap.put((Object)catalogID, catalog.getParentID());
            ID_SiteIDMap.put((Object)catalogID, catalog.getSiteID());
            ID_InnerCodeMap.put((Object)catalogID, (Object)catalog.getInnerCode());
            ID_CatalogTypeMap.put((Object)catalogID, catalog.getType());
            ID_GoodsTypeIDMap.put((Object)catalogID, (Object)catalog.getProp4());
            ID_ChildCountMap.put((Object)catalogID, catalog.getChildCount());
            ID_TreeLevelMap.put((Object)catalogID, catalog.getTreeLevel());
            InnerCode_IDMap.put((Object)catalog.getInnerCode(), (Object)catalogID);
            InnerCode_NameMap.put((Object)catalog.getInnerCode(), (Object)catalog.getName());
            InnerCode_SiteIDMap.put((Object)catalog.getInnerCode(), catalog.getSiteID());
            Alias_IDMap.put((Object)catalogID, (Object)catalog.getAlias());
            ID_PathMap.put((Object)catalogID, (Object)CatalogUtil.updatePath((String)catalogID));
            ID_IDPathMap.put((Object)catalogID, (Object)CatalogUtil.getIDPath((String)catalogID));
            ID_SingleFlagMap.put((Object)catalogID, (Object)catalog.getSingleFlag());
            ID_TemplateRuleMap.put((Object)catalogID, (Object)catalog.getDetailNameRule());
            ID_WorkflowMap.put((Object)catalogID, (Object)catalog.getWorkflow());
            if (StringUtil.isEmpty((String)Names_IDMap.getString((Object)catalogID))) {
                Names_IDMap.put((Object)(catalog.getSiteID() + "_" + catalog.getName()), catalog.getID());
            }
            if (StringUtil.isNotEmpty((String)ID_NameMap.getString((Object)String.valueOf(catalog.getParentID()))) && !"0".equalsIgnoreCase(String.valueOf(catalog.getParentID()))) {
                Names_IDMap.put((Object)(catalog.getSiteID() + "_" + ID_NameMap.getString((Object)new StringBuffer(String.valueOf(catalog.getParentID())).toString()) + "_" + catalog.getName()), (Object)catalogID);
                Names_IDMap.put((Object)(catalog.getSiteID() + "_" + catalog.getParentID() + "_" + catalog.getName()), (Object)catalogID);
            }
        }
    }

    public static void clearAll() {
        ID_NameMap.clear();
        ID_AliasMap.clear();
        ID_ParentMap.clear();
        ID_SiteIDMap.clear();
        ID_InnerCodeMap.clear();
        ID_CatalogTypeMap.clear();
        ID_GoodsTypeIDMap.clear();
        ID_ChildCountMap.clear();
        ID_TreeLevelMap.clear();
        InnerCode_NameMap.clear();
        ID_OrderFlagMap.clear();
        InnerCode_IDMap.clear();
        InnerCode_SiteIDMap.clear();
        Alias_IDMap.clear();
        Names_IDMap.clear();
        ID_TemplateRuleMap.clear();
        ID_WorkflowMap.clear();
        ID_PathMap.clear();
        ID_IDPathMap.clear();
        ID_SingleFlagMap.clear();
        ID_AllowStatusMap.clear();
        ID_ArchiveTimeMap.clear();
        ID_HotWordFlagMap.clear();
        ID_AttachDownFlagMap.clear();
    }

    public static String createCatalogInnerCode(String parentCode) {
        if (StringUtil.isNotEmpty((String)parentCode)) {
            return NoUtil.getMaxNo((String)"CatalogInnerCode", (String)parentCode, (int)6);
        }
        return NoUtil.getMaxNo((String)"CatalogInnerCode", (int)6);
    }

    public static boolean isHasChildren(String innerCode) {
        if (!StringUtil.isEmpty((String)innerCode)) {
            DataTable dt = new QueryBuilder("select InnerCode from scms_catalog where InnerCode like '%" + innerCode + "%'").executeDataTable();
            return dt.getRowCount() != 1;
        }
        return false;
    }
}

