/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.site;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.common.storage.util.ThirdStorageFileUtil;
import com.chinamcloud.common.util.FileUtil;
import com.chinamcloud.vms.util.PathCommonUtil;
import com.chinamclound.vms.vo.FilePathVO;
import com.chinamclound.vms.vo.ImageUploadResultVO;
import com.chinamclound.vms.vo.ImageUploadVO;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.SiteConfig;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.schema.SCMS_AudioInfoSchema;
import com.sobey.bsp.schema.SCMS_ContentinfoSchema;
import com.sobey.bsp.schema.SCMS_SeriesSchema;
import com.sobey.cms.util.InterfacesMethod;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageFrameUpload
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ImageFrameUpload.class);

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
            ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
            servletFileUpload.setHeaderEncoding("UTF-8");
            List fileList = servletFileUpload.parseRequest(request);
            Iterator fileItemIterator = fileList.iterator();
            ImageUploadVO imageUploadVo = this.getImageUploadVo(request);
            ResultDTO resultDTO = ImageFrameUpload.uploadImage(fileItemIterator, (ImageUploadVO)imageUploadVo);
            if (resultDTO.isSuccess()) {
                response.getWriter().print(JSON.toJSONString(((List)resultDTO.getData()).get(0)));
            } else {
                response.getWriter().print(resultDTO.getDescription());
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u56fe\u7247\u9047\u5230\u5f02\u5e38", (Throwable)e);
            response.getWriter().print("\u4e0a\u4f20\u56fe\u7247\u9047\u5230\u5f02\u5e38");
        }
    }

    private static ResultDTO<List<ImageUploadResultVO>> uploadImage(Iterator<FileItem> fileItemIterator, ImageUploadVO imageUploadVo) throws Exception {
        log.info("\u56fe\u7247\u4e0a\u4f20\uff1a{}", (Object)JSON.toJSONString((Object)imageUploadVo, (boolean)true));
        FilePathVO filePathVO = imageUploadVo.getFilePathVO();
        ArrayList imageUploadResultVOList = Lists.newArrayList();
        while (fileItemIterator.hasNext()) {
            String uploadFilename;
            FileItem fileItem = fileItemIterator.next();
            if (fileItem.isFormField() || StringUtils.isBlank((String)(uploadFilename = fileItem.getName())) && !uploadFilename.contains(".")) continue;
            String saveFileName = (String)MoreObjects.firstNonNull((Object)filePathVO.getSaveFileName(), (Object)FileUtil.getUUIDFileName((String)uploadFilename));
            File file = null;
            if (filePathVO.isSupportOSS()) {
                file = FileStorageUtil.writeFileItemToLocalFile((String)System.getProperty("java.io.tmpdir"), (String)saveFileName, (FileItem)fileItem);
                ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = FileStorageUtil.builderSimpleThirdStorageFileUploadDTO((String)filePathVO.getOssBucketName(), (String)filePathVO.getThirdStorageParentPath(), (String)saveFileName);
                ResultDTO thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath((ThirdStorageFileUploadDTO)thirdStorageFileUploadDTO, (String)file.getAbsolutePath());
                if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
                    FileStorageUtil.deleteFileByCondition((File)file, (boolean)true);
                    return ResultDTO.fail((String)thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
                }
            } else {
                file = FileStorageUtil.writeFileItemToLocalFile((String)filePathVO.getLocalStorageParentPath(), (String)saveFileName, (FileItem)fileItem);
            }
            ImageUploadResultVO imageUploadResultVO = ImageFrameUpload.builderImageUploadResultVO((ImageUploadVO)imageUploadVo, (String)uploadFilename, (String)saveFileName, (File)file);
            imageUploadResultVOList.add(imageUploadResultVO);
            FileStorageUtil.deleteFileByCondition((File)file, (boolean)filePathVO.isSupportOSS());
        }
        if (CollectionUtils.isEmpty((Collection)imageUploadResultVOList)) {
            log.warn("\u6ca1\u6709\u4e0a\u4f20\u7684\u56fe\u7247");
            return ResultDTO.fail((String)"\u6ca1\u6709\u4e0a\u4f20\u7684\u56fe\u7247");
        }
        log.info("\u56fe\u7247\u4e0a\u4f20\u6210\u529f:{}", (Object)JSON.toJSONString((Object)imageUploadResultVOList, (boolean)true));
        return ResultDTO.successfy((Object)imageUploadResultVOList);
    }

    private static ImageUploadResultVO builderImageUploadResultVO(ImageUploadVO imageUploadVo, String uploadFilename, String saveFileName, File file) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(file);
        Raster raster = bufferedImage.getData();
        Rectangle rectangle = raster.getBounds();
        ImageUploadResultVO imageUploadResultVO = new ImageUploadResultVO();
        imageUploadResultVO.setWidth(rectangle.width);
        imageUploadResultVO.setHeight(rectangle.height);
        imageUploadResultVO.setFileName(uploadFilename);
        imageUploadResultVO.setUrl(PathUtil.builderPath((String[])new String[]{imageUploadVo.getFilePathVO().getUrlPartPath(), saveFileName}));
        imageUploadResultVO.setImageUrl(PathUtil.builderPath((String[])new String[]{imageUploadVo.getFilePathVO().getDatabaseParentPath(), saveFileName}));
        imageUploadResultVO.setMediaType(imageUploadVo.getMediaType());
        imageUploadResultVO.setContentId(imageUploadVo.getContentId());
        imageUploadResultVO.setContentSourceId(imageUploadVo.getContentSourceId());
        return imageUploadResultVO;
    }

    private ImageUploadVO getImageUploadVo(HttpServletRequest request) {
        DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        String siteId = this.getSiteId(request);
        String ossBucketName = (String)SiteConfig.getValue((Long)Long.parseLong(siteId), (Object)"ossBucketName");
        String contentId = this.getValueByParameter(request.getParameter("contentId"));
        String mediaType = this.getValueByParameter(request.getParameter("mediaType"));
        DBConnPool.setDBConnPool((Long)Long.parseLong(siteId));
        Date date = new Date();
        String contentSourceId = "";
        if (StringUtil.isNotEmpty((String)mediaType) && 5 == Integer.parseInt(mediaType)) {
            SCMS_ContentinfoSchema scms_contentinfoSchema = new SCMS_ContentinfoSchema();
            scms_contentinfoSchema.setContentID(contentId);
            scms_contentinfoSchema.fill();
            date = scms_contentinfoSchema.getCreateTime();
            contentSourceId = scms_contentinfoSchema.getContentSourceId();
        } else if (StringUtil.isNotEmpty((String)mediaType) && 6 == Integer.parseInt(mediaType)) {
            SCMS_AudioInfoSchema scms_audioInfoSchema = new SCMS_AudioInfoSchema();
            scms_audioInfoSchema.setId(Long.valueOf(Long.parseLong(contentId)));
            scms_audioInfoSchema.fill();
            date = scms_audioInfoSchema.getCreateTime();
            contentSourceId = scms_audioInfoSchema.getContentSourceId();
        } else if (StringUtil.isNotEmpty((String)mediaType) && 7 == Integer.parseInt(mediaType)) {
            SCMS_SeriesSchema scms_seriesSchema = new SCMS_SeriesSchema();
            scms_seriesSchema.setSeriesid(Long.valueOf(Long.parseLong(contentId)));
            scms_seriesSchema.fill();
            date = scms_seriesSchema.getCreatetime();
            contentSourceId = scms_seriesSchema.getSeriessourceid();
        }
        FilePathVO filePathVO = this.getFilePathVO(date, siteId, contentSourceId, ossBucketName);
        return ImageUploadVO.builder().contentId(Long.valueOf(Long.parseLong(contentId))).mediaType(Integer.parseInt(mediaType)).contentSourceId(contentSourceId).filePathVO(filePathVO).build();
    }

    private String getValueByParameter(String value) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value) || "null".equals(value)) {
            value = "0";
        }
        return value;
    }

    private FilePathVO getFilePathVO(Date date, String siteId, String contentSourceId, String ossBucketName) {
        long siteIdLong = Long.parseLong(siteId);
        boolean isSupportOSS = this.isSupportOSS(siteIdLong);
        String siteAlias = SiteUtil.getAlias((String)siteId);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd/");
        String dateDir = simpleDateFormat.format(date);
        String thirdStorageParentPath = PathUtil.builderPath((String[])new String[]{siteAlias, "/upload/Image/default/", dateDir, contentSourceId});
        String localStorageParentPath = PathCommonUtil.builderPathByLinuxImageDir((String)thirdStorageParentPath);
        String databaseParentPath = PathUtil.builderPathEndSlash((String[])new String[]{"/upload/Image/default/", dateDir, contentSourceId});
        String urlPartPath = PathUtil.builderPath((String[])new String[]{SiteUtil.getImageDomainBySiteId((long)Long.parseLong(siteId)), siteAlias, databaseParentPath});
        ossBucketName = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)ossBucketName) ? siteAlias : ossBucketName;
        FilePathVO filePathVO = FilePathVO.builder().isSupportOSS(isSupportOSS).thirdStorageParentPath(thirdStorageParentPath).localStorageParentPath(localStorageParentPath).databaseParentPath(databaseParentPath).urlPartPath(urlPartPath).ossBucketName(ossBucketName).build();
        return filePathVO;
    }

    private boolean isSupportOSS(long siteIdLong) {
        boolean isSupportOSS = false;
        if (SiteUtil.isSupportOSSStorage((long)siteIdLong)) {
            isSupportOSS = true;
        }
        return isSupportOSS;
    }

    private String getSiteId(HttpServletRequest request) {
        String token = request.getParameter("partnerToken");
        String siteId = request.getParameter("siteId");
        if (!StringUtil.isEmpty((String)token)) {
            siteId = InterfacesMethod.getSiteIdByToken((String)token);
        }
        return siteId;
    }
}

