/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.site;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.common.result.ResultDTO;
import com.chinamcloud.common.storage.dto.ThirdStorageFileUploadDTO;
import com.chinamcloud.common.storage.util.FileStorageUtil;
import com.chinamcloud.common.storage.util.PathUtil;
import com.chinamcloud.common.storage.util.ThirdStorageFileUtil;
import com.chinamcloud.common.util.FileUtil;
import com.chinamclound.vms.vo.ImageUploadOtherResultVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.cms.site.tagImage.TGAReader;
import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.utility.StringUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFileUploadServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(WebFileUploadServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mediaStyle = request.getParameter("mediaStyle");
        String uploadType = request.getParameter("uploadType");
        String cpName = request.getParameter("cpName");
        String siteId = request.getParameter("siteid");
        try {
            Iterator fileItemIterator = this.getFileItemIterator(request);
            boolean isImage = this.judgeIsImage(uploadType);
            boolean isVideo = this.judgeIsVideo(uploadType);
            if (isImage) {
                this.uploadImage(Long.valueOf(Long.parseLong(siteId)), mediaStyle, fileItemIterator, response);
            } else if (isVideo) {
                this.uploadVideo(uploadType, siteId, cpName, fileItemIterator, response);
            }
        }
        catch (FileUploadException e) {
            log.error("\u4e0a\u4f20\u9047\u5230\u5f02\u5e38", (Throwable)e);
            return;
        }
    }

    private boolean judgeIsImage(String uploadType) {
        return StringUtil.isNotEmpty((String)uploadType) && "image".equals(uploadType);
    }

    private boolean judgeIsVideo(String uploadType) {
        return StringUtil.isNotEmpty((String)uploadType) && ("advert".equals(uploadType) || "video".equals(uploadType) || "audio".equals(uploadType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadVideo(String uploadType, String siteId, String cpName, Iterator<FileItem> fileItemIterator, HttpServletResponse response) {
        FileOutputStream fileOutputStream = null;
        String siteAlias = SiteUtil.getAlias((String)siteId);
        try (PrintWriter writer = response.getWriter();){
            while (fileItemIterator.hasNext()) {
                File file;
                FileItem fileItem = fileItemIterator.next();
                if (fileItem.isFormField()) continue;
                String filename = fileItem.getName();
                String linuxVideoUploadDir = Config.getValue((String)"linuxVideoUploadDir");
                String winVideoUploadDir = Config.getValue((String)"winVideoUploadDir");
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd/");
                String timePath = format.format(new Date());
                String LinuxPath = linuxVideoUploadDir + cpName + "/source/web" + "/" + timePath;
                String httpPre = winVideoUploadDir + cpName + "/source/web" + "/" + timePath;
                if ("advert".equals(uploadType)) {
                    String linuxImageDir = Config.getValue((String)"linuxImageDir");
                    String ipath = siteAlias + "/upload/Image/advert/" + timePath;
                    LinuxPath = linuxImageDir + ipath;
                    httpPre = SiteUtil.getImageDomainBySiteId((long)Long.parseLong(siteId)) + ipath;
                }
                if (!(file = new File(LinuxPath)).exists()) {
                    file.mkdirs();
                    file.setExecutable(true);
                    file.setReadable(true);
                    file.setWritable(true);
                }
                String name = new Date().getTime() + filename.substring(filename.lastIndexOf("."));
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(fileItem.getInputStream()));
                fileOutputStream = new FileOutputStream(new File(LinuxPath + name));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(fileOutputStream));
                byte[] bytes = new byte[1024];
                int length = -1;
                while ((length = bufferedInputStream.read(bytes)) != -1) {
                    bufferedOutputStream.write(bytes, 0, length);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                bufferedInputStream.close();
                String backUploadUrl = (httpPre + name).replace("\\", "\\\\");
                JSONObject json = new JSONObject();
                json.put((Object)"backUploadUrl", (Object)backUploadUrl);
                json.put((Object)"Filename", (Object)filename);
                writer.print(json.toString());
            }
        }
        catch (FileNotFoundException e) {
            log.error("\u4e0a\u4f20\u89c6\u9891\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u89c6\u9891\u9047\u5230\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u9047\u5230\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void uploadImage(Long siteId, String mediaStyle, Iterator<FileItem> fileItemIterator, HttpServletResponse response) {
        boolean isSupportOSSStorage = SiteUtil.isSupportOSSStorage((long)siteId);
        String ossBucketName = SiteUtil.getOssBucketName((Long)siteId);
        String dateDir = new SimpleDateFormat("yyyy/MM/dd/").format(new Date());
        String middlePath = this.getMiddlePath(mediaStyle, dateDir);
        String linuxRootPath = Config.getValue((String)"linuxImageDir");
        String thirdStorageParentPath = this.getThirdStorageParentPath(siteId, middlePath);
        String localStorageParentPath = PathUtil.builderPath((String[])new String[]{linuxRootPath, thirdStorageParentPath});
        ArrayList imageUploadOtherResultVOList = Lists.newArrayList();
        try (PrintWriter printWriter = response.getWriter();){
            while (fileItemIterator.hasNext()) {
                ResultDTO mapResultDTO;
                FileItem fileItem = fileItemIterator.next();
                if (fileItem.isFormField()) continue;
                File file = null;
                String fileName = fileItem.getName();
                String saveFileName = FileUtil.getUUIDFileName((String)fileName);
                boolean isMercury = this.judgeIsMercury(fileName);
                boolean bl = isSupportOSSStorage = isSupportOSSStorage && !isMercury;
                if (isSupportOSSStorage) {
                    file = FileStorageUtil.writeFileItemToLocalFile((String)System.getProperty("java.io.tmpdir"), (String)saveFileName, (FileItem)fileItem);
                    ThirdStorageFileUploadDTO thirdStorageFileUploadDTO = FileStorageUtil.builderSimpleThirdStorageFileUploadDTO((String)ossBucketName, (String)thirdStorageParentPath, (String)saveFileName);
                    ResultDTO thirdStorageSimpleUploadResultDTOResultDTO = ThirdStorageFileUtil.simpleUploadByFilePath((ThirdStorageFileUploadDTO)thirdStorageFileUploadDTO, (String)file.getAbsolutePath());
                    if (!thirdStorageSimpleUploadResultDTOResultDTO.isSuccess()) {
                        FileStorageUtil.deleteFileByCondition((File)file, (boolean)true);
                        printWriter.write(thirdStorageSimpleUploadResultDTOResultDTO.getDescription());
                        return;
                    }
                } else {
                    file = FileStorageUtil.writeFileItemToLocalFile((String)localStorageParentPath, (String)saveFileName, (FileItem)fileItem);
                }
                if (!(mapResultDTO = this.getImageSizeInfoMap(isMercury, file)).isSuccess()) {
                    printWriter.write(mapResultDTO.getDescription());
                    return;
                }
                ImageUploadOtherResultVO imageUploadOtherResultVO = this.builderImageUploadOtherResultVO(middlePath, saveFileName, (Map)mapResultDTO.getData(), siteId);
                imageUploadOtherResultVOList.add(imageUploadOtherResultVO);
                FileStorageUtil.deleteFileByCondition((File)file, (boolean)isSupportOSSStorage);
            }
            log.info("\u56fe\u7247\u4e0a\u4f20\u6210\u529f:imageUploadOtherResultVOList:{}", (Object)imageUploadOtherResultVOList);
            String result = JSON.toJSONString(imageUploadOtherResultVOList.get(0));
            response.setContentType("json/html;charset=UTF-8");
            response.setHeader("Cache-Control", "no-cache");
            printWriter.write(result);
            return;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u56fe\u7247\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    private ImageUploadOtherResultVO builderImageUploadOtherResultVO(String middlePath, String saveFileName, Map<String, Integer> sizeInfoMap, Long siteId) {
        ImageUploadOtherResultVO imageUploadOtherResultVO = new ImageUploadOtherResultVO();
        imageUploadOtherResultVO.setHeight(sizeInfoMap.get("height").intValue());
        imageUploadOtherResultVO.setWidth(sizeInfoMap.get("width").intValue());
        imageUploadOtherResultVO.setRelativeUrl(PathUtil.builderPath((String[])new String[]{middlePath, saveFileName}));
        imageUploadOtherResultVO.setAbsoluteUrl(PathUtil.builderPath((String[])new String[]{SiteUtil.getImageDomainBySiteId((long)siteId), SiteUtil.getAlias((long)siteId), middlePath, saveFileName}));
        return imageUploadOtherResultVO;
    }

    private ResultDTO<Map<String, Integer>> getImageSizeInfoMap(boolean isMercury, File file) {
        if (isMercury) {
            return this.getImageSizeInfoMapByMercury(file);
        }
        return this.getImageSizeInfoMapByOrdinary(file);
    }

    private ResultDTO<Map<String, Integer>> getImageSizeInfoMapByOrdinary(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            Raster raster = bufferedImage.getData();
            Rectangle rectangle = raster.getBounds();
            int width = (int)rectangle.getWidth();
            int height = (int)rectangle.getHeight();
            HashMap sizeInfoMap = Maps.newHashMap();
            sizeInfoMap.put("width", width);
            sizeInfoMap.put("height", height);
            return ResultDTO.successfy((Object)sizeInfoMap);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u56fe\u7247\u9047\u5f02\u5e38\uff1a", (Throwable)e);
            return ResultDTO.fail((String)"\u8bfb\u53d6\u56fe\u7247\u9047\u5230\u5f02\u5e38");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultDTO<Map<String, Integer>> getImageSizeInfoMapByMercury(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            TGAReader imageReader = new TGAReader();
            imageReader.unpackImage((InputStream)fileInputStream);
            Dimension dimension = imageReader.getImageSize();
            int width = dimension.width;
            width = width % 4 > 1 ? width + 4 - width % 4 : (width -= width % 4);
            int height = dimension.height + (width - dimension.width);
            HashMap sizeInfoMap = Maps.newHashMap();
            sizeInfoMap.put("width", width);
            sizeInfoMap.put("height", height);
            ResultDTO resultDTO = ResultDTO.successfy((Object)sizeInfoMap);
            return resultDTO;
        }
        catch (Exception e) {
            String errorInfo = "\u8bfb\u53d6\u6c34\u94f6\u56fe\u7247\u9047\u5f02\u5e38";
            log.error(errorInfo, (Throwable)e);
            int exceptionType = Integer.parseInt(e.getMessage());
            if (exceptionType != 1) return ResultDTO.fail((String)errorInfo);
            file.delete();
            errorInfo = "1";
            return ResultDTO.fail((String)errorInfo);
        }
    }

    private boolean judgeIsMercury(String fileName) {
        String extName = fileName.substring(fileName.lastIndexOf("."));
        return StringUtils.isNotBlank((CharSequence)extName) && extName.contains("tga");
    }

    private String getThirdStorageParentPath(Long siteId, String middlePath) {
        return PathUtil.builderPath((String[])new String[]{SiteUtil.getAlias((long)siteId), middlePath});
    }

    private Iterator<FileItem> getFileItemIterator(HttpServletRequest request) throws FileUploadException {
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        servletFileUpload.setSizeMax(-1073741824L);
        servletFileUpload.setHeaderEncoding("UTF-8");
        List fileList = servletFileUpload.parseRequest(request);
        Iterator<FileItem> fileItemIterator = fileList.iterator();
        return fileItemIterator;
    }

    private String getMiddlePath(String mediaStyle, String dateDir) {
        String middlePath = null;
        middlePath = StringUtil.isNotEmpty((String)mediaStyle) && "live".equals(mediaStyle) ? PathUtil.builderPath((String[])new String[]{"/upload/Image/live/", dateDir}) : (StringUtil.isNotEmpty((String)mediaStyle) && "media".equals(mediaStyle) ? "/media/video/player/skins/" : (StringUtil.isNotEmpty((String)mediaStyle) && "player".equals(mediaStyle) ? PathUtil.builderPath((String[])new String[]{"/upload/Image/player/", dateDir}) : (StringUtil.isNotEmpty((String)mediaStyle) && "advert".equals(mediaStyle) ? PathUtil.builderPath((String[])new String[]{"/upload/Image/advert/", dateDir}) : (StringUtil.isNotEmpty((String)mediaStyle) && "transcode".equals(mediaStyle) ? PathUtil.builderPath((String[])new String[]{"/upload/Image/transcode/", dateDir}) : PathUtil.builderPath((String[])new String[]{"/upload/Image/default/", dateDir})))));
        return middlePath;
    }
}

