/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.site.catalogue;

import com.sobey.bsp.cms.dataservice.ColumnUtil;
import com.sobey.bsp.cms.pub.SiteUtil;
import com.sobey.bsp.framework.Page;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.controls.DataGridAction;
import com.sobey.bsp.framework.data.DataCollection;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.data.Transaction;
import com.sobey.bsp.framework.orm.Schema;
import com.sobey.bsp.framework.utility.HtmlUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Application;
import com.sobey.bsp.platform.UserLog;
import com.sobey.bsp.platform.pub.NoUtil;
import com.sobey.bsp.platform.pub.OrderUtil;
import com.sobey.bsp.schema.SCMS_Column_DataDicSchema;
import com.sobey.bsp.schema.SCMS_SiteSchema;
import com.sobey.bsp.schema.SCMS_Site_ColumnSchema;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class SiteCatalogue
extends Page {
    protected static Mapx siteMap = new Mapx();

    public static Mapx init(Mapx params) {
        SCMS_SiteSchema site = new SCMS_SiteSchema();
        site.setId(Long.valueOf(Application.getCurrentSiteID()));
        site.fill();
        return site.toMapx();
    }

    public static Mapx initDialog(Mapx params) {
        Object o1 = params.get((Object)"ID");
        if (o1 != null) {
            long ID = Long.parseLong(params.get((Object)"ID").toString());
            SCMS_SiteSchema site = new SCMS_SiteSchema();
            site.setId(Long.valueOf(ID));
            site.fill();
            params.putAll((Map)site.toMapx());
            return params;
        }
        SCMS_SiteSchema site = new SCMS_SiteSchema();
        site.setId(Long.valueOf(Application.getCurrentSiteID()));
        site.fill();
        params.putAll((Map)site.toMapx());
        params.put((Object)"URL", (Object)"http://");
        return params;
    }

    public static Mapx initCatalogueDialog(Mapx params) {
        String ID = params.getString((Object)"ColumnID");
        if (StringUtil.isEmpty((String)ID)) {
            params.put((Object)"VerifyType", (Object)HtmlUtil.mapxToOptions((Map)ColumnUtil.VerifyTypeMap));
            params.put((Object)"InputType", (Object)HtmlUtil.mapxToOptions((Map)ColumnUtil.InputTypeMap));
            params.put((Object)"IsMandatory", (Object)HtmlUtil.codeToRadios((String)"IsMandatory", (String)"YesOrNo", (Object)"N"));
            params.put((Object)"MaxLength", (Object)"100");
            params.put((Object)"Cols", (Object)"265");
            params.put((Object)"Rows", (Object)"90");
        } else {
            SCMS_Site_ColumnSchema column = new SCMS_Site_ColumnSchema();
            column.setID(ID);
            column.fill();
            params = column.toMapx();
            params.put((Object)"VerifyType", (Object)HtmlUtil.mapxToOptions((Map)ColumnUtil.VerifyTypeMap, (Object)column.getVerifyType()));
            params.put((Object)"InputType", (Object)HtmlUtil.mapxToOptions((Map)ColumnUtil.InputTypeMap, (Object)column.getInputType()));
            params.put((Object)"IsMandatory", (Object)HtmlUtil.codeToRadios((String)"IsMandatory", (String)"YesOrNo", (Object)column.getIsMandatory()));
            params.put((Object)"Extend", (Object)column.getExtend());
            params.put((Object)"Cols", column.getColSize());
            params.put((Object)"Rows", column.getRowSize());
        }
        return params;
    }

    public void savebasic() {
        SCMS_SiteSchema site = new SCMS_SiteSchema();
        site.setValue((DataCollection)this.Request);
        site.fill();
        site.setValue((DataCollection)this.Request);
        site.setModifyuser(User.getUserName());
        site.setModifytime(new Date());
        if (site.update()) {
            SiteUtil.update((long)site.getId());
            UserLog.log((String)"Site", (String)"EditSite", (String)("\u7f16\u8f91\u7ad9\u70b9:" + site.getName() + "\u4fdd\u5b58\u4fe1\u606f\u6210\u529f"), (String)this.Request.getClientIP());
            this.Response.setLogInfo(1, "\u4fdd\u5b58\u6210\u529f");
            long siteID = site.getId();
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            UserLog.log((String)"Site", (String)"EditSite", (String)("\u7f16\u8f91\u7ad9\u70b9:" + site.getName() + "\u4fdd\u5b58\u4fe1\u606f\u5931\u8d25"), (String)this.Request.getClientIP());
            this.Response.setLogInfo(0, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    public static void dg1DataBind(DataGridAction dga) {
        String SiteID = Application.getCurrentSiteID() + "";
        String pid = dga.getParam("pid");
        String name = dga.getParam("name");
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty((String)pid)) {
            sb.append(" and a.parentId=" + pid + "");
        }
        if (StringUtil.isNotEmpty((String)name)) {
            sb.append(" and a.name like '%" + name + "%'");
        }
        String sql = "select a.*,b.name as parentName from scms_site_column a left join scms_site_column b on a.parentId=b.id where  a.siteid=? " + sb.toString() + "";
        QueryBuilder qb = new QueryBuilder();
        qb.add((Object)SiteID);
        qb.setSQL(sql);
        DataTable dt = qb.executePagedDataTable(dga.getPageSize(), dga.getPageIndex());
        dt.decodeColumn("VerifyType", (Map)ColumnUtil.VerifyTypeMap);
        dt.decodeColumn("InputType", (Map)ColumnUtil.InputTypeMap);
        if (dga.getTotal() == 0) {
            dga.setTotal(new QueryBuilder("select distinct count(id)  from scms_site_column a where a.siteid =" + SiteID + " " + sb.toString() + " "));
        } else {
            dga.setTotal(dt.getRowCount());
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String isMandatory = dt.getString(i, "isMandatory");
            String isShow = dt.getString(i, "isShow");
            if (StringUtil.isNotEmpty((String)dt.getString(i, "InputType"))) {
                if (null != isMandatory && "N".equals(isMandatory)) {
                    dt.set(i, "isMandatory", (Object)"\u5426");
                } else {
                    dt.set(i, "isMandatory", (Object)"\u662f");
                }
                if (null != isShow && "N".equals(isShow)) {
                    dt.set(i, "isShow", (Object)"\u5426");
                    continue;
                }
                dt.set(i, "isShow", (Object)"\u662f");
                continue;
            }
            dt.set(i, "isMandatory", (Object)"");
            dt.set(i, "isShow", (Object)"");
        }
        dga.dataTable2JSON(dt);
    }

    public void initSaveColumn(Transaction trans, String name, String columnCode, long siteId, long parentId, int classifyType) {
        SCMS_Site_ColumnSchema column = new SCMS_Site_ColumnSchema();
        long count = new QueryBuilder("select count(id) from scms_site_column where  siteid = '" + siteId + "' and code ='" + columnCode + "' and parentId=" + parentId + " ").executeLong();
        if (count > 0L) {
            return;
        }
        column.setID(NoUtil.getMaxID((String)"siteColumnId"));
        column.setSiteID(siteId);
        column.setName(name);
        column.setCode(columnCode);
        column.setVerifyType("1");
        column.setParentId(Long.valueOf(parentId));
        column.setOrderFlag(OrderUtil.getDefaultOrder());
        column.setAddTime(new Date());
        column.setAddUser(User.getUserName());
        column.setExtend(Integer.valueOf(1));
        column.setClassifyType(Integer.valueOf(classifyType));
        column.setInputType("1");
        column.setIsMandatory("N");
        column.setNumFlag(Integer.valueOf(0));
        trans.add((Schema)column, 1);
    }

    public void saveColumn() {
        String columnid = this.$V("ColumnID");
        Transaction trans = new Transaction();
        SCMS_Site_ColumnSchema column = new SCMS_Site_ColumnSchema();
        String siteId = Application.getCurrentSiteID() + "";
        String columnCode = this.$V("Code");
        if (StringUtil.isNotEmpty((String)columnid)) {
            column.setID(columnid);
            if (column.fill()) {
                column.setValue((DataCollection)this.Request);
                long count = new QueryBuilder("select count(id) from scms_site_column where  siteid = '" + siteId + "' and code ='" + columnCode + "' and parentId=" + column.getParentId() + " and id!=" + column.getID() + "").executeLong();
                if (count > 0L) {
                    this.Response.setLogInfo(0, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5");
                    return;
                }
                this.setColumnValue(column);
                this.saveListOption(trans, column);
                if (null == column.getNumFlag() || 0 == column.getNumFlag()) {
                    column.setNumFlag(Integer.valueOf(Integer.parseInt(String.valueOf(column.getID()))));
                }
                trans.add((Schema)column, 2);
                trans.add(new QueryBuilder("update scms_site_column_value set ColumnCode=? where ColumnID=?", (Object)column.getCode(), column.getID()));
            }
        } else {
            column.setValue((DataCollection)this.Request);
            long count = new QueryBuilder("select count(id) from scms_site_column where  siteid = '" + siteId + "' and code ='" + columnCode + "' and parentId=" + column.getParentId() + " ").executeLong();
            if (count > 0L) {
                this.Response.setLogInfo(0, "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u5b57\u6bb5");
                return;
            }
            column.setID(NoUtil.getMaxID((String)"siteColumnId"));
            column.setSiteID(Application.getCurrentSiteID());
            column.setOrderFlag(OrderUtil.getDefaultOrder());
            column.setAddTime(new Date());
            column.setAddUser(User.getUserName());
            column.setExtend(Integer.valueOf(1));
            this.setColumnValue(column);
            this.saveListOption(trans, column);
            if (null == column.getNumFlag() || 0 == column.getNumFlag()) {
                column.setNumFlag(Integer.valueOf(Integer.parseInt(String.valueOf(column.getID()))));
            }
            trans.add((Schema)column, 1);
        }
        if (trans.commit()) {
            this.Response.setLogInfo(1, "\u4fdd\u5b58\u6210\u529f");
        } else {
            this.Response.setLogInfo(0, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private void saveListOption(Transaction trans, SCMS_Site_ColumnSchema column) {
        try {
            String ListOption;
            if ((column.getInputType().equals(ColumnUtil.Select) || column.getInputType().equals(ColumnUtil.Checkbox) || column.getInputType().equals(ColumnUtil.Radio)) && StringUtil.isNotEmpty((String)(ListOption = this.$V("ListOption")))) {
                JSONArray ja = JSONArray.fromObject((Object)ListOption);
                StringBuilder sb = new StringBuilder();
                String columnDics = "";
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject item = ja.getJSONObject(i);
                    SCMS_Column_DataDicSchema columnDic = new SCMS_Column_DataDicSchema();
                    int cFlag = item.getInt("cFlag");
                    if (cFlag == 3) {
                        sb.append(item.getLong("id") + ",");
                        continue;
                    }
                    if (cFlag == 2) {
                        columnDic.setId(Long.valueOf(item.getLong("id")));
                    } else {
                        columnDic.setId(Long.valueOf(NoUtil.getMaxID((String)"siteColumnId")));
                    }
                    columnDic.setValue(item.getString("value"));
                    columnDic.setCode(StringUtil.isNotEmpty((String)item.getString("code")) ? item.getString("code") : columnDic.getId().toString());
                    columnDic.setIsShow(item.getString("isShow"));
                    columnDic.setColumnId(Long.valueOf(column.getID()));
                    if (item.has("isDefault")) {
                        columnDics = columnDics + (StringUtil.isEmpty((String)columnDics) ? columnDic.getCode().toString() : "," + columnDic.getCode().toString());
                    }
                    trans.add((Schema)columnDic, cFlag);
                }
                if (StringUtil.isNotEmpty((String)sb.toString())) {
                    String delIds = sb.substring(0, sb.length() - 1);
                    trans.add(new QueryBuilder("delete from scms_column_data_dic where id in(" + delIds + ")"));
                }
                column.setDefaultValue(columnDics);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setColumnValue(SCMS_Site_ColumnSchema column) {
        String defaultValue = column.getDefaultValue();
        defaultValue = defaultValue.replaceAll("\u3000\u3000", ",");
        defaultValue = defaultValue.replaceAll("\u3000", ",");
        defaultValue = defaultValue.replaceAll("  ", ",");
        defaultValue = defaultValue.replaceAll(" ", ",");
        defaultValue = defaultValue.replaceAll(",,", ",");
        defaultValue = defaultValue.replaceAll("\uff0c\uff0c", ",");
        defaultValue = defaultValue.replaceAll("\uff0c", ",");
        column.setDefaultValue(defaultValue);
        if (ColumnUtil.Input.equals(column.getInputType())) {
            column.setColSize(null);
            column.setRowSize(null);
            column.setListOption("");
        } else if (ColumnUtil.Text.equals(column.getInputType())) {
            column.setColSize(this.$V("Cols"));
            column.setRowSize(this.$V("Rows"));
            column.setListOption("");
        } else if (ColumnUtil.Select.equals(column.getInputType())) {
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setVerifyType(ColumnUtil.STRING);
        } else if (ColumnUtil.Radio.equals(column.getInputType())) {
            column.setIsMandatory("N");
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setVerifyType(ColumnUtil.STRING);
        } else if (ColumnUtil.Checkbox.equals(column.getInputType())) {
            column.setIsMandatory("N");
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setVerifyType(ColumnUtil.STRING);
        } else if (ColumnUtil.DateInput.equals(column.getInputType())) {
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setListOption("");
            column.setVerifyType(ColumnUtil.STRING);
        } else if (ColumnUtil.ImageInput.equals(column.getInputType())) {
            column.setIsMandatory("N");
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setListOption("");
            column.setVerifyType(ColumnUtil.STRING);
        } else if (ColumnUtil.HTMLInput.equals(column.getInputType())) {
            column.setIsMandatory("N");
            column.setColSize(null);
            column.setRowSize(null);
            column.setMaxLength(null);
            column.setListOption("");
            column.setVerifyType(ColumnUtil.STRING);
        }
    }

    public void del() {
        String IDs = this.$V("IDs");
        String deletecoumnSql = "delete from scms_site_column where id in (" + IDs + ")";
        String deletevalueSql = "delete from scms_column_data_dic where columnId in (" + IDs + ")";
        Transaction trans = new Transaction();
        trans.add(new QueryBuilder(deletecoumnSql));
        trans.add(new QueryBuilder(deletevalueSql));
        if (trans.commit()) {
            this.Response.setLogInfo(1, "\u5220\u9664\u6210\u529f");
        } else {
            this.Response.setLogInfo(0, "\u5220\u9664\u5931\u8d25");
        }
    }

    public void getSelectTypes() {
        String sql;
        DataTable dt;
        String parentId = this.$V("parentId");
        if (StringUtil.isEmpty((String)parentId)) {
            parentId = "0";
        }
        if (null != (dt = new QueryBuilder(sql = "select id, name from scms_site_column where parentId=" + parentId).executeDataTable()) && dt.getRowCount() > 0) {
            JSONArray ja = new JSONArray();
            for (int i = 0; i < dt.getRowCount(); ++i) {
                JSONObject item = new JSONObject();
                item.put((Object)"id", (Object)dt.getLong(i, "id"));
                item.put((Object)"name", (Object)dt.getString(i, "name"));
                ja.add((Object)item);
            }
            this.Response.setMessage(ja.toString());
        }
    }
}

