/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.site.tagImage;

import com.sobey.bsp.cms.site.tagImage.ImageReader;
import com.sobey.bsp.cms.site.tagImage.TGAReader;
import java.io.InputStream;

public class TGAReader
extends ImageReader {
    private TgaHeader tgaHeader;
    private int scanMode = 0;
    private int l = 0;
    private int m = 0;
    private int n = 0;
    private int o = 0;
    private static final String UNHANDLECOLORMAPTYPE = "1";

    public void unpackImage(InputStream is) throws Exception {
        this.tgaHeader = new TgaHeader(this, null);
        this.tgaHeader.readHeader(is);
        this.bitsPerPixel = this.tgaHeader.bits_per_pixel;
        this.width = this.tgaHeader.width;
        this.height = this.tgaHeader.height;
        this.pix = new int[this.width * this.height];
        if (this.tgaHeader.colourmap_type != 0 && this.tgaHeader.colourmap_type != 1) {
            System.out.println("Can only handle colour map types of 0 and 1");
            throw new Exception(UNHANDLECOLORMAPTYPE);
        }
        this.scanMode = (this.tgaHeader.image_descriptor & 0x30) >> 4;
        switch (this.scanMode) {
            case 0: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 1: {
                this.l = this.height - 1;
                this.m = -1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
            case 2: {
                this.l = 0;
                this.m = 1;
                this.n = 0;
                this.o = 1;
                break;
            }
            case 3: {
                this.l = 0;
                this.m = 1;
                this.n = this.width - 1;
                this.o = -1;
                break;
            }
        }
        switch (this.tgaHeader.image_type) {
            case 0: {
                System.out.println("There are no data in the image file");
                System.exit(1);
            }
            case 1: {
                this.unpack_CMP_TgaFile(is);
                break;
            }
            case 2: {
                this.unpackTrueColorTgaFile(is);
                break;
            }
            case 3: {
                this.unpack_BW_TgaFile(is);
                break;
            }
            case 9: {
                this.unpack_RLE_CMP_TgaFile(is);
                break;
            }
            case 10: {
                this.unpack_RLE_TrueColor_TgaFile(is);
                break;
            }
            case 11: {
                this.unpack_RLE_BW_TgaFile(is);
                break;
            }
            case 32: 
            case 33: {
                System.out.println("Not implemented for compressed color mapped images");
                System.exit(1);
            }
            default: {
                System.out.println("I can't find a type matches this");
                System.exit(1);
            }
        }
    }

    private void unpackTrueColorTgaFile(InputStream is) throws Exception {
        int skipover = 0;
        int nindex = 0;
        skipover += this.tgaHeader.id_length;
        is.skip(skipover += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        int bytes2read = this.tgaHeader.bits_per_pixel / 8;
        byte[] brgb = new byte[bytes2read * this.width * this.height];
        is.read(brgb, 0, bytes2read * this.width * this.height);
        if (bytes2read == 3) {
            System.out.println("24 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                }
            }
        } else if (bytes2read == 4) {
            System.out.println("32 bits Tga uncompressed image!");
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | 0xFF000000;
                    ++nindex;
                }
            }
        } else if (bytes2read == 2) {
            System.out.println("16 bits Tga uncompressed image!");
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                }
            }
        }
        is.close();
    }

    private void unpack_RLE_TrueColor_TgaFile(InputStream is) throws Exception {
        int skipover = 0;
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        skipover += this.tgaHeader.id_length;
        is.skip(skipover += this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        int bytes2read = this.tgaHeader.bits_per_pixel / 8;
        int available = is.available();
        byte[] brgb = new byte[available];
        is.read(brgb, 0, available);
        if (bytes2read == 3) {
            System.out.println("24 bits Tga RLE image!");
            block0: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex + 1] & 0xFF) << 8 | (brgb[nindex + 2] & 0xFF) << 16;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) break;
                    }
                    nindex += 3;
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block0;
                }
            }
        } else if (bytes2read == 4) {
            System.out.println("32 bits Tga RLE image!");
            block3: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex] & 0xFF | (brgb[nindex + 1] & 0xFF) << 8 | (brgb[nindex + 2] & 0xFF) << 16 | 0xFF000000;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) break;
                    }
                    nindex += 4;
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = brgb[nindex++] & 0xFF | (brgb[nindex++] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16 | 0xFF000000;
                    ++nindex;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block3;
                }
            }
        } else if (bytes2read == 2) {
            System.out.println("16 bits Tga RLE image!");
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            block6: while (p < this.width * this.height) {
                int q;
                k = (brgb[nindex++] & 0x7F) + 1;
                if ((brgb[nindex - 1] & 0x80) != 0) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    for (q = 0; q < k; ++q) {
                        this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                        if (++j % this.width == 0) {
                            ++i;
                            j = 0;
                        }
                        if (++p >= this.width * this.height) continue block6;
                    }
                    continue;
                }
                for (q = 0; q < k; ++q) {
                    r = (brgb[++nindex] & 0x7C) << 1;
                    g = (brgb[nindex] & 3) << 6 | (brgb[nindex - 1] & 0xE0) >> 2;
                    b = (brgb[nindex - 1] & 0x1F) << 3;
                    a = 255;
                    ++nindex;
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = a << 24 | r << 16 | g << 8 | b;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) continue block6;
                }
            }
        }
        is.close();
    }

    private void readPalette(InputStream is) throws Exception {
        int index = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int byte_per_pixel = (this.tgaHeader.colourmap_entry_size + 1) / 8;
        int readbytes = byte_per_pixel * (this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index);
        byte[] brgb = new byte[readbytes];
        int colorsUsed = this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index;
        this.colorPalette = new int[colorsUsed];
        this.indexedColor = true;
        is.skip(this.tgaHeader.id_length);
        is.skip(this.tgaHeader.first_entry_index);
        is.read(brgb, 0, readbytes);
        switch (this.tgaHeader.colourmap_entry_size) {
            case 15: 
            case 16: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    r = (brgb[++index] & 0x7C) << 1;
                    g = (brgb[index] & 3) << 6 | (brgb[index - 1] & 0xE0) >> 2;
                    b = (brgb[index - 1] & 0x1F) << 3;
                    a = 255;
                    this.colorPalette[i] = a << 24 | r << 16 | g << 8 | b;
                    ++index;
                }
                break;
            }
            case 24: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.colorPalette[i] = 0xFF000000 | brgb[index++] & 0xFF | (brgb[index++] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16;
                }
                break;
            }
            case 32: {
                for (int i = 0; i < this.tgaHeader.colourmap_length - this.tgaHeader.first_entry_index; ++i) {
                    this.colorPalette[i] = brgb[index++] & 0xFF | (brgb[index++] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16 | (brgb[index++] & 0xFF) << 24;
                }
                break;
            }
        }
    }

    private void unpack_CMP_TgaFile(InputStream is) throws Exception {
        System.out.println("color mapped Tga uncompressed image!");
        int index = 0;
        this.readPalette(is);
        if (this.tgaHeader.bits_per_pixel != 8) {
            System.out.println("Can only handle 8 bit color mapped tga file");
            System.exit(1);
        }
        byte[] brgb = new byte[this.width * this.height];
        is.read(brgb, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.colorPalette[brgb[index++] & 0xFF];
            }
        }
        is.close();
    }

    private void unpack_RLE_CMP_TgaFile(InputStream is) throws Exception {
        System.out.println("color mapped Tga RLE image!");
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        if (this.tgaHeader.bits_per_pixel != 8) {
            System.out.println("Can only handle 8 bit color mapped tga file");
            System.exit(1);
        }
        this.readPalette(is);
        int available = is.available();
        byte[] brgb = new byte[available];
        is.read(brgb, 0, available);
        block0: while (p < this.width * this.height) {
            int q;
            k = (brgb[nindex++] & 0x7F) + 1;
            if ((brgb[nindex - 1] & 0x80) != 0) {
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.colorPalette[brgb[nindex] & 0xFF];
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) break;
                }
                ++nindex;
                continue;
            }
            for (q = 0; q < k; ++q) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = this.colorPalette[brgb[nindex++] & 0xFF];
                if (++j % this.width == 0) {
                    ++i;
                    j = 0;
                }
                if (++p >= this.width * this.height) continue block0;
            }
        }
        is.close();
    }

    private void unpack_BW_TgaFile(InputStream is) throws Exception {
        this.bitsPerPixel = 1;
        System.out.println("Uncompressed Black and White Tga image!");
        int index = 0;
        is.skip(this.tgaHeader.id_length);
        is.skip(this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        byte[] brgb = new byte[this.width * this.height];
        is.read(brgb, 0, this.width * this.height);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[index] & 0xFF | (brgb[index] & 0xFF) << 8 | (brgb[index++] & 0xFF) << 16;
            }
        }
        is.close();
    }

    private void unpack_RLE_BW_TgaFile(InputStream is) throws Exception {
        this.bitsPerPixel = 1;
        System.out.println("Black and White Tga RLE image!");
        int nindex = 0;
        int p = 0;
        int k = 0;
        int i = 0;
        int j = 0;
        is.skip(this.tgaHeader.id_length);
        is.skip(this.tgaHeader.colourmap_type * this.tgaHeader.colourmap_length);
        int available = is.available();
        byte[] brgb = new byte[available];
        is.read(brgb, 0, available);
        block0: while (p < this.width * this.height) {
            int q;
            k = (brgb[nindex++] & 0x7F) + 1;
            if ((brgb[nindex - 1] & 0x80) != 0) {
                for (q = 0; q < k; ++q) {
                    this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex] & 0xFF) << 8 | (brgb[nindex] & 0xFF) << 16;
                    if (++j % this.width == 0) {
                        ++i;
                        j = 0;
                    }
                    if (++p >= this.width * this.height) break;
                }
                ++nindex;
                continue;
            }
            for (q = 0; q < k; ++q) {
                this.pix[this.width * (this.l + this.m * i) + this.n + this.o * j] = 0xFF000000 | brgb[nindex] & 0xFF | (brgb[nindex] & 0xFF) << 8 | (brgb[nindex++] & 0xFF) << 16;
                if (++j % this.width == 0) {
                    ++i;
                    j = 0;
                }
                if (++p >= this.width * this.height) continue block0;
            }
        }
        is.close();
    }
}

