/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.stat;

import com.sobey.bsp.cms.stat.ReportUtil;
import com.sobey.bsp.framework.data.DataTable;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChartUtil {
    public static String getPie3DChart(DataTable dt, double rate) {
        ReportUtil.prepareForPie3D((DataTable)dt, (double)rate);
        return ChartUtil.getPie3DChart((DataTable)dt);
    }

    public static String getPie3DChart(DataTable dt, int count) {
        ReportUtil.prepareForPie3D((DataTable)dt, (int)count);
        return ChartUtil.getPie3DChart((DataTable)dt);
    }

    public static String getPie3DChart(DataTable dt, int count, double rate) {
        ReportUtil.prepareForPie3D((DataTable)dt, (int)count, (double)rate);
        return ChartUtil.getPie3DChart((DataTable)dt);
    }

    public static String getPie3DChart(DataTable dt) {
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"FF0000", "006F00", "CCCC00", "0D8ECF", "04D215", "B0DE09", "F8FF01", "FF9E01", "FF6600", "814EE6", "F234B0", "FF9966", "0099FF", "993300", "333300", "003300", "003366", "000080", "333399", "333333", "800000", "FF6600", "808000", "808080", "008080", "0000FF", "666699", "808080", "FF9900", "99CC00", "339966", "33CCCC", "3366FF", "800080", "999999", "FF00FF", "FFCC00", "FFFF00", "00FF00", "00FFFF", "00CCFF", "993366", "C0C0C0", "FF99CC", "FFCC99", "FFFF99", "CCFFCC", "CCFFFF", "99CCFF", "CC99FF", "FFFFFF", "1D8BD1", "F1683C", "2AD62A"};
        xml.append("<graph baseFontSize=\"12\" showNames=\"1\" hoverCapSepChar=\":\" animation=\"1\" nameTBDistance=\"20\" showPercentageInLabel=\"1\">");
        for (int j = 0; j < dt.getRowCount(); ++j) {
            xml.append("<set value=\"" + dt.get(j, 1) + "\" name=\"" + dt.get(j, 0) + "\" color=\"" + Colors[j % Colors.length] + "\"/>");
        }
        xml.append("</graph>");
        String xmlstr = xml.toString().replace("null", "0");
        return xmlstr;
    }

    public static String getLine2DChart(DataTable dt, int labelCount) {
        int i;
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"1D8BD1", "F1683C", "2AD62A", "FF0000", "006F00", "CCCC00", "0D8ECF", "04D215", "B0DE09", "F8FF01", "FF9E01", "FF6600", "814EE6", "F234B0", "FF9966", "0099FF", "993300", "333300", "003300", "003366", "000080", "333399", "333333", "800000", "FF6600", "808000", "808080", "008080", "0000FF", "666699", "808080", "FF9900", "99CC00", "339966", "33CCCC", "3366FF", "800080", "999999", "FF00FF", "FFCC00", "FFFF00", "00FF00", "00FFFF", "00CCFF", "993366", "C0C0C0", "FF99CC", "FFCC99", "FFFF99", "CCFFCC", "CCFFFF", "99CCFF", "CC99FF", "FFFFFF"};
        xml.append("<graph lineThickness='0' canvasBorderThickness='0' alternateHGridAlpha='5' canvasBorderColor='666666' divLineColor='ff5904' divLineAlpha='20' showAlternateHGridColor='1' AlternateHGridColor='ff5904' hovercapbg='FFECAA' hovercapborder='F47E00' formatNumberScale='0' decimalPrecision='0' showvalues='0' numdivlines='4' numVdivlines='0' rotateNames='0'>");
        xml.append("<categories>");
        int space = new Double(Math.ceil((double)dt.getRowCount() * 0.95 / (double)labelCount)).intValue();
        int count = 0;
        for (i = 0; i < dt.getRowCount(); ++i) {
            if (i % space == 0) {
                ++count;
            }
            xml.append("<category name='" + dt.get(i, 0) + "' " + (i % space != 0 || count > labelCount ? "showName='0'" : "") + "/>");
        }
        xml.append("</categories>");
        for (i = 1; i < dt.getColCount(); ++i) {
            String color = Colors[(i - 1) % Colors.length];
            xml.append("<dataset seriesName='" + dt.getDataColumn(i).getColumnName() + "' color='" + color + "' anchorBorderColor='" + color + "' anchorBgColor='" + color + "'>");
            for (int j = 0; j < dt.getRowCount(); ++j) {
                xml.append("<set value='" + dt.get(j, i) + "'/>");
            }
            xml.append("</dataset>");
        }
        xml.append("</graph>");
        return xml.toString();
    }

    public static String getMixed2DChart(DataTable dt, String yColumn, int labelCount) {
        int i;
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"F6BD0F", "8BBA00", "FF0000", "2AD62A", "006F00", "CCCC00", "0D8ECF", "04D215", "B0DE09", "F8FF01", "FF9E01", "FF6600", "814EE6", "F234B0", "FF9966", "0099FF", "993300", "333300", "003300", "003366", "000080", "333399", "333333", "800000", "FF6600", "808000", "808080", "008080", "0000FF", "666699", "808080", "FF9900", "99CC00", "339966", "33CCCC", "3366FF", "800080", "999999", "FF00FF", "FFCC00", "FFFF00", "00FF00", "00FFFF", "00CCFF", "993366", "C0C0C0", "FF99CC", "FFCC99", "FFFF99", "CCFFCC", "CCFFFF", "99CCFF", "CC99FF", "FFFFFF"};
        xml.append("<graph lineThickness='0' canvasBorderThickness='0' alternateHGridAlpha='5' canvasBorderColor='666666' divLineColor='ff5904' divLineAlpha='20' showAlternateHGridColor='1' AlternateHGridColor='ff5904' hovercapbg='FFECAA' hovercapborder='F47E00' formatNumberScale='0' decimalPrecision='0' showvalues='0' numdivlines='4' numVdivlines='0' rotateNames='0'>");
        xml.append("<categories>");
        int space = new Double(Math.ceil((double)dt.getRowCount() * 0.95 / (double)labelCount)).intValue();
        int count = 0;
        for (i = 0; i < dt.getRowCount(); ++i) {
            if (i % space == 0) {
                ++count;
            }
            xml.append("<category name='" + dt.get(i, 0) + "' " + (i % space != 0 || count > labelCount ? "showName='0'" : "") + "/>");
        }
        xml.append("</categories>");
        for (i = 1; i < dt.getColCount(); ++i) {
            String color = Colors[(i - 1) % Colors.length];
            xml.append("<dataset seriesName='" + dt.getDataColumn(i).getColumnName() + "' color='" + color + "' anchorBorderColor='" + color + "' anchorBgColor='" + color + "'");
            if (dt.getDataColumn(i).getColumnName().equalsIgnoreCase(yColumn)) {
                xml.append(" parentYAxis='S'");
            }
            xml.append(">");
            for (int j = 0; j < dt.getRowCount(); ++j) {
                xml.append("<set value='" + dt.get(j, i) + "'/>");
            }
            xml.append("</dataset>");
        }
        xml.append("</graph>");
        return xml.toString();
    }

    public static String getColumn3DChart(DataTable dt) {
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"F6BD0F", "8BBA00", "FF0000", "2AD62A", "006F00", "CCCC00", "0D8ECF", "04D215", "B0DE09", "F8FF01", "FF9E01", "FF6600", "814EE6", "F234B0", "FF9966", "0099FF", "993300", "333300", "003300", "003366", "000080", "333399", "333333", "800000", "FF6600", "808000", "808080", "008080", "0000FF", "666699", "808080", "FF9900", "99CC00", "339966", "33CCCC", "3366FF", "800080", "999999", "FF00FF", "FFCC00", "FFFF00", "00FF00", "00FFFF", "00CCFF", "993366", "C0C0C0", "FF99CC", "FFCC99", "FFFF99", "CCFFCC", "CCFFFF", "99CCFF", "CC99FF", "FFFFFF"};
        xml.append("<graph caption='' xAxisName='' yAxisName='' decimalPrecision='0' formatNumberScale='0'>");
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String color = Colors[i % Colors.length];
            xml.append("<set name='" + dt.get(i, 0) + "' value='" + dt.get(i, 1) + "' color='" + color + "'/>");
        }
        xml.append("</graph>");
        return xml.toString();
    }

    public static String getSegmentLineChart(DataTable dt, String[] columns) {
        StringBuffer xml = new StringBuffer();
        xml.append("<chart caption='\u62c6\u6761\u65f6\u957f\u7edf\u8ba1' lineThickness='1' showValues='0' formatNumberScale='0' anchorRadius='2'  divLineAlpha='20' divLineColor='CC3300' divLineIsDashed='1' showAlternateHGridColor='1' alternateHGridColor='CC3300' shadowAlpha='40' labelStep=\"2\" numvdivlines='5' chartRightMargin=\"35\" bgColor='FFFFFF,CC3300' bgAngle='270' bgAlpha='10,10' alternateHGridAlpha='5'  legendPosition ='RIGHT '>");
        xml.append("<categories>");
        if (columns.length != 0) {
            for (int i = 0; i < columns.length; ++i) {
                xml.append("<category name=\"" + columns[i] + "\"/>");
            }
        }
        xml.append("</categories>");
        xml.append("<dataset seriesName='\u65f6\u957f/\u79d2' color='F1683C' anchorBorderColor='F1683C' anchorBgColor='F1683C'>");
        for (int j = 0; j < dt.getColCount(); ++j) {
            xml.append("<set value=\"" + dt.getString(0, j) + "\"/>");
        }
        xml.append("</dataset>");
        xml.append("<styles> <definition> <style name='CaptionFont' type='font' size='12'/> </definition> <application> <apply toObject='CAPTION' styles='CaptionFont' /> <apply toObject='SUBCAPTION' styles='CaptionFont' /> </application> </styles></chart>");
        return xml.toString().replace("null", "0");
    }

    public static String getFCFPie3DChart(DataTable dt, String caption) {
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"FF3333", "0066FF"};
        xml.append("<chart showNames='1' palette='1' animation='1' formatNumberScale='0' use3DLighting='1' dashed='0' smartLabelClearance='-18' pieSliceDepth='11' pieYScale='80'  pieRadius='60'  startingAngle='15'  caption='" + caption + "' numberSuffix='G' bgColor='B9B9B9' bgAlpha='50'>");
        for (int j = 0; j < dt.getRowCount(); ++j) {
            if (j == 1) {
                xml.append("<set value=\"" + dt.get(j, 1) + "\" name=\"" + dt.get(j, 0) + "\" color=\"" + Colors[j % Colors.length] + "\"/>");
                continue;
            }
            xml.append("<set value=\"" + dt.get(j, 1) + "\" name=\"" + dt.get(j, 0) + "\" isSliced=\"1\" color=\"" + Colors[j % Colors.length] + "\"/>");
        }
        xml.append("<styles><definition><style type='font' name='CaptionFont' size='12' color='666666' /><style type='font' name='SubCaptionFont' bold='0' /></definition><application><apply toObject='caption' styles='CaptionFont' /><apply toObject='SubCaption' styles='SubCaptionFont' /></application></styles>");
        xml.append("</chart>");
        return xml.toString().replace("null", "0");
    }

    public static String getFCFLineChart(DataTable dt) {
        StringBuffer xml = new StringBuffer();
        if (dt.getString(0, 0).length() > 9) {
            xml.append("<graph caption='\u7a7a\u95f4\u4f7f\u7528\u5206\u5e03\u7edf\u8ba1(G)' numberSuffix='G' formatNumberScale='0' yAxisMinValue='0' baseFontSize='12'  decimalPrecision='0' animation='1' showValues='0' baseFontColor='666666' showNames='1' showAlternateHGridColor='1' AlternateHGridColor='ff5904' divLineColor='ff5904' divLineAlpha='20' lineColor='FF9900' alternateHGridAlpha='5' baseFont='\u5b8b\u4f53' bgColor='B9B9B9' bgAlpha='50' chartRightMargin='35' >");
        } else {
            xml.append("<graph caption='\u7a7a\u95f4\u4f7f\u7528\u5206\u5e03\u7edf\u8ba1(G)' numberSuffix='G' formatNumberScale='0' yAxisMinValue='0' baseFontSize='12'  decimalPrecision='0' animation='1' showValues='0' baseFontColor='666666' showNames='1' showAlternateHGridColor='1' AlternateHGridColor='ff5904' divLineColor='ff5904' divLineAlpha='20' lineColor='FF9900' alternateHGridAlpha='5' baseFont='\u5b8b\u4f53' bgColor='B9B9B9' bgAlpha='50' >");
        }
        for (int i = 0; i < dt.getRowCount(); ++i) {
            xml.append("<set value=\"" + dt.getString(i, 1) + "\" name=\"" + dt.getString(i, 0) + "\"/>");
        }
        xml.append("</graph>");
        return xml.toString().replace("null", "0");
    }

    public static String getFCFMsLineChart(DataTable dt, String[] columns, String ... count) {
        int j;
        StringBuffer xml = new StringBuffer();
        int n = 0;
        if (count.length != 0) {
            n = Integer.parseInt(count[0]);
        }
        if (columns[0].length() > 9) {
            xml.append("<graph caption='\u64ad\u653e\u91cf\u7edf\u8ba1' hovercapbg='FFECAA' formatNumberScale='0' decimalPrecision='0' showvalues='0' numdivlines='4' numVdivlines='0' yaxisminvalue='0' yaxismaxvalue='100' showAlternateHGridColor='1' AlternateHGridColor='cccccc' rotateNames='0' baseFontSize='12'  bgColor='B9B9B9' bgAlpha='50' chartRightMargin='40'>");
        } else {
            xml.append("<graph caption='\u64ad\u653e\u91cf\u7edf\u8ba1' hovercapbg='FFECAA' formatNumberScale='0' decimalPrecision='0' showvalues='0' numdivlines='4' numVdivlines='0' yaxisminvalue='0' yaxismaxvalue='100' showAlternateHGridColor='1' AlternateHGridColor='cccccc' rotateNames='0' baseFontSize='12'  bgColor='B9B9B9' bgAlpha='50'>");
        }
        xml.append("<categories>");
        if (columns.length != 0) {
            for (int i = 0; i < columns.length; ++i) {
                if (n == 0) {
                    xml.append("<category name=\"" + columns[i] + "\"/>");
                    continue;
                }
                if (i % n == 0) {
                    xml.append("<category name=\"" + columns[i] + "\"/>");
                    continue;
                }
                xml.append("<category name=\"\"/>");
            }
        }
        xml.append("</categories>");
        xml.append("<dataset seriesName='\u64ad\u653e\u91cf' color='CC6600' anchorBorderColor='F1683C' anchorBgColor='CC6600'>");
        for (j = 0; j < dt.getColCount(); ++j) {
            xml.append("<set value=\"" + dt.getString(0, j) + "\"/>");
        }
        xml.append("</dataset>");
        xml.append("<dataset seriesName='\u64ad\u653eIP\u6570' color='0066FF' anchorBorderColor='1D8BD1' anchorBgColor='0066FF'>");
        for (j = 0; j < dt.getColCount(); ++j) {
            xml.append("<set value=\"" + dt.getString(1, j) + "\"/>");
        }
        xml.append("</dataset>");
        xml.append("</graph>");
        return xml.toString().replace("null", "0");
    }

    public static String getFCFMapChart(DataTable dt) {
        StringBuffer xml = new StringBuffer();
        String[] Colors = new String[]{"FFFFFF", "FFFFCC", "FFFF99", "FFFF85", "FFFF66", "FFFF45", "FFFF33", "FFFF00", "FFCC99", "FFCC85", "FFCC66", "FFCC33", "FFCC00", "FF9966", "FF9950", "FF9933", "FF9920", "FF9900", "FF6666", "FF6650", "FF6633", "FF6600", "FF3333", "FF3322", "FF3311", "FF3300", "FF0000"};
        xml.append("<map showShadow='1' showBevel='1' showLabels='0' includeNameInLabels='0' useSNameInToolTip='0' animation='1' legendCaption='\u89c6\u9891\u5730\u57df\u89c2\u770b\u5206\u5e03\u6570\u636e' fillColor='F0FAFF'  baseFontSize='12' markerBgColor='FF5904' legendPosition='bottom' borderColor='00324A' borderAlpha='50' bgColor='F3F3F3' hoverColor='C0D2F8'>");
        xml.append("<data>");
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String count = dt.getString(i, "count");
            int temp = ChartUtil.getColorValue((int)Integer.valueOf(count));
            if ("\u9655\u897f\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.SA");
            } else if ("\u5c71\u897f\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.SX");
            } else if ("\u91cd\u5e86\u5e02".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.CQ");
            } else if ("\u6cb3\u5317\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.HB");
            } else if ("\u6e56\u5317\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.HU");
            } else if ("\u6cb3\u5357\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.HE");
            } else if ("\u6d77\u5357\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.HA");
            } else if ("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.XJ");
            } else if ("\u5185\u8499\u53e4\u81ea\u6cbb\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.NM");
            } else if ("\u897f\u85cf\u81ea\u6cbb\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.XZ");
            } else if ("\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.NX");
            } else if ("\u53f0\u6e7e\u7701".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.TA");
            } else if ("\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.MA");
            } else if ("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.HK");
            } else if ("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a".equals(dt.getString(i, "area"))) {
                dt.set(i, "shortName", (Object)"CN.GX");
            }
            xml.append("<entity id='" + dt.getString(i, "shortName") + "' tooltext='" + dt.getString(i, "area") + ":" + dt.getString(i, "count") + "\u6b21' displayValue='' color='" + Colors[temp] + "'/>");
        }
        xml.append("</data>");
        xml.append("</map>");
        return xml.toString().replace("null", "0");
    }

    private static int getColorValue(int count) {
        int[] str = new int[]{0, 100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1200, 1400, 1600, 1800, 2000, 2500, 3000, 3500, 4000, 4500, 5000, 6000, 7000, 8000, 9000, 10000};
        for (int i = 0; i < str.length; ++i) {
            if (!(i >= 1 ? str[i - 1] <= count && count <= str[i] : count <= str[i])) continue;
            return i;
        }
        return 26;
    }
}

