/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.stat;

import com.sobey.bsp.cms.stat.IPEntry;
import com.sobey.bsp.cms.stat.IPSeeker;
import com.sobey.bsp.cms.stat.Utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPSeeker {
    private static final Logger log = LoggerFactory.getLogger(IPSeeker.class);
    private static final String IP_FILE = Thread.currentThread().getContextClassLoader().getResource("iprang.dat").getPath();
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte AREA_FOLLOWED = 1;
    private static final byte NO_AREA = 2;
    private Hashtable ipCache = new Hashtable();
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private static IPSeeker instance = new IPSeeker();
    private long ipBegin;
    private long ipEnd;
    private IPLocation loc = new IPLocation(this);
    private byte[] buf = new byte[100];
    private byte[] b4 = new byte[4];
    private byte[] b3 = new byte[3];

    private IPSeeker() {
        log.info("IPFilePath:{}", (Object)IP_FILE);
        try {
            this.ipFile = new RandomAccessFile(IP_FILE, "r");
        }
        catch (FileNotFoundException e) {
            log.error("\u521d\u59cb\u5316\u5f02\u5e38\uff1a", (Throwable)e);
            this.ipFile = null;
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                log.error("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u683c\u5f0f\u6709\u9519\u8bef\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528,", (Throwable)e);
                this.ipFile = null;
            }
        }
    }

    public static IPSeeker getInstance() {
        return instance;
    }

    public List getIPEntriesDebug(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        long endOffset = this.ipEnd + 4L;
        for (long offset = this.ipBegin + 4L; offset <= endOffset; offset += 7L) {
            long temp = this.readLong3(offset);
            if (temp == -1L) continue;
            IPLocation loc = this.getIPLocation(temp);
            if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
            IPEntry entry = new IPEntry();
            entry.country = loc.country;
            entry.area = loc.area;
            this.readIP(offset - 4L, this.b4);
            entry.beginIp = Utils.getIpStringFromBytes((byte[])this.b4);
            this.readIP(temp, this.b4);
            entry.endIp = Utils.getIpStringFromBytes((byte[])this.b4);
            ret.add(entry);
        }
        return ret;
    }

    public List getIPEntries(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            for (int offset = (int)this.ipBegin + 4; offset <= endOffset; offset += 7) {
                int temp = this.readInt3(offset);
                if (temp == -1) continue;
                IPLocation loc = this.getIPLocation(temp);
                if (loc.country.indexOf(s) == -1 && loc.area.indexOf(s) == -1) continue;
                IPEntry entry = new IPEntry();
                entry.country = loc.country;
                entry.area = loc.area;
                this.readIP(offset - 4, this.b4);
                entry.beginIp = Utils.getIpStringFromBytes((byte[])this.b4);
                this.readIP(temp, this.b4);
                entry.endIp = Utils.getIpStringFromBytes((byte[])this.b4);
                ret.add(entry);
            }
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6ip\u8303\u56f4\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return ret;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = Utils.getIpStringFromBytes((byte[])ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = (IPLocation)this.ipCache.get(ipStr);
            return loc.country;
        }
        IPLocation loc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.country;
    }

    public String getCountry(String ip) {
        return this.getCountry(Utils.getIpByteArrayFromString((String)ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "\u9519\u8bef\u7684IP\u6570\u636e\u5e93\u6587\u4ef6";
        }
        String ipStr = Utils.getIpStringFromBytes((byte[])ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation loc = (IPLocation)this.ipCache.get(ipStr);
            return loc.area;
        }
        IPLocation loc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, loc.getCopy());
        return loc.area;
    }

    public String getArea(String ip) {
        return this.getArea(Utils.getIpByteArrayFromString((String)ip));
    }

    private IPLocation getIPLocation(byte[] ip) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset);
        }
        if (info == null) {
            info = new IPLocation(this);
            info.country = "\u672a\u77e5\u56fd\u5bb6";
            info.area = "\u672a\u77e5\u5730\u533a";
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        for (int i = 0; i < 4; ++i) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.country = this.readString(this.readLong3());
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.country = this.readString(countryOffset);
                }
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            } else if (b == 2) {
                this.loc.country = this.readString(this.readLong3());
                this.loc.area = this.readArea(offset + 8L);
            } else {
                this.loc.country = this.readString(this.ipFile.getFilePointer() - 1L);
                this.loc.area = this.readArea(this.ipFile.getFilePointer());
            }
            return this.loc;
        }
        catch (IOException e) {
            log.error("\u8fd4\u56de\u4e00\u4e2aIPLocation\u7ed3\u6784", (Throwable)e);
            return null;
        }
    }

    private IPLocation getIPLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.country = this.readString(this.readInt3());
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.country = this.readString(countryOffset);
            }
            this.loc.area = this.readArea(this.mbb.position());
        } else if (b == 2) {
            this.loc.country = this.readString(this.readInt3());
            this.loc.area = this.readArea(offset + 8);
        } else {
            this.loc.country = this.readString(this.mbb.position() - 1);
            this.loc.area = this.readArea(this.mbb.position());
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buf[i] = this.ipFile.readByte();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return Utils.getString((byte[])this.buf, (int)0, (int)i, (String)"GBK");
            }
        }
        catch (IOException e) {
            log.error("\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return Utils.getString((byte[])this.buf, (int)0, (int)i, (String)"GBK");
            }
        }
        catch (IllegalArgumentException e) {
            log.error("\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
        return "";
    }

    public String getAddress(String ip) {
        String country = this.getCountry(ip).equals(" CZ88.NET") ? "" : this.getCountry(ip);
        String area = this.getArea(ip).equals(" CZ88.NET") ? "" : this.getArea(ip);
        String address = country + " " + area;
        return address.trim();
    }
}

