/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.cms.stat;

import com.sobey.bsp.framework.data.DataRow;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.NumberUtil;
import com.sobey.bsp.framework.utility.StringFormat;
import com.sobey.bsp.framework.utility.StringUtil;
import java.util.Date;
import org.apache.commons.lang.ArrayUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportUtil {
    private static Mapx StartDateMap = new Mapx();

    public static int getTotalStatDays(long siteID) {
        int c = new Double(Math.ceil((double)(System.currentTimeMillis() - ReportUtil.getStartStatDate((long)siteID).getTime()) * 1.0 / 8.64E7)).intValue();
        if (c == 0) {
            c = 1;
        }
        return c;
    }

    public static Date getStartStatDate(long siteID) {
        Date date = (Date)StartDateMap.get((Object)new Long(siteID));
        if (date == null) {
            QueryBuilder qb = new QueryBuilder("select * from SCMS_Statitem where SiteID=? and Type='Global' and SubType='PV' order by Period", siteID);
            DataTable dt = qb.executePagedDataTable(1, 0);
            if (dt.getRowCount() == 0) {
                return new Date();
            }
            for (int i = 5; i < dt.getColCount(); ++i) {
                if (dt.getInt(0, i) == 0) continue;
                date = DateUtil.parse((String)(dt.getString(0, "Period") + ((i -= 4) > 9 ? String.valueOf(i) : new StringBuffer("0").append(i).toString())), (String)"yyyyMMdd");
                StartDateMap.put((Object)new Long(siteID), (Object)date);
                break;
            }
        }
        return date;
    }

    public static DataTable toDateTable(DataTable src, Date start, Date end) {
        int i;
        if (src == null) {
            return null;
        }
        if (start.getTime() > end.getTime()) {
            Date tmp = start;
            start = end;
            end = tmp;
        }
        String period1 = DateUtil.toString((Date)start, (String)"yyyyMM");
        String period2 = DateUtil.toString((Date)end, (String)"yyyyMM");
        int day1 = Integer.parseInt(DateUtil.toString((Date)start, (String)"dd"));
        int day2 = Integer.parseInt(DateUtil.toString((Date)end, (String)"dd"));
        Mapx map = new Mapx();
        for (int i2 = 0; i2 < src.getRowCount(); ++i2) {
            String subtype = src.getString(i2, "SubType");
            if (map.containsKey((Object)subtype)) continue;
            map.put((Object)subtype, (Object)"");
        }
        Object[] subtypes = map.keyArray();
        DataTable dt = new DataTable();
        dt.insertColumn("Date");
        for (i = 0; i < subtypes.length; ++i) {
            dt.insertColumn(subtypes[i].toString());
        }
        map = new Mapx();
        for (i = 0; i < src.getRowCount(); ++i) {
            Mapx m;
            String key;
            int d;
            int j;
            int colStart;
            String period = src.getString(i, "Period");
            String subtype = src.getString(i, "SubType");
            if (period.equals(period1)) {
                colStart = src.getColCount() - 1;
                if (period.equals(period2)) {
                    colStart = 4 + day2;
                }
                if (colStart > DateUtil.getMaxDayOfMonth((Date)start) + 4) {
                    colStart = DateUtil.getMaxDayOfMonth((Date)start) + 4;
                }
                for (j = colStart; j >= 4 + day1; --j) {
                    d = j - 4;
                    key = period + (d > 9 ? String.valueOf(d) : new StringBuffer("0").append(d).toString());
                    if (!map.containsKey((Object)key)) {
                        map.put((Object)key, (Object)new Mapx());
                    }
                    if ((m = (Mapx)map.get((Object)key)).containsKey((Object)subtype)) {
                        m.put((Object)subtype, m.getInt((Object)subtype) + src.getInt(i, j));
                        continue;
                    }
                    m.put((Object)subtype, src.getInt(i, j));
                }
                continue;
            }
            if (period.equals(period2)) {
                int colEnd = 5;
                if (period.equals(period1)) {
                    colEnd = day1;
                }
                if ((colStart = 4 + day2) > DateUtil.getMaxDayOfMonth((Date)end) + 4) {
                    colStart = DateUtil.getMaxDayOfMonth((Date)end) + 4;
                }
                for (int j2 = colStart; j2 >= colEnd; --j2) {
                    d = j2 - 4;
                    key = period + (d > 9 ? String.valueOf(d) : new StringBuffer("0").append(d).toString());
                    if (!map.containsKey((Object)key)) {
                        map.put((Object)key, (Object)new Mapx());
                    }
                    if ((m = (Mapx)map.get((Object)key)).containsKey((Object)subtype)) {
                        m.put((Object)subtype, m.getInt((Object)subtype) + src.getInt(i, j2));
                        continue;
                    }
                    m.put((Object)subtype, src.getInt(i, j2));
                }
                continue;
            }
            colStart = src.getColCount() - 1;
            if (colStart > DateUtil.getMaxDayOfMonth((Date)DateUtil.parse((String)period, (String)"yyyyMM")) + 4) {
                colStart = DateUtil.getMaxDayOfMonth((Date)DateUtil.parse((String)period, (String)"yyyyMM")) + 4;
            }
            for (j = colStart; j > 4; --j) {
                d = j - 4;
                key = period + (d > 9 ? String.valueOf(d) : new StringBuffer("0").append(d).toString());
                if (!map.containsKey((Object)key)) {
                    map.put((Object)key, (Object)new Mapx());
                }
                if ((m = (Mapx)map.get((Object)key)).containsKey((Object)subtype)) {
                    m.put((Object)subtype, m.getInt((Object)subtype) + src.getInt(i, j));
                    continue;
                }
                m.put((Object)subtype, src.getInt(i, j));
            }
        }
        Object[] ks = map.keyArray();
        int[] totals = new int[subtypes.length];
        for (int i3 = 0; i3 < ks.length; ++i3) {
            dt.insertRow(new DataRow(null, null));
            String date = ks[i3].toString();
            dt.set(0, "Date", (Object)(date.substring(0, 4) + "-" + date.substring(4, 6) + "-" + date.substring(6)));
            for (int j = 0; j < subtypes.length; ++j) {
                String count = ((Mapx)map.get((Object)date)).getString(subtypes[j]);
                if (StringUtil.isNotEmpty((String)count)) {
                    dt.set(0, subtypes[j].toString(), (Object)count);
                    int n = j;
                    totals[n] = totals[n] + Integer.parseInt(count);
                    continue;
                }
                dt.set(0, subtypes[j].toString(), (Object)"0");
            }
        }
        dt.insertRow(new DataRow(null, null));
        dt.set(0, "Date", (Object)"\u603b\u8ba1");
        for (int j = 0; j < subtypes.length; ++j) {
            dt.set(0, subtypes[j].toString(), totals[j]);
        }
        return dt;
    }

    public static DataTable toItemTable(DataTable src, Date start, Date end) {
        return ReportUtil.toItemTable((DataTable)src, (Date)start, (Date)end, (boolean)false);
    }

    public static DataTable toItemTable(DataTable src, Date start, Date end, boolean trimEmpty) {
        int count;
        int i;
        String period1 = DateUtil.toString((Date)start, (String)"yyyyMM");
        String period2 = DateUtil.toString((Date)end, (String)"yyyyMM");
        int day1 = Integer.parseInt(DateUtil.toString((Date)start, (String)"dd"));
        int day2 = Integer.parseInt(DateUtil.toString((Date)end, (String)"dd"));
        Mapx itemMap = new Mapx();
        Mapx subtypeMap = new Mapx();
        for (int i2 = 0; i2 < src.getRowCount(); ++i2) {
            String subtype = src.getString(i2, "SubType");
            if (subtypeMap.containsKey((Object)subtype)) continue;
            subtypeMap.put((Object)subtype, (Object)"");
        }
        Object[] subtypes = subtypeMap.keyArray();
        for (int i3 = 0; i3 < src.getRowCount(); ++i3) {
            String item = src.getString(i3, "Item");
            if (itemMap.containsKey((Object)item)) continue;
            Mapx map = new Mapx();
            for (int j = 0; j < subtypes.length; ++j) {
                map.put(subtypes[j], (Object)new Integer(0));
            }
            itemMap.put((Object)item, (Object)map);
        }
        DataTable dt = new DataTable();
        dt.insertColumn("Item");
        for (i = 0; i < subtypes.length; ++i) {
            dt.insertColumn(subtypes[i].toString());
        }
        for (i = 0; i < src.getRowCount(); ++i) {
            Mapx map;
            int j;
            int colStart;
            String period = src.getString(i, "Period");
            String subtype = src.getString(i, "SubType");
            String item = src.getString(i, "Item");
            if (period.equals(period1)) {
                colStart = src.getColCount() - 1;
                if (period.equals(period2)) {
                    colStart = 4 + day2;
                }
                for (j = colStart; j >= 4 + day1; --j) {
                    count = Integer.parseInt(src.getString(i, j));
                    map = (Mapx)itemMap.get((Object)item);
                    map.put((Object)subtype, (Object)new Integer((Integer)map.get((Object)subtype) + count));
                }
                continue;
            }
            if (period.equals(period2)) {
                int colEnd = 5;
                if (period.equals(period1)) {
                    colEnd = day1;
                }
                for (int j2 = colStart = 4 + day2; j2 >= colEnd; --j2) {
                    count = Integer.parseInt(src.getString(i, j2));
                    map = (Mapx)itemMap.get((Object)item);
                    map.put((Object)subtype, (Object)new Integer((Integer)map.get((Object)subtype) + count));
                }
                continue;
            }
            for (j = colStart = src.getColCount() - 1; j > 4; --j) {
                count = Integer.parseInt(src.getString(i, j));
                map = (Mapx)itemMap.get((Object)item);
                map.put((Object)subtype, (Object)new Integer((Integer)map.get((Object)subtype) + count));
            }
        }
        Object[] ks = itemMap.keyArray();
        for (int i4 = 0; i4 < ks.length; ++i4) {
            int count2;
            String item = ks[i4].toString();
            Mapx map = (Mapx)itemMap.get((Object)item);
            if (subtypes.length == 1 && trimEmpty && (count2 = map.getInt(subtypes[0])) == 0) continue;
            dt.insertRow(new DataRow(null, null));
            dt.set(0, "Item", (Object)item);
            for (int j = 0; j < subtypes.length; ++j) {
                count = map.getInt(subtypes[j]);
                dt.set(0, subtypes[j].toString(), (Object)new Integer(count));
            }
        }
        return dt;
    }

    public static void prepareForPie3D(DataTable dt, int count, double rate) {
        int i;
        if (dt == null || dt.getRowCount() == 0) {
            return;
        }
        int total = 0;
        for (int i2 = 0; i2 < dt.getRowCount(); ++i2) {
            total += dt.getInt(i2, 1);
        }
        int other = 0;
        for (i = dt.getRowCount() - 1; i >= 0; --i) {
            if (!((double)dt.getInt(i, 1) * 100.0 / (double)total < rate)) continue;
            other += dt.getInt(i, 1);
            dt.deleteRow(i);
        }
        dt.sort(dt.getDataColumn(1).getColumnName());
        for (i = dt.getRowCount() - 1; i >= count; --i) {
            other += dt.getInt(i, 1);
            dt.deleteRow(i);
        }
        dt.insertRow(new Object[]{"\u5176\u4ed6", new Integer(other)});
    }

    public static void prepareForPie3D(DataTable dt, double rate) {
        ReportUtil.prepareForPie3D((DataTable)dt, (int)Integer.MAX_VALUE, (double)rate);
    }

    public static void prepareForPie3D(DataTable dt, int itemCount) {
        ReportUtil.prepareForPie3D((DataTable)dt, (int)itemCount, (double)0.0);
    }

    public static void computeRate(DataTable dt, String columName, String destColumnName) {
        int i;
        dt.insertColumn(destColumnName);
        int total = 0;
        for (i = 0; i < dt.getRowCount(); ++i) {
            total += Integer.parseInt(dt.getString(i, columName));
        }
        for (i = 0; i < dt.getRowCount(); ++i) {
            int count = Integer.parseInt(dt.getString(i, columName));
            dt.set(i, destColumnName, (Object)new Double(NumberUtil.round((double)((double)count * 100.0 / (double)total), (int)2)));
        }
    }

    public static void addSuffix(DataTable dt, String columName, String suffix) {
        for (int i = 0; i < dt.getRowCount(); ++i) {
            String r = dt.getString(i, columName);
            if (!StringUtil.isNotEmpty((String)r)) continue;
            dt.set(i, columName, (Object)(r + suffix));
        }
    }

    public static void addTotal(DataTable dt, String[] digitColumns) {
        for (int i = digitColumns.length - 1; i >= 0; --i) {
            if (dt.getDataColumn(digitColumns[i]) != null) continue;
            digitColumns = (String[])ArrayUtils.remove((Object[])digitColumns, (int)i);
        }
        int[] totals = new int[digitColumns.length];
        for (int i = 0; i < dt.getRowCount(); ++i) {
            for (int j = 0; j < digitColumns.length; ++j) {
                int n = j;
                totals[n] = totals[n] + dt.getInt(i, digitColumns[j]);
            }
        }
        if (dt.getRowCount() > 0) {
            dt.insertRow(new DataRow(null, null), 0);
            dt.set(0, 0, (Object)"\u603b\u8ba1");
            for (int j = 0; j < digitColumns.length; ++j) {
                dt.set(0, digitColumns[j], totals[j]);
            }
        }
    }

    public static void addTrend(DataTable dt, String type, String subtype, String start, String end) {
        dt.insertColumn("Trend");
        for (int i = 0; i < dt.getRowCount(); ++i) {
            StringFormat sf = new StringFormat("<a href='javascript:void(0);' onclick=\"showTrend('?','?','?','?','?')\">\u65f6\u95f4\u8d8b\u52bf</a>");
            sf.add(type);
            sf.add(subtype);
            sf.add(dt.getString(i, "Item"));
            sf.add(start);
            sf.add(end);
            dt.set(i, "Trend", (Object)sf.toString());
        }
    }

    public static void addTrend(DataTable dt, String type, String subtype) {
        dt.insertColumn("Trend");
        for (int i = 0; i < dt.getRowCount(); ++i) {
            StringFormat sf = new StringFormat("<a href='javascript:void(0);' onclick=\"showTrend('?','?','?')\">\u65f6\u95f4\u8d8b\u52bf</a>");
            sf.add(type);
            sf.add(subtype);
            sf.add(dt.getString(i, "Item"));
            dt.set(i, "Trend", (Object)sf.toString());
        }
    }
}

