/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework;

import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.collection.Mapx;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.license.IProduct;
import com.sobey.bsp.framework.security.EncryptUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static Object mutex = new Object();
    private static String configFileName;
    protected static Mapx<String, String> configMap;
    private static final String SEPARATOR = "_";
    private static Map<String, String> siteIdTypeAndValueMap;
    private static long LastUpdateTime;
    private static long RefershPeriod;
    public static int OnlineUserCount;
    public static int LoginUserCount;
    public static boolean isDatabaseConfiged;
    public static boolean isAllowLogin;
    private static String AppCode;
    private static String AppName;
    private static float MainVersion;
    private static float MinorVersion;
    private static boolean ComplexDepolyMode;
    public static int ServletMajorVersion;
    public static int ServletMinorVersion;

    public static void readConfigFileName(String fileName) {
        configFileName = fileName;
        Config.init();
    }

    protected static void init() {
        if (!configMap.containsKey((Object)"System.JavaVersion")) {
            Config.initConfig();
            configMap.put((Object)"App.ContextRealPath", (Object)Config.getContextRealPath());
            configFileName = Config.getRealConfigFileName();
            File file = new File(configFileName);
            if (!file.exists()) {
                LogUtil.warn((Object)("\u914d\u7f6e\u6587\u4ef6" + configFileName + "\u672a\u627e\u5230!"));
                isDatabaseConfiged = false;
            }
            configMap.put((Object)"System.JavaVersion", (Object)System.getProperty("java.version"));
            configMap.put((Object)"System.JavaVendor", (Object)System.getProperty("java.vendor"));
            configMap.put((Object)"System.JavaHome", (Object)System.getProperty("java.home"));
            configMap.put((Object)"System.OSPatchLevel", (Object)System.getProperty("sun.os.patch.level"));
            configMap.put((Object)"System.OSArch", (Object)System.getProperty("os.arch"));
            configMap.put((Object)"System.OSVersion", (Object)System.getProperty("os.version"));
            configMap.put((Object)"System.OSName", (Object)System.getProperty("os.name"));
            configMap.put((Object)"System.OSUserLanguage", (Object)System.getProperty("user.language"));
            configMap.put((Object)"System.OSUserName", (Object)System.getProperty("user.name"));
            configMap.put((Object)"System.LineSeparator", (Object)System.getProperty("line.separator"));
            configMap.put((Object)"System.FileSeparator", (Object)System.getProperty("file.separator"));
            configMap.put((Object)"System.FileEncoding", (Object)System.getProperty("file.encoding"));
            if (configMap.containsKey((Object)"App.Code")) {
                AppCode = configMap.getString((Object)"App.Code");
                AppName = configMap.getString((Object)"App.Name");
            }
            ComplexDepolyMode = "true".equals(configMap.get((Object)"App.ComplexDeployMode"));
            Config.loadDBConfig();
            LogUtil.info((Object)("----" + Config.getAppCode() + "(" + Config.getAppName() + "): Config Initialized----"));
        }
    }

    public static void loadConfig() {
        configMap.remove((Object)"System.JavaVersion");
        Config.initConfig();
        Config.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig() {
        Object object = mutex;
        synchronized (object) {
            SAXReader reader = new SAXReader(false);
            try {
                configFileName = Config.getRealConfigFileName();
                File f = new File(configFileName);
                if (!f.exists()) {
                    LogUtil.warn((Object)("\u914d\u7f6e\u6587\u4ef6" + configFileName + "\u672a\u627e\u5230!"));
                    isDatabaseConfiged = false;
                    return;
                }
                Document doc = reader.read(f);
                Element root = doc.getRootElement();
                Element application = root.element("application");
                List elements = application.elements();
                for (int i = 0; i < elements.size(); ++i) {
                    Element ele = (Element)elements.get(i);
                    configMap.put((Object)("App." + ele.attributeValue("name")), (Object)ele.getTextTrim());
                }
                Element databases = root.element("databases");
                if (databases != null) {
                    List dbs = databases.elements();
                    for (int i = 0; i < dbs.size(); ++i) {
                        Element ele = (Element)dbs.get(i);
                        String dbname = ele.attributeValue("name").trim();
                        List configs = ele.elements();
                        for (int k = 0; k < configs.size(); ++k) {
                            ele = (Element)configs.get(k);
                            String attr = ele.attributeValue("name");
                            String value = ele.getTextTrim();
                            if (attr.equalsIgnoreCase("Password") && value.startsWith("$KEY")) {
                                value = EncryptUtil.decrypt3DES((String)value.substring(4), (String)"27jrWz3sxrVbR+pnyg6j");
                            }
                            configMap.put((Object)("Database." + dbname + "." + attr), (Object)value);
                        }
                    }
                    isDatabaseConfiged = true;
                } else {
                    isDatabaseConfiged = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                isDatabaseConfiged = false;
            }
        }
    }

    private static void loadDBConfig() {
        if (configMap.get((Object)"Database.Default.Type") == null || !"true".equals(configMap.get((Object)"App.ExistPlatformDB"))) {
            return;
        }
        try {
            DataTable dataTable = new QueryBuilder("select type,value,siteId from scms_config").executeDataTable();
            for (int i = 0; dataTable != null && i < dataTable.getRowCount(); ++i) {
                long siteId = dataTable.getLong(i, "siteId");
                if (siteId == 0L) {
                    configMap.put((Object)dataTable.getString(i, 0), (Object)dataTable.getString(i, 1));
                    continue;
                }
                siteIdTypeAndValueMap.put(siteId + "_" + dataTable.getString(i, "type"), dataTable.getString(i, "value"));
            }
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u914d\u7f6e\u9047\u5230\u5f02\u5e38", (Throwable)e);
        }
    }

    public static void update() {
        Config.loadDBConfig();
    }

    protected static String getConfigFileName() {
        return configFileName;
    }

    protected static void setConfigFileName(String fileName) {
        configFileName = fileName;
    }

    public static String getValue(String configName) {
        Config.init();
        return (String)configMap.get((Object)configName);
    }

    public static String getValue(long siteId, String configName) {
        Config.init();
        String value = (String)siteIdTypeAndValueMap.get(siteId + "_" + configName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return (String)configMap.get((Object)configName);
    }

    public static String getValue(String configName, String defaultValue) {
        String value = Config.getValue((String)configName);
        if (StringUtil.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static void setValue(String configName, String configValue) {
        Config.init();
        configMap.put((Object)configName, (Object)configValue);
    }

    public static String getClassesPath() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("framework.xml");
        if (url == null) {
            throw new RuntimeException("\u672a\u627e\u5230framework.xml");
        }
        try {
            String path = URLDecoder.decode(url.getPath(), Config.getFileEncode());
            if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                } else if (path.startsWith("file:/")) {
                    path = path.substring(6);
                }
            } else if (path.startsWith("file:/")) {
                path = path.substring(5);
            }
            return path.substring(0, path.lastIndexOf("/") + 1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContextRealPath() {
        String str;
        if (configMap != null && (str = (String)configMap.get((Object)"App.ContextRealPath")) != null) {
            return str;
        }
        String path = Config.getClassesPath();
        int index = path.indexOf("WEB-INF");
        if (index > 0) {
            path = path.substring(0, index);
        }
        return path;
    }

    public static String getRealConfigFileName() {
        String path = Config.getClassesPath();
        return path == null ? path : Config.getClassesPath() + "framework.xml";
    }

    public static String getContextPath() {
        if (ComplexDepolyMode) {
            String path = (String)User.getValue((Object)"App.ContextPath");
            if (StringUtil.isEmpty((String)path)) {
                path = Config.getValue((String)"App.ContextPath");
            }
            return path;
        }
        return Config.getValue((String)"App.ContextPath");
    }

    public static String getLogLevel() {
        return Config.getValue((String)"App.LogLevel");
    }

    private static void initProduct() {
        if (AppCode == null) {
            try {
                IProduct p = (IProduct)Class.forName("com.sobey.bsp.Product").newInstance();
                AppCode = p.getAppCode();
                AppName = p.getAppName();
                MainVersion = p.getMainVersion();
                MinorVersion = p.getMinorVersion();
                if (configMap.get((Object)"App.Code") != null) {
                    AppCode = configMap.getString((Object)"App.Code");
                    AppName = configMap.getString((Object)"App.Name");
                }
            }
            catch (Exception e) {
                AppCode = "vms";
                AppName = "\u89c6\u97f3\u9891\u4e91\u670d\u52a1\u7cfb\u7edf";
            }
        }
    }

    public static String getAppCode() {
        Config.initProduct();
        return AppCode;
    }

    public static String getAppName() {
        Config.initProduct();
        return AppName;
    }

    public static float getMainVersion() {
        Config.initProduct();
        return MainVersion;
    }

    public static float getMinorVersion() {
        Config.initProduct();
        return MinorVersion;
    }

    public static boolean isDebugMode() {
        return "true".equalsIgnoreCase(Config.getValue((String)"App.DebugMode"));
    }

    public static String getJavaVersion() {
        return Config.getValue((String)"System.JavaVersion");
    }

    public static String getJavaVendor() {
        return Config.getValue((String)"System.JavaVendor");
    }

    public static String getJavaHome() {
        return Config.getValue((String)"System.JavaHome");
    }

    public static String getContainerInfo() {
        return Config.getValue((String)"System.ContainerInfo");
    }

    public static String getContainerVersion() {
        String str = Config.getValue((String)"System.ContainerInfo");
        if (str.indexOf("/") > 0) {
            return str.substring(str.lastIndexOf("/") + 1);
        }
        return "0";
    }

    public static String getOSName() {
        return Config.getValue((String)"System.OSName");
    }

    public static String getOSPatchLevel() {
        return Config.getValue((String)"System.OSPatchLevel");
    }

    public static String getOSArch() {
        return Config.getValue((String)"System.OSArch");
    }

    public static String getOSVersion() {
        return Config.getValue((String)"System.OSVersion");
    }

    public static String getOSUserLanguage() {
        return Config.getValue((String)"System.OSUserLanguage");
    }

    public static String getOSUserName() {
        return Config.getValue((String)"System.OSUserName");
    }

    public static String getLineSeparator() {
        return Config.getValue((String)"System.LineSeparator");
    }

    public static String getFileSeparator() {
        return Config.getValue((String)"System.FileSeparator");
    }

    public static String getFileEncode() {
        return System.getProperty("file.encoding");
    }

    public static int getLoginUserCount() {
        return LoginUserCount;
    }

    public static int getOnlineUserCount() {
        return OnlineUserCount;
    }

    public static boolean isDB2() {
        return DBConnPool.getDBConnConfig().DBType.equals("DB2");
    }

    public static boolean isOracle() {
        return DBConnPool.getDBConnConfig().DBType.equals("ORACLE");
    }

    public static boolean isMysql() {
        return DBConnPool.getDBConnConfig().DBType.equals("MYSQL");
    }

    public static boolean isSQLServer() {
        return DBConnPool.getDBConnConfig().DBType.equals("MSSQL");
    }

    public static boolean isTomcat() {
        if (StringUtil.isEmpty((String)Config.getContainerInfo())) {
            Config.getJBossInfo();
        }
        return Config.getContainerInfo().toLowerCase().indexOf("tomcat") >= 0;
    }

    protected static void getJBossInfo() {
        String jboss = System.getProperty("jboss.home.dir");
        if (StringUtil.isNotEmpty((String)jboss)) {
            try {
                Class<?> c = Class.forName("org.jboss.Version");
                Method m = c.getMethod("getInstance", null);
                Object o = m.invoke(null, null);
                m = c.getMethod("getMajor", null);
                Object major = m.invoke(o, null);
                m = c.getMethod("getMinor", null);
                Object minor = m.invoke(o, null);
                m = c.getMethod("getRevision", null);
                Object revision = m.invoke(o, null);
                m = c.getMethod("getTag", null);
                Object tag = m.invoke(o, null);
                configMap.put((Object)"System.ContainerInfo", (Object)("JBoss/" + major + "." + minor + "." + revision + "." + tag));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isJboss() {
        if (StringUtil.isEmpty((String)Config.getContainerInfo())) {
            Config.getJBossInfo();
        }
        return Config.getContainerInfo().toLowerCase().indexOf("jboss") >= 0;
    }

    public static boolean isWeblogic() {
        return Config.getContainerInfo().toLowerCase().indexOf("weblogic") >= 0;
    }

    public static boolean isWebSphere() {
        return Config.getContainerInfo().toLowerCase().indexOf("websphere") >= 0;
    }

    public static boolean isComplexDepolyMode() {
        return ComplexDepolyMode;
    }

    public static boolean isDebugLoglevel() {
        return "Debug".equalsIgnoreCase(Config.getLogLevel());
    }

    public static String getLoginPage() {
        String str = configMap.getString((Object)"App.LoginPage");
        if (StringUtil.isNotEmpty((String)str)) {
            return str;
        }
        return "Login.jsp";
    }

    public static Mapx<String, String> getMapx() {
        return configMap;
    }

    static {
        configMap = new Mapx();
        siteIdTypeAndValueMap = new HashMap();
        RefershPeriod = 60000L;
        OnlineUserCount = 0;
        LoginUserCount = 0;
        isAllowLogin = true;
        AppCode = null;
        AppName = null;
        MainVersion = 1.0f;
        MinorVersion = 0.0f;
        ComplexDepolyMode = false;
    }
}

