/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.CookieImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class CookieImpl {
    public ArrayList list = new ArrayList();
    public static final String CookieCharset = "UTF-8";

    public CookieImpl() {
    }

    public CookieImpl(ServletRequest request) {
        Cookie[] cookies = ((HttpServletRequest)request).getCookies();
        if (cookies == null) {
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            CookieObject c = new CookieObject();
            c.name = cookie.getName();
            try {
                c.value = URLDecoder.decode(cookie.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            c.domain = cookie.getDomain();
            c.maxAge = cookie.getMaxAge();
            c.path = cookie.getPath();
            c.path = CookieImpl.normalizePath((String)c.path);
            c.secure = cookie.getSecure();
            c.comment = cookie.getComment();
            c.version = cookie.getVersion();
            this.list.add(c);
        }
    }

    public void setCookie(String name, String value, String domain, int maxAge, String path, boolean secure, String comment) {
        path = CookieImpl.normalizePath((String)path);
        for (int i = 0; i < this.list.size(); ++i) {
            CookieObject c = (CookieObject)this.list.get(i);
            if (!c.name.equals(name) || c.domain != null && !c.domain.equals(domain) || c.path != null && !c.path.equals(path) || c.secure != secure || c.value == null || c.value.equals(value)) continue;
            c.changed = true;
            c.value = value;
            c.comment = comment;
            return;
        }
        CookieObject c = new CookieObject();
        c.name = name;
        c.value = value;
        c.comment = comment;
        c.domain = domain;
        c.maxAge = maxAge;
        c.path = path;
        c.secure = secure;
        c.version = 0;
        c.changed = true;
        this.list.add(c);
    }

    public CookieObject[] getArray() {
        CookieObject[] cos = new CookieObject[this.list.size()];
        for (int i = 0; i < cos.length; ++i) {
            cos[i] = (CookieObject)this.list.get(i);
        }
        return cos;
    }

    public void setCookie(String name, String value, int maxAge) {
        this.setCookie(name, value, null, maxAge, CookieImpl.getDefaultPath(), false, null);
    }

    public void setCookie(String name, String value) {
        this.setCookie(name, value, null, -1141367296, CookieImpl.getDefaultPath(), false, null);
    }

    public void setCookie(String name, String value, String path) {
        this.setCookie(name, value, path, -1141367296, CookieImpl.getDefaultPath(), false, null);
    }

    public void setCookie(String name, String value, String path, int maxAge) {
        this.setCookie(name, value, path, maxAge, CookieImpl.getDefaultPath(), false, null);
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    private static String getDefaultPath() {
        String path = Config.getContextPath();
        return CookieImpl.normalizePath((String)path);
    }

    private static String normalizePath(String path) {
        if (path == null) {
            path = "/";
        }
        if (path.endsWith("/") && !path.equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public String getCookie(String name, String path) {
        path = CookieImpl.normalizePath((String)path);
        ArrayList<String> arr = new ArrayList<String>();
        for (int i = 0; i < this.list.size(); ++i) {
            CookieObject c = (CookieObject)this.list.get(i);
            if (!c.name.equals(name)) continue;
            if (path != null) {
                if (!c.path.equals(path)) continue;
                arr.add(c.value);
                continue;
            }
            arr.add(c.value);
        }
        if (arr.size() == 0) {
            return null;
        }
        if (arr.size() == 1) {
            return arr.get(0) == null ? null : String.valueOf(arr.get(0));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.size(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            if (arr.get(i) == null) {
                sb.append("");
                continue;
            }
            sb.append(arr.get(i));
        }
        return sb.toString();
    }

    public void writeToResponse(HttpServletRequest request, HttpServletResponse response) {
        try {
            for (int j = 0; j < this.list.size(); ++j) {
                CookieObject co = (CookieObject)this.list.get(j);
                if (!co.changed) continue;
                Cookie[] cs = request.getCookies();
                boolean flag = true;
                for (int i = 0; i < cs.length; ++i) {
                    String path = CookieImpl.normalizePath((String)cs[i].getPath());
                    if (!cs[i].getName().equals(co.name) || path != null && !path.equals(co.path)) continue;
                    cs[i].setValue(URLEncoder.encode(co.value, "UTF-8"));
                    cs[i].setMaxAge(co.maxAge);
                    if (co.domain != null) {
                        cs[i].setDomain(co.domain);
                    }
                    response.addCookie(cs[i]);
                    flag = false;
                    break;
                }
                if (!flag) continue;
                Cookie cookie = new Cookie(co.name, URLEncoder.encode(co.value, "UTF-8"));
                cookie.setMaxAge(co.maxAge);
                cookie.setPath(co.path);
                if (co.domain != null) {
                    cookie.setDomain(co.domain);
                }
                cookie.setSecure(co.secure);
                response.addCookie(cookie);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }
}

