/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework;

import com.sobey.bsp.framework.Config;
import com.sobey.bsp.framework.Constant;
import com.sobey.bsp.framework.CookieImpl;
import com.sobey.bsp.framework.Current;
import com.sobey.bsp.framework.SessionCheck;
import com.sobey.bsp.framework.User;
import com.sobey.bsp.framework.data.DBConnConfig;
import com.sobey.bsp.framework.data.DBConnPool;
import com.sobey.bsp.framework.extend.ExtendManager;
import com.sobey.bsp.framework.utility.Errorx;
import com.sobey.bsp.framework.utility.LogUtil;
import com.sobey.bsp.framework.utility.StringUtil;
import com.sobey.bsp.platform.Login;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class MainFilter
implements Filter {
    private long uptime = 0L;
    private static String[] NoFilterPaths;

    public void init(FilterConfig config) throws ServletException {
        ServletContext sc = config.getServletContext();
        Config.configMap.put((Object)"System.ContainerInfo", (Object)sc.getServerInfo());
        Config.getJBossInfo();
        Config.ServletMajorVersion = sc.getMajorVersion();
        Config.ServletMinorVersion = sc.getMinorVersion();
        this.uptime = System.currentTimeMillis();
        Config.setValue((String)"App.Uptime", (String)("" + this.uptime));
        String paths = Config.getValue((String)"App.NoFilterPath");
        if (StringUtil.isNotEmpty((String)paths)) {
            String[] arr = paths.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String path = arr[i];
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (path.endsWith("/")) continue;
                path = path + "/";
            }
        }
        LogUtil.info((Object)("----" + Config.getAppCode() + "(" + Config.getAppName() + "): MainFilter Initialized----"));
    }

    public boolean isNoFilterPath(String url) {
        if (NoFilterPaths == null) {
            return false;
        }
        url = url + "/";
        for (int i = 0; i < NoFilterPaths.length; ++i) {
            if (url.indexOf(NoFilterPaths[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public void doFilter(ServletRequest req, ServletResponse rep, FilterChain chain) throws IOException, ServletException {
        String contextPath;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rep;
        String url = request.getServletPath();
        if (this.isNoFilterPath(url)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String currentUserName = User.getUserName();
        request.setCharacterEncoding(Constant.GlobalCharset);
        if (Config.ServletMajorVersion == 2 && Config.ServletMinorVersion == 3) {
            response.setContentType("text/html;charset=" + Constant.GlobalCharset);
        } else {
            response.setCharacterEncoding(Constant.GlobalCharset);
        }
        Current.clear();
        HttpSession session = request.getSession();
        User u = (User)session.getAttribute("_ZVING_USER");
        if (u == null) {
            Cookie[] cs;
            boolean flag = true;
            if (Config.isDebugMode() && (cs = request.getCookies()) != null) {
                for (int i = 0; i < cs.length; ++i) {
                    if (!cs[i].getName().equals("JSESSIONID") || (u = User.getCachedUser((String)cs[i].getValue())) == null) continue;
                    flag = false;
                    break;
                }
            }
            if (flag) {
                u = new User();
            }
            u.SessionID = session.getId();
        }
        session.setAttribute("_ZVING_USER", (Object)u);
        User.setCurrent((User)u);
        String databaseInfo = (String)User.getValue((Object)"databaseInfo");
        String method = request.getParameter("_ZVING_METHOD");
        if (method != null && method.contains("com.sobey.bsp.cms.account.AccountAction")) {
            databaseInfo = "";
        }
        if (StringUtil.isNotEmpty((String)databaseInfo)) {
            DBConnConfig dcc = DBConnConfig.getDBConnConfigInstance((String)databaseInfo.toString());
            DBConnPool.setCurrent((DBConnConfig)dcc);
        } else {
            DBConnPool.setCurrent((DBConnConfig)DBConnConfig.getDefaultDBConnConfigInstance());
        }
        String username = "";
        String password = "";
        CookieImpl cookie = new CookieImpl((ServletRequest)request);
        username = cookie.getCookie("LOGINUSERCOOKIEID");
        password = cookie.getCookie("LOGINUSERCOOKIEPASSWORD");
        if (StringUtil.isNotEmpty((String)username) && StringUtil.isNotEmpty((String)password) && username.equals(currentUserName)) {
            u.UserName = username;
            session.setAttribute("_ZVING_USER", (Object)u);
            User.setCurrent((User)u);
            contextPath = request.getContextPath();
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
            if (Config.isComplexDepolyMode()) {
                User.setValue((Object)"App.ContextPath", (Object)contextPath);
            }
            Config.setValue((String)"App.ContextPath", (String)contextPath);
            if (new Login().checkLogin(username, password, cookie, databaseInfo)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        if (!(contextPath = request.getContextPath()).endsWith("/")) {
            contextPath = contextPath + "/";
        }
        if (Config.isComplexDepolyMode()) {
            User.setValue((Object)"App.ContextPath", (Object)contextPath);
        }
        Config.setValue((String)"App.ContextPath", (String)contextPath);
        if (!Config.isDatabaseConfiged && url.indexOf("Install.jsp") < 0 && url.indexOf("MainServlet.jsp") < 0) {
            RequestDispatcher rd = request.getRequestDispatcher("/Install.jsp");
            rd.forward(req, rep);
            return;
        }
        Errorx.init();
        if (Config.isDebugMode()) {
            User.cacheUser((User)u);
        }
        if (url != null && url.indexOf("/MainServlet.jsp") > 0 && !url.equals("/MainServlet.jsp")) {
            RequestDispatcher rd = request.getRequestDispatcher("/MainServlet.jsp");
            rd.forward(req, rep);
            return;
        }
        SessionCheck.check((HttpServletRequest)request, (HttpServletResponse)response);
        if (!Errorx.hasDealed()) {
            LogUtil.warn((Object)"\u4e25\u91cd\uff0c\u53d1\u73b0\u672a\u5904\u7406\u7684\u9519\u8bef\uff01");
            Errorx.printString();
        }
        if (ExtendManager.hasAction((String)"AfterMainFilter")) {
            ExtendManager.executeAll((String)"AfterMainFilter", (Object[])new Object[]{request, response, chain});
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (Current.getPage() != null) {
            Current.getPage().getCookie().writeToResponse(request, response);
        }
    }

    public void destroy() {
    }
}

