/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework;

import com.sobey.bsp.framework.utility.DateUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerifyRule {
    public static final String F_String = "String";
    public static final String F_Any = "Any";
    public static final String F_Number = "Number";
    public static final String F_Date = "Date";
    public static final String F_Time = "Time";
    public static final String F_DateTime = "DateTime";
    public static final String F_Year = "Year";
    public static final String F_Month = "Month";
    public static final String F_Day = "Day";
    public static final String F_Int = "Int";
    public static final String F_DigitChar = "DigitChar";
    public static final String F_AsciiChar = "AsciiChar";
    public static final String F_LetterChar = "LetterChar";
    public static final String F_UpperChar = "UpperChar";
    public static final String F_LowerChar = "LowerChar";
    public static final String F_NotNull = "NotNull";
    public static final String F_Email = "Email";
    public static final String F_Code = "Code";
    public static final String F_HalfChar = "HalfChar";
    public static final String F_FullChar = "FullChar";
    public static final String O_Add = "&&";
    public static final String O_Or = "||";
    public static final String O_Not = "!";
    public static final String A_Format = "Format";
    public static final String A_RegFormat = "RegFormat";
    public static final String A_Max = "Max";
    public static final String A_Min = "Min";
    public static final String A_Len = "Length";
    private static final String regEmail = "^[_\\-a-z0-9A-Z]*?[\\._\\-a-z0-9]*?[a-z0-9]+@[a-z0-9]+[a-z0-9\\-]*?[a-z0-9]+\\.[\\.a-z0-9]*$";
    private static Pattern patternEmail = null;
    private String Rule;
    private String[] Features;
    private ArrayList Messages;

    public VerifyRule() {
    }

    public VerifyRule(String rule) {
        this.Rule = rule;
    }

    public boolean verify(String value) {
        this.Messages = new ArrayList();
        this.Features = this.Rule.split("\\&\\&");
        boolean sqlFlag = true;
        boolean verifyFlag = true;
        try {
            for (int i = 0; i < this.Features.length; ++i) {
                String op = "=";
                if (this.Features[i].indexOf(62) > 0) {
                    op = ">";
                } else if (this.Features[i].indexOf(60) > 0) {
                    op = "<";
                }
                String[] f = this.Features[i].split("\\" + op);
                String fName = f[0];
                String fValue = null;
                if (f.length > 1) {
                    fValue = f[1];
                }
                if (fName.equals(F_Any)) {
                    sqlFlag = false;
                    continue;
                }
                if (fName.equals(F_NotNull)) {
                    if (value != null && !value.equals("")) continue;
                    this.Messages.add("\u4e0d\u80fd\u4e3a\u7a7a");
                    return false;
                }
                if (fName.equals(F_Code)) {
                    if (value == null || !value.equals("")) continue;
                    continue;
                }
                if (fName.equals(F_Date)) {
                    if (value == null || value.equals("") || DateUtil.isDate((String)value)) continue;
                    this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u503c");
                    verifyFlag = false;
                    continue;
                }
                if (fName.equals(F_Time)) {
                    if (value == null || value.equals("") || DateUtil.isTime((String)value)) continue;
                    this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u503c");
                    verifyFlag = false;
                    continue;
                }
                if (fName.equals(F_DateTime)) {
                    if (value == null || value.equals("")) continue;
                    String[] arr = value.split(" ");
                    if (arr.length == 1 && !DateUtil.isDate((String)arr[0])) {
                        this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u503c");
                        verifyFlag = false;
                        continue;
                    }
                    if (arr.length == 2) {
                        if (DateUtil.isDate((String)arr[0]) && DateUtil.isTime((String)arr[1])) continue;
                        this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u503c");
                        verifyFlag = false;
                        continue;
                    }
                    this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u65e5\u671f\u503c");
                    verifyFlag = false;
                    continue;
                }
                if (fName.equals(F_Number)) {
                    if (value == null || value.equals("")) continue;
                    try {
                        Double.parseDouble(value);
                    }
                    catch (Exception e) {
                        this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u6570\u503c");
                        verifyFlag = false;
                    }
                    continue;
                }
                if (fName.equals(F_Int)) {
                    if (value == null || value.equals("")) continue;
                    try {
                        Integer.parseInt(value);
                    }
                    catch (Exception e) {
                        this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u6574\u6570\u503c");
                        verifyFlag = false;
                    }
                    continue;
                }
                if (fName.equals(F_String)) {
                    if (value == null || value.equals("") || value.indexOf(39) < 0 && value.indexOf(34) < 0) continue;
                    this.Messages.add("\u53ef\u80fd\u662f\u975e\u6cd5\u5b57\u7b26\u4e32");
                    verifyFlag = false;
                    continue;
                }
                if (fName.equals(F_Email)) {
                    Matcher m;
                    if (value == null || value.equals("")) continue;
                    if (patternEmail == null) {
                        patternEmail = Pattern.compile(regEmail);
                    }
                    if ((m = patternEmail.matcher(value)).find()) continue;
                    this.Messages.add("\u4e0d\u662f\u6b63\u786e\u7684\u7535\u5b50\u90ae\u7bb1\u5730\u5740");
                    verifyFlag = false;
                    continue;
                }
                if (!fName.equals(A_Len) || value == null || value.equals("")) continue;
                if (fValue == null || fValue.equals("")) {
                    throw new RuntimeException("\u6821\u9a8c\u89c4\u5219\u9519\u8bef\uff0cLength\u540e\u9762\u5fc5\u987b\u662f\u6570\u5b57");
                }
                try {
                    int len = Integer.parseInt(fValue);
                    if (op.equals("=") && value.length() != len) {
                        this.Messages.add("\u957f\u5ea6\u5fc5\u987b\u662f" + len);
                        verifyFlag = false;
                        continue;
                    }
                    if (op.equals(">") && value.length() <= len) {
                        this.Messages.add("\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e" + len);
                        verifyFlag = false;
                        continue;
                    }
                    if (!op.equals("<") || value.length() < len) continue;
                    this.Messages.add("\u957f\u5ea6\u5fc5\u987b\u5c0f\u4e8e" + len);
                    verifyFlag = false;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("\u6821\u9a8c\u89c4\u5219\u9519\u8bef\uff0cLength\u540e\u9762\u5fc5\u987b\u662f\u6574\u6570");
                }
            }
            if (!(!sqlFlag || value == null || value.indexOf(" and ") <= 0 && value.indexOf(" or ") <= 0 || value.indexOf(33) <= 0 && value.indexOf(" like ") <= 0 && value.indexOf(61) <= 0 && value.indexOf(62) <= 0 && value.indexOf(60) <= 0)) {
                this.Messages.add("\u8bf7\u4e0d\u8981\u5c1d\u8bd5\u8f93\u5165SQL\u8bed\u53e5!");
                verifyFlag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u4e0d\u6b63\u786e\u7684\u6821\u9a8c\u89c4\u5219:" + this.Rule);
        }
        if (sqlFlag && !this.checkSQL(value)) {
            verifyFlag = false;
        }
        return verifyFlag;
    }

    public String getMessages(String fieldName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.Messages.size(); ++i) {
            sb.append(fieldName);
            sb.append(":");
            sb.append(this.Messages.get(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    private boolean checkSQL(String value) {
        return true;
    }

    protected String getRule() {
        return this.Rule;
    }

    protected void setRule(String rule) {
        this.Rule = rule;
    }

    public static void main(String[] args) {
        VerifyRule rule = new VerifyRule();
        rule.setRule(F_Email);
        System.out.println(rule.verify("wyuch_.-2@m165-a.com"));
        System.out.println(rule.getMessages("\u7535\u5b50\u90ae\u76f8"));
    }
}

