/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.collection;

import com.sobey.bsp.framework.data.DataColumn;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.listener.ExitEventListener;
import com.sobey.bsp.framework.listener.KeyNotFoundEventListener;
import com.sobey.bsp.framework.utility.DateUtil;
import com.sobey.bsp.framework.utility.LogUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Mapx<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1515780140368322L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INIT_CAPACITY = 16;
    private static final boolean DEFAULT_INIT_ACCESSORDER = false;
    private final int maxCapacity;
    private final boolean maxFlag;
    private int hitCount;
    private int missCount;
    private long lastWarnTime = 0L;
    private ExitEventListener<K, V> exitListener;
    private KeyNotFoundEventListener<K, V> getListener;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private Lock rlock = this.rwlock.readLock();
    private Lock wlock = this.rwlock.writeLock();

    public Mapx() {
        super(16, 0.75f, false);
        this.maxCapacity = 0;
        this.maxFlag = false;
    }

    public Mapx(int maxCapacity) {
        this(maxCapacity, true);
    }

    public Mapx(int maxCapacity, boolean lruFlag) {
        super(maxCapacity, 0.75f, lruFlag);
        this.maxCapacity = maxCapacity;
        this.maxFlag = true;
    }

    public Mapx<K, V> clone() {
        Mapx map = (Mapx)super.clone();
        return map;
    }

    public List<K> keyArray() {
        ArrayList list = new ArrayList();
        for (Object k : this.keySet()) {
            list.add(k);
        }
        return list;
    }

    public List<V> valueArray() {
        ArrayList list = new ArrayList();
        for (Object v : this.values()) {
            list.add(v);
        }
        return list;
    }

    public String getString(K k) {
        Object v = this.get(k);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public int getInt(K k) {
        Object v = this.get(k);
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v != null) {
            try {
                return Integer.parseInt(v.toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public Long getLong(K k) {
        Object v = this.get(k);
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v != null) {
            try {
                return Long.parseLong(v.toString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return 0L;
    }

    public Date getDate(K key) {
        Object v = this.get(key);
        if (v instanceof Date) {
            return (Date)v;
        }
        if (v != null) {
            try {
                return DateUtil.parse((String)v.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        if (this.getListener != null && !this.containsKey(key)) {
            Object k = key;
            try {
                Object v = this.getListener.findKeyValue(k);
                this.put(k, v);
                return (V)v;
            }
            catch (ClassCastException e) {
                return null;
            }
        }
        V v = null;
        this.rlock.lock();
        try {
            v = super.get(key);
        }
        finally {
            this.rlock.unlock();
        }
        if (this.maxFlag) {
            if (v == null) {
                ++this.missCount;
            } else {
                ++this.hitCount;
            }
            if (this.missCount > 1000 && (double)this.hitCount * 1.0 / (double)this.missCount < 0.1 && System.currentTimeMillis() - this.lastWarnTime > 1000000L) {
                this.lastWarnTime = System.currentTimeMillis();
                StackTraceElement[] stack = new Throwable().getStackTrace();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < stack.length; ++i) {
                    StackTraceElement ste = stack[i];
                    if (ste.getClassName().indexOf("DBConnPoolImpl") != -1) continue;
                    sb.append("\t");
                    sb.append(ste.getClassName());
                    sb.append(".");
                    sb.append(ste.getMethodName());
                    sb.append("(),\u884c\u53f7:");
                    sb.append(ste.getLineNumber());
                    sb.append("\n");
                }
                LogUtil.warn((Object)"\u7f13\u5b58\u547d\u4e2d\u7387\u8fc7\u4f4e!");
                LogUtil.warn((Object)sb);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object k) {
        this.rlock.lock();
        try {
            boolean bool;
            boolean bl = bool = super.containsKey(k);
            return bl;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.wlock.lock();
        try {
            super.clear();
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        this.wlock.lock();
        try {
            V previousValue;
            V v2 = previousValue = super.put(k, v);
            return v2;
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object k) {
        this.wlock.lock();
        try {
            Object previousValue;
            Object v = previousValue = super.remove(k);
            return v;
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object v) {
        this.rlock.lock();
        try {
            boolean bool;
            boolean bl = bool = super.containsValue(v);
            return bl;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public static <K, V> Mapx<K, V> convertToMapx(Map<? extends K, ? extends V> map) {
        Mapx mapx = new Mapx();
        mapx.putAll(map);
        return mapx;
    }

    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean flag;
        boolean bl = flag = this.maxFlag && this.size() > this.maxCapacity;
        if (flag && this.exitListener != null) {
            this.exitListener.onExit(eldest.getKey(), eldest.getValue());
        }
        return flag;
    }

    public void setExitEventListener(ExitEventListener<K, V> listener) {
        this.exitListener = listener;
    }

    public void setGetEventListener(KeyNotFoundEventListener<K, V> listener) {
        this.getListener = listener;
    }

    public DataTable toDataTable() {
        DataColumn[] dcs = new DataColumn[]{new DataColumn("Key", 1), new DataColumn("Value", 1)};
        List ks = this.keyArray();
        Object[][] vs = new Object[ks.size()][2];
        DataTable dt = new DataTable(dcs, vs);
        for (int i = 0; i < ks.size(); ++i) {
            dt.set(i, 0, ks.get(i));
            dt.set(i, 1, this.get(ks.get(i)));
        }
        return dt;
    }
}

