/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.common.util;

import com.sobey.bsp.framework.utility.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class FormatDateUtil {
    public static String format2Date(long dateTime, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = new Date(dateTime);
        return sdf.format(date);
    }

    public static String formatDateToString(Date date) {
        if (date == null || date.equals("")) {
            return "";
        }
        String format = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static String format2DateByFormat(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Long date2Long(String calendar) {
        SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        Date date = null;
        long dateFormat = 0L;
        try {
            dft.setLenient(false);
            date = dft.parse(calendar);
            dateFormat = date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateFormat;
    }

    public static Date parseDateByFormat(String parseStr, String format) {
        SimpleDateFormat dft = new SimpleDateFormat(format, Locale.ENGLISH);
        Date date = null;
        try {
            dft.setLenient(false);
            date = dft.parse(parseStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static long getTimeMillis(String timeStr) {
        long totalMillis = 0L;
        try {
            if (StringUtil.isNotEmpty((String)timeStr)) {
                int idx = timeStr.indexOf(":");
                int i = 0;
                String[] timeArray = new String[3];
                while (idx != -1) {
                    timeArray[i] = timeStr.substring(0, idx);
                    timeStr = timeStr.substring(idx + 1);
                    idx = timeStr.indexOf(":");
                    ++i;
                    if (idx != -1) continue;
                    timeArray[i] = timeStr;
                }
                if (timeArray.length > 0) {
                    long hourMillis = Long.parseLong(timeArray[0]) * 3600000L;
                    long minuteMillis = Long.parseLong(timeArray[1]) * 60000L;
                    long secondMillis = Long.parseLong(timeArray[2]) * 1000L;
                    totalMillis = hourMillis + minuteMillis + secondMillis;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return totalMillis;
    }

    public static Calendar getCurrentCalendar() {
        Calendar cal = Calendar.getInstance();
        int hour = cal.get(11);
        if (hour == 23) {
            cal.set(5, cal.get(5) + 1);
        }
        return cal;
    }

    public static String getCurrentDate(Calendar cal) {
        StringBuilder sb = new StringBuilder();
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(cal.get(2) + 1);
        String day = String.valueOf(cal.get(5));
        month = month.length() < 2 ? "0" + month : month;
        day = day.length() < 2 ? "0" + day : day;
        sb.append(year).append("-").append(month).append("-").append(day);
        return sb.toString();
    }
}

