/*
 * Decompiled with CFR 0.152.
 */
package com.sobey.bsp.framework.controls;

import com.sobey.bsp.framework.Constant;
import com.sobey.bsp.framework.controls.HtmlScript;
import com.sobey.bsp.framework.controls.IControlAction;
import com.sobey.bsp.framework.controls.PageBarTag;
import com.sobey.bsp.framework.data.DataTable;
import com.sobey.bsp.framework.data.QueryBuilder;
import com.sobey.bsp.framework.orm.SchemaSet;
import com.sobey.bsp.framework.utility.HtmlUtil;
import com.sobey.bsp.framework.utility.Mapx;
import com.sobey.bsp.framework.utility.StringUtil;
import java.util.regex.Matcher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class DataListAction
implements IControlAction {
    private DataTable DataSource;
    private String ID;
    private String TagBody;
    private boolean page;
    protected Mapx Params = new Mapx();
    private JSONObject Json;
    private String method;
    private int total;
    private int pageIndex;
    private int pageSize;

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Mapx getParams() {
        return this.Params;
    }

    public void setParams(Mapx params) {
        this.Params = params;
    }

    public String getParam(String key) {
        return this.Params.getString((Object)key);
    }

    public void bindData(DataTable dt) {
        this.DataSource = dt;
        try {
            this.bindData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bindData(SchemaSet set) {
        this.bindData(set.toDataTable());
    }

    private void bindData() throws Exception {
        HtmlUtil.replaceWithDataTable((DataTable)this.DataSource, (String)this.TagBody);
    }

    public String getHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!--_ZVING_DATALIST_START_" + this.ID + "-->");
        sb.append("<input type='hidden' id='" + this.ID + "' method='" + this.method + "'>");
        sb.append(HtmlUtil.replaceWithDataTable((DataTable)this.DataSource, (String)this.TagBody));
        HtmlScript script = new HtmlScript();
        script.setInnerHTML(this.getScript());
        sb.append(script.getOuterHtml());
        sb.append("<!--_ZVING_DATALIST_END_" + this.ID + "-->");
        return sb.toString();
    }

    public String getScript() {
        StringBuffer sb = new StringBuffer();
        sb.append("$('" + this.ID + "').TagBody = \"" + StringUtil.htmlEncode((String)this.getTagBody().replaceAll("\\s+", " ")) + "\";");
        Object[] ks = this.Params.keyArray();
        Object[] vs = this.Params.valueArray();
        for (int i = 0; i < this.Params.size(); ++i) {
            Object key = ks[i];
            if (key.equals("_ZVING_TAGBODY") || key.toString().startsWith("Cookie.") || key.toString().startsWith("Header.")) continue;
            sb.append("DataList.setParam('" + this.ID + "','" + key + "',\"" + vs[i] + "\");");
        }
        if (this.page) {
            int type = 1;
            if (StringUtil.isNotEmpty((String)this.Params.getString((Object)"PageBarType"))) {
                type = Integer.parseInt(this.Params.getString((Object)"PageBarType"));
            }
            String html = PageBarTag.getPageBarHtml((String)this.ID, (int)type, (int)this.total, (int)this.pageSize, (int)this.pageIndex);
            sb.append("\ntry{$('_PageBar_" + this.ID + "').innerHTML=\"" + StringUtil.javaEncode((String)html) + "\";}catch(ex){}\n");
        }
        sb.append("DataList.setParam('" + this.ID + "','" + "_ZVING_PAGEINDEX" + "'," + this.pageIndex + ");");
        sb.append("DataList.setParam('" + this.ID + "','" + "_ZVING_PAGETOTAL" + "'," + this.total + ");");
        sb.append("DataList.setParam('" + this.ID + "','" + "_ZVING_PAGE" + "'," + this.page + ");");
        sb.append("DataList.setParam('" + this.ID + "','" + "_ZVING_SIZE" + "'," + this.pageSize + ");");
        sb.append("");
        sb.append("DataList.init('" + this.ID + "');");
        String content = sb.toString();
        Matcher matcher = Constant.PatternField.matcher(content);
        sb = new StringBuffer();
        int lastEndIndex = 0;
        while (matcher.find(lastEndIndex)) {
            sb.append(content.substring(lastEndIndex, matcher.start()));
            sb.append("$\\{");
            sb.append(matcher.group(1));
            sb.append("}");
            lastEndIndex = matcher.end();
        }
        sb.append(content.substring(lastEndIndex));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataTable2JSON(DataTable dt) {
        JSONObject jo = new JSONObject();
        JSONArray ja = new JSONArray();
        try {
            this.DataSource = dt == null || dt.getRowCount() == 0 ? new DataTable() : dt;
            JSONObject item = null;
            for (int i = 0; i < this.DataSource.getRowCount(); ++i) {
                item = new JSONObject();
                for (int j = 0; j < this.DataSource.getColCount(); ++j) {
                    String key = this.DataSource.getDataColumn(j).getColumnName().toLowerCase();
                    String value = this.DataSource.getString(i, j);
                    item.put((Object)key, (Object)value);
                }
                ja.add((Object)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            jo.put((Object)"total", (Object)this.getTotal());
            jo.put((Object)"page", (Object)this.getPageIndex());
            jo.put((Object)"pagesize", (Object)this.getPageSize());
            jo.put((Object)"data", (Object)ja);
        }
        this.Json = jo;
    }

    public String getTagBody() {
        return this.TagBody;
    }

    public void setTagBody(String tagBody) {
        this.TagBody = tagBody;
    }

    public JSONObject getJson() {
        return this.Json;
    }

    public void setJson(JSONObject json) {
        this.Json = json;
    }

    public DataTable getDataSource() {
        return this.DataSource;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public boolean isPage() {
        return this.page;
    }

    public void setPage(boolean page) {
        this.page = page;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setTotal(QueryBuilder qb) {
        this.setTotal(qb.executeInt());
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

